/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonHandler;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.network.messages.server.colony.building.home.AssignUnassignMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class WindowAssignCitizen
extends Window
implements ButtonHandler {
    private final IBuildingView building;
    private final ScrollingList citizenList;
    private final IColonyView colony;
    private List<ICitizenDataView> citizens = new ArrayList<ICitizenDataView>();

    public WindowAssignCitizen(IColonyView c, BlockPos buildingId) {
        super("minecolonies:gui/windowassigncitizen.xml");
        this.colony = c;
        this.building = this.colony.getBuilding(buildingId);
        this.citizenList = (ScrollingList)this.findPaneOfTypeByID("unassigned", ScrollingList.class);
        this.updateCitizens();
    }

    private void updateCitizens() {
        this.citizens.clear();
        this.citizens.addAll(this.colony.getCitizens().values());
        this.citizens = this.colony.getCitizens().values().stream().filter(cit -> cit.getHomeBuilding() == null || !(this.colony.getBuilding(cit.getHomeBuilding()) instanceof AbstractBuildingGuards.View) && !cit.getHomeBuilding().equals((Object)this.building.getID())).sorted(Comparator.comparing(ICitizen::getName)).collect(Collectors.toList());
    }

    public void onOpened() {
        this.updateCitizens();
        this.citizenList.enable();
        this.citizenList.show();
        this.citizenList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowAssignCitizen.this.citizens.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ICitizenDataView citizen = (ICitizenDataView)WindowAssignCitizen.this.citizens.get(index);
                if (WindowAssignCitizen.this.building instanceof BuildingHome.View) {
                    ((Label)rowPane.findPaneOfTypeByID("citizen", Label.class)).setLabelText(citizen.getName());
                    BlockPos work = citizen.getWorkBuilding();
                    String workString = "";
                    if (work != null) {
                        workString = " " + BlockPosUtil.getDistance2D(work, WindowAssignCitizen.this.building.getPosition()) + " blocks";
                    }
                    BlockPos home = citizen.getHomeBuilding();
                    String homeString = "";
                    if (home != null) {
                        homeString = work != null ? LanguageHandler.format((String)"com.minecolonies.coremod.gui.homeHut.currently", (Object[])new Object[]{BlockPosUtil.getDistance2D(work, home)}) : LanguageHandler.format((String)"com.minecolonies.coremod.gui.homeHut.current", (Object[])new Object[]{home.func_177958_n(), home.func_177956_o(), home.func_177952_p()});
                    }
                    ((Label)rowPane.findPaneOfTypeByID("job", Label.class)).setLabelText(LanguageHandler.format((String)citizen.getJob(), (Object[])new Object[0]) + workString);
                    ((Label)rowPane.findPaneOfTypeByID("living", Label.class)).setLabelText(homeString);
                    Button done = (Button)rowPane.findPaneOfTypeByID("done", Button.class);
                    if (WindowAssignCitizen.this.colony.isManualHousing()) {
                        done.enable();
                    } else {
                        done.disable();
                    }
                }
            }
        });
    }

    public void onUpdate() {
        this.updateCitizens();
        ((ScrollingList)this.window.findPaneOfTypeByID("unassigned", ScrollingList.class)).refreshElementPanes();
    }

    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals("done")) {
            int row = this.citizenList.getListElementIndexByPane((Pane)button);
            ICitizenDataView data = this.citizens.get(row);
            if (this.building instanceof BuildingHome.View) {
                ((BuildingHome.View)this.building).addResident(data.getId());
            }
            Network.getNetwork().sendToServer(new AssignUnassignMessage(this.building, true, data.getId()));
        } else if (!button.getID().equals("cancel")) {
            return;
        }
        if (this.colony.getTownHall() != null) {
            this.building.openGui(false);
        }
    }
}

