/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.Alignment;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Image;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.SwitchView;
import com.ldtteam.blockout.views.View;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.WindowConstants;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowRequestTree;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowHutBuilder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLibrary;
import com.minecolonies.coremod.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.coremod.network.messages.server.colony.UpdateRequestStateMessage;
import com.minecolonies.coremod.network.messages.server.colony.citizen.AdjustSkillCitizenMessage;
import com.minecolonies.coremod.network.messages.server.colony.citizen.TransferItemsToCitizenRequestMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class WindowCitizen
extends AbstractWindowRequestTree {
    private final ICitizenDataView citizen;
    private int tick = 0;
    private final PlayerInventory inventory;
    private final boolean isCreative;

    public WindowCitizen(ICitizenDataView citizen) {
        super(citizen.getWorkBuilding(), "minecolonies:gui/citizen/windowcitizen.xml", IColonyManager.getInstance().getColonyView(citizen.getColonyId(), Minecraft.func_71410_x().field_71441_e.func_201675_m().func_186058_p().func_186068_a()));
        this.inventory = this.mc.field_71439_g.field_71071_by;
        this.isCreative = this.mc.field_71439_g.func_184812_l_();
        this.citizen = citizen;
        if (citizen.getVisibleStatus() == null) {
            ((Image)this.findPaneOfTypeByID("statusicon", Image.class)).setVisible(false);
        } else {
            ((Image)this.findPaneOfTypeByID("statusicon", Image.class)).setImage(citizen.getVisibleStatus().getIcon());
            ((Image)this.findPaneOfTypeByID("statusicon", Image.class)).setHoverToolTip(Collections.singletonList(citizen.getVisibleStatus().getTranslatedText()));
        }
        WindowCitizen.updateJobPage(citizen, this, this.colony);
    }

    public ICitizenDataView getCitizen() {
        return this.citizen;
    }

    @Override
    public boolean canFulFill() {
        return true;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.tick++ == 20) {
            this.tick = 0;
            WindowCitizen.createSkillContent(this.citizen, this);
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        ((Label)this.findPaneOfTypeByID("name", Label.class)).setLabelText(this.citizen.getName());
        WindowCitizen.createHealthBar(this.citizen, (View)this.findPaneOfTypeByID("healthBar", View.class));
        WindowCitizen.createSaturationBar(this.citizen, (View)this);
        WindowCitizen.createHappinessBar(this.citizen, this);
        WindowCitizen.createSkillContent(this.citizen, this);
        WindowCitizen.updateHappiness(this.citizen, this);
        if (this.citizen.isFemale()) {
            ((Image)this.findPaneOfTypeByID("gender", Image.class)).setImage("minecolonies:textures/gui/citizen/colonist_wax_female_smaller.png");
        }
        this.setPage("");
    }

    public static void createHealthBar(ICitizenDataView citizen, View healthBarView) {
        int health = (int)citizen.getHealth();
        healthBarView.setAlignment(Alignment.MIDDLE_RIGHT);
        ((Label)healthBarView.findPaneOfTypeByID("healthLabel", Label.class)).setLabelText(Integer.toString(health / 2));
        for (int i = 0; i < 10; ++i) {
            WindowCitizen.addHeart(healthBarView, i, HeartsEnum.EMPTY);
        }
        int heartPos = 0;
        ArrayList<HeartsEnum> heartList = new ArrayList<HeartsEnum>();
        heartList.add(HeartsEnum.BLUE);
        heartList.add(HeartsEnum.GREEN);
        heartList.add(HeartsEnum.GOLDEN);
        heartList.add(HeartsEnum.RED);
        for (HeartsEnum heart : heartList) {
            if (heart.isHalfHeart || heart.prevHeart == null) continue;
            for (int i = heartPos; i < 10 && health > heart.prevHeart.hpValue * 10 + 1; ++i) {
                WindowCitizen.addHeart(healthBarView, heartPos, heart);
                health -= heart.hpValue - heart.prevHeart.hpValue;
                ++heartPos;
            }
            if (health % 2 == 1 && heartPos < 10 && heart.halfHeart != null && health > heart.prevHeart.hpValue * 10) {
                WindowCitizen.addHeart(healthBarView, heartPos, heart.prevHeart);
                WindowCitizen.addHeart(healthBarView, heartPos, heart.halfHeart);
                health -= heart.halfHeart.hpValue - heart.prevHeart.hpValue;
                ++heartPos;
            }
            if (heartPos < 10) continue;
            return;
        }
    }

    private static void addHeart(View healthBarView, int heartPos, HeartsEnum heart) {
        Image heartImage = new Image();
        heartImage.setImage(heart.Image, heart.X, heart.Y, 9, 9, false);
        heartImage.setPosition(heartPos * 10 + 10, 10);
        healthBarView.addChild((Pane)heartImage);
    }

    public static void createSaturationBar(ICitizenDataView citizen, View view) {
        int saturationPos;
        Image saturation;
        ((View)view.findPaneOfTypeByID("saturationBar", View.class)).setAlignment(Alignment.MIDDLE_RIGHT);
        for (int i = 0; i < 10; ++i) {
            saturation = new Image();
            saturation.setImage(Screen.GUI_ICONS_LOCATION, 16, 27, 9, 9, false);
            saturation.setPosition(i * 10 + 10, 10);
            ((View)view.findPaneOfTypeByID("saturationBar", View.class)).addChild((Pane)saturation);
        }
        for (saturationPos = 0; saturationPos < (int)citizen.getSaturation(); ++saturationPos) {
            saturation = new Image();
            saturation.setImage(Screen.GUI_ICONS_LOCATION, 52, 27, 9, 9, false);
            saturation.setPosition(saturationPos * 10 + 10, 10);
            ((View)view.findPaneOfTypeByID("saturationBar", View.class)).addChild((Pane)saturation);
        }
        if (citizen.getSaturation() / 2.0 % 1.0 > 0.0) {
            saturation = new Image();
            saturation.setImage(Screen.GUI_ICONS_LOCATION, 61, 27, 9, 9, false);
            saturation.setPosition(saturationPos * 10 + 10, 10);
            ((View)view.findPaneOfTypeByID("saturationBar", View.class)).addChild((Pane)saturation);
        }
    }

    public static void createHappinessBar(ICitizenDataView citizen, AbstractWindowSkeleton window) {
        double experienceRatio = citizen.getHappiness() / 10.0 * 91.0;
        ((View)window.findPaneOfTypeByID("happinessBar", View.class)).setAlignment(Alignment.MIDDLE_RIGHT);
        ((Label)window.findPaneOfTypeByID("happinessLabel", Label.class)).setLabelText(Integer.toString((int)citizen.getHappiness()));
        Image xpBar = new Image();
        xpBar.setImage(Screen.GUI_ICONS_LOCATION, 0, 74, 91, 5, false);
        xpBar.setPosition(10, 10);
        Image xpBar2 = new Image();
        xpBar2.setImage(Screen.GUI_ICONS_LOCATION, 172, 74, 10, 5, false);
        xpBar2.setPosition(100, 10);
        ((View)window.findPaneOfTypeByID("happinessBar", View.class)).addChild((Pane)xpBar);
        ((View)window.findPaneOfTypeByID("happinessBar", View.class)).addChild((Pane)xpBar2);
        if (experienceRatio > 0.0) {
            Image xpBarFull = new Image();
            xpBarFull.setImage(Screen.GUI_ICONS_LOCATION, 0, 79, (int)experienceRatio, 5, false);
            xpBarFull.setPosition(10, 10);
            ((View)window.findPaneOfTypeByID("happinessBar", View.class)).addChild((Pane)xpBarFull);
        }
    }

    public static void createSkillContent(ICitizenDataView citizen, AbstractWindowSkeleton window) {
        boolean isCreative = Minecraft.func_71410_x().field_71439_g.func_184812_l_();
        for (Map.Entry<Skill, Tuple<Integer, Double>> entry : citizen.getCitizenSkillHandler().getSkills().entrySet()) {
            Label label = (Label)window.findPaneOfTypeByID(entry.getKey().name().toLowerCase(Locale.US), Label.class);
            label.setLabelText(LanguageHandler.format((String)("com.minecolonies.coremod.gui.citizen.skills." + entry.getKey().name().toLowerCase(Locale.US)), (Object[])new Object[]{entry.getValue().func_76341_a()}));
            label.setScale(0.8f);
            if (!isCreative) continue;
            Button buttonPlus = (Button)window.findPaneOfTypeByID("plus_" + entry.getKey().name().toLowerCase(Locale.US), Button.class);
            Button buttonMinus = (Button)window.findPaneOfTypeByID("minus_" + entry.getKey().name().toLowerCase(Locale.US), Button.class);
            if (buttonPlus == null || buttonMinus == null) continue;
            buttonPlus.setVisible(true);
            buttonMinus.setVisible(true);
        }
    }

    @Override
    public ImmutableList<IRequest<?>> getOpenRequestsFromBuilding(IBuildingView building) {
        return building.getOpenRequests(this.citizen);
    }

    public void goToRequestList() {
        ((SwitchView)this.findPaneOfTypeByID("head", SwitchView.class)).nextView();
        this.buttonPrevPage.off();
        this.buttonNextPage.off();
        this.pageNum.off();
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        Skill skill;
        String label;
        if (button.getID().contains("plus_")) {
            label = button.getID().replace("plus_", "");
            skill = Skill.valueOf(StringUtils.capitalize((String)label));
            Network.getNetwork().sendToServer(new AdjustSkillCitizenMessage(this.colony, this.citizen, 1, skill));
        } else if (button.getID().contains("minus_")) {
            label = button.getID().replace("minus_", "");
            skill = Skill.valueOf(StringUtils.capitalize((String)label));
            Network.getNetwork().sendToServer(new AdjustSkillCitizenMessage(this.colony, this.citizen, -1, skill));
        }
        switch (button.getID()) {
            case "requestsTitle": {
                this.goToRequestList();
                break;
            }
            case "back": {
                ((SwitchView)this.findPaneOfTypeByID("head", SwitchView.class)).previousView();
                this.setPage("");
                break;
            }
            case "inventory": {
                Network.getNetwork().sendToServer(new OpenInventoryMessage(this.colony, this.citizen.getName(), this.citizen.getEntityId()));
                break;
            }
            default: {
                super.onButtonClicked(button);
            }
        }
    }

    @Override
    public void fulfill(@NotNull IRequest<?> tRequest) {
        ItemStack itemStack;
        if (!(tRequest.getRequest() instanceof IDeliverable)) {
            return;
        }
        IRequest<?> request = tRequest;
        Predicate<ItemStack> requestPredicate = stack -> ((IDeliverable)request.getRequest()).matches((ItemStack)stack);
        int amount = ((IDeliverable)request.getRequest()).getCount();
        int count = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.inventory), requestPredicate);
        if (!this.isCreative && count <= 0) {
            return;
        }
        if (this.isCreative) {
            itemStack = request.getDisplayStacks().stream().findFirst().orElse(ItemStack.field_190927_a);
        } else {
            List<Integer> slots = InventoryUtils.findAllSlotsInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.inventory), requestPredicate);
            int invSize = this.inventory.func_70302_i_() - 5;
            int slot = -1;
            for (Integer possibleSlot : slots) {
                if (possibleSlot >= invSize) continue;
                slot = possibleSlot;
                break;
            }
            if (slot == -1) {
                ITextComponent chatMessage = new StringTextComponent("<" + this.citizen.getName() + "> " + LanguageHandler.format((String)"com.minecolonies.coremod.general.canttakeequipped", (Object[])new Object[]{this.citizen.getName()})).func_150255_a(new Style().func_150227_a(Boolean.valueOf(false)).func_150238_a(TextFormatting.WHITE));
                Minecraft.func_71410_x().field_71439_g.func_145747_a(chatMessage);
                return;
            }
            itemStack = this.inventory.func_70301_a(slot);
        }
        if (this.citizen.getWorkBuilding() != null) {
            this.colony.getBuilding(this.citizen.getWorkBuilding()).onRequestedRequestComplete(this.colony.getRequestManager(), tRequest);
        }
        Network.getNetwork().sendToServer(new TransferItemsToCitizenRequestMessage(this.colony, this.citizen, itemStack, this.isCreative ? amount : Math.min(amount, count)));
        ItemStack copy = itemStack.func_77946_l();
        copy.func_190920_e(this.isCreative ? amount : Math.min(amount, count));
        Network.getNetwork().sendToServer(new UpdateRequestStateMessage(this.colony, (IToken<?>)request.getId(), RequestState.OVERRULED, copy));
    }

    public static void updateHappiness(ICitizenDataView citizen, AbstractWindowSkeleton window) {
        View pane = (View)window.findPaneOfTypeByID("happinessModifierView", View.class);
        ((Label)window.findPaneOfTypeByID("happinessModifier", Label.class)).setLabelText(LanguageHandler.format((String)"com.minecolonies.coremod.gui.happiness.happinessmodifier", (Object[])new Object[0]));
        int yPos = 62;
        for (String name : citizen.getHappinessHandler().getModifiers()) {
            double value = citizen.getHappinessHandler().getModifier(name).getFactor();
            Image image = new Image();
            image.setSize(11, 11);
            image.setPosition(25, yPos);
            Label label = new Label();
            label.setSize(136, 11);
            label.setPosition(50, yPos);
            label.setColor(WindowHutBuilder.BLACK);
            label.setLabelText(LanguageHandler.format((String)("com.minecolonies.coremod.gui.townhall.happiness." + name), (Object[])new Object[0]));
            if (value > 1.0) {
                image.setImage("minecolonies:textures/gui/green_icon.png");
            } else if (value == 1.0) {
                image.setImage("minecolonies:textures/gui/blue_icon.png");
            } else if (value > 0.75) {
                image.setImage("minecolonies:textures/gui/yellow_icon.png");
            } else {
                image.setImage("minecolonies:textures/gui/red_icon.png");
            }
            pane.addChild((Pane)image);
            pane.addChild((Pane)label);
            yPos += 12;
        }
    }

    private static void updateJobPage(ICitizenDataView citizen, WindowCitizen windowCitizen, IColonyView colony) {
        IBuildingView building = colony.getBuilding(citizen.getWorkBuilding());
        if (building instanceof AbstractBuildingWorker.View && !(building instanceof BuildingLibrary.View)) {
            ((Label)windowCitizen.findPaneOfTypeByID("jobLabel", Label.class)).setLabelText(LanguageHandler.format((String)"com.minecolonies.coremod.gui.citizen.job.label", (Object[])new Object[]{LanguageHandler.format((String)citizen.getJob(), (Object[])new Object[0])}));
            ((Text)windowCitizen.findPaneOfTypeByID("skillexplanation", Text.class)).setTextContent(LanguageHandler.format((String)"com.minecolonies.coremod.gui.citizen.job.desc", (Object[])new Object[0]));
            Skill primary = ((AbstractBuildingWorker.View)building).getPrimarySkill();
            ((Label)windowCitizen.findPaneOfTypeByID("primary", Label.class)).setLabelText(LanguageHandler.format((String)("com.minecolonies.coremod.gui.citizen.job.skills." + primary.name().toLowerCase(Locale.US)), (Object[])new Object[0]) + " (100% XP)");
            ((Image)windowCitizen.findPaneOfTypeByID("primaryimg", Image.class)).setImage("minecolonies:textures/entity/skills/small/" + primary.name().toLowerCase(Locale.US) + ".png");
            if (primary.getComplimentary() != null && primary.getAdverse() != null) {
                ((Label)windowCitizen.findPaneOfTypeByID("comp1", Label.class)).setLabelText(LanguageHandler.format((String)("com.minecolonies.coremod.gui.citizen.job.skills." + primary.getComplimentary().name().toLowerCase(Locale.US)), (Object[])new Object[0]) + " (" + 10 + "% XP)");
                ((Image)windowCitizen.findPaneOfTypeByID("comp1img", Image.class)).setImage("minecolonies:textures/entity/skills/small/" + primary.getComplimentary().name().toLowerCase(Locale.US) + ".png");
                ((Label)windowCitizen.findPaneOfTypeByID("adverse1", Label.class)).setLabelText(LanguageHandler.format((String)("com.minecolonies.coremod.gui.citizen.job.skills." + primary.getAdverse().name().toLowerCase(Locale.US)), (Object[])new Object[0]) + " (-" + 10 + "% XP)");
                ((Image)windowCitizen.findPaneOfTypeByID("adverse1img", Image.class)).setImage("minecolonies:textures/entity/skills/small/" + primary.getAdverse().name().toLowerCase(Locale.US) + ".png");
            }
            Skill secondary = ((AbstractBuildingWorker.View)building).getSecondarySkill();
            ((Label)windowCitizen.findPaneOfTypeByID("secondary", Label.class)).setLabelText(LanguageHandler.format((String)("com.minecolonies.coremod.gui.citizen.job.skills." + secondary.name().toLowerCase(Locale.US)), (Object[])new Object[0]) + " (50% XP)");
            ((Image)windowCitizen.findPaneOfTypeByID("secondaryimg", Image.class)).setImage("minecolonies:textures/entity/skills/small/" + secondary.name().toLowerCase(Locale.US) + ".png");
            if (secondary.getComplimentary() != null && secondary.getAdverse() != null) {
                ((Label)windowCitizen.findPaneOfTypeByID("comp2", Label.class)).setLabelText(LanguageHandler.format((String)("com.minecolonies.coremod.gui.citizen.job.skills." + secondary.getComplimentary().name().toLowerCase(Locale.US)), (Object[])new Object[0]) + " (" + 5 + "% XP)");
                ((Image)windowCitizen.findPaneOfTypeByID("comp2img", Image.class)).setImage("minecolonies:textures/entity/skills/small/" + secondary.getComplimentary().name().toLowerCase(Locale.US) + ".png");
                ((Label)windowCitizen.findPaneOfTypeByID("adverse2", Label.class)).setLabelText(LanguageHandler.format((String)("com.minecolonies.coremod.gui.citizen.job.skills." + secondary.getAdverse().name().toLowerCase(Locale.US)), (Object[])new Object[0]) + " (-" + 5 + "% XP)");
                ((Image)windowCitizen.findPaneOfTypeByID("adverse2img", Image.class)).setImage("minecolonies:textures/entity/skills/small/" + secondary.getAdverse().name().toLowerCase(Locale.US) + ".png");
            }
        } else {
            ((Image)windowCitizen.findPaneOfTypeByID("primaryimg", Image.class)).hide();
            ((Image)windowCitizen.findPaneOfTypeByID("comp1img", Image.class)).hide();
            ((Image)windowCitizen.findPaneOfTypeByID("adverse1img", Image.class)).hide();
            ((Image)windowCitizen.findPaneOfTypeByID("secondaryimg", Image.class)).hide();
            ((Image)windowCitizen.findPaneOfTypeByID("comp2img", Image.class)).hide();
            ((Image)windowCitizen.findPaneOfTypeByID("adverse2img", Image.class)).hide();
        }
    }

    private static enum HeartsEnum {
        EMPTY(Screen.GUI_ICONS_LOCATION, 16, 0, 0, null, null),
        HALF_RED(Screen.GUI_ICONS_LOCATION, 61, 0, 1, null, EMPTY),
        RED(Screen.GUI_ICONS_LOCATION, 52, 0, 2, HALF_RED, EMPTY),
        HALF_GOLDEN(Screen.GUI_ICONS_LOCATION, 169, 0, 3, null, RED),
        GOLDEN(Screen.GUI_ICONS_LOCATION, 160, 0, 4, HALF_GOLDEN, RED),
        HALF_GREEN(WindowConstants.GREEN_BLUE_ICON, 8, 0, 5, null, GOLDEN),
        GREEN(WindowConstants.GREEN_BLUE_ICON, 0, 0, 6, HALF_GREEN, GOLDEN),
        HALF_BLUE(WindowConstants.GREEN_BLUE_ICON, 8, 8, 7, null, GREEN),
        BLUE(WindowConstants.GREEN_BLUE_ICON, 0, 8, 8, HALF_BLUE, GREEN);

        public final int X;
        public final int Y;
        public final int hpValue;
        public final HeartsEnum prevHeart;
        public final HeartsEnum halfHeart;
        public boolean isHalfHeart = false;
        public final ResourceLocation Image;

        private HeartsEnum(ResourceLocation heartImage, int x, int y, int hpValue, HeartsEnum halfHeart, HeartsEnum prevHeart) {
            this.Image = heartImage;
            this.X = x;
            this.Y = y;
            this.hpValue = hpValue;
            this.halfHeart = halfHeart;
            if (halfHeart == null) {
                this.isHalfHeart = true;
            }
            this.prevHeart = prevHeart;
        }
    }
}

