/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Image;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowRequestDetail;
import com.minecolonies.coremod.network.messages.server.colony.UpdateRequestStateMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.NotNull;

public class WindowClipBoard
extends AbstractWindowSkeleton {
    private static final String BUILD_TOOL_RESOURCE_SUFFIX = ":gui/windowclipboard.xml";
    private static final String WINDOW_ID_LIST_REQUESTS = "requests";
    private static final String LIST_ELEMENT_ID_REQUEST_STACK = "requestStack";
    private static final String REQUEST_CANCEL = "cancel";
    private static final String REQUEST_DETAIL = "detail";
    private static final String REQUEST_SHORT_DETAIL = "shortDetail";
    private static final String DELIVERY_IMAGE = "deliveryImage";
    private static final String REQUESTER = "requester";
    private static final int LIFE_COUNT_DIVIDER = 30;
    private final List<IToken<?>> asyncRequest = new ArrayList();
    private ScrollingList resourceList;
    private final IColonyView colony;
    private int lifeCount = 0;
    private boolean hide = false;

    public WindowClipBoard(IColonyView colony) {
        super("minecolonies:gui/windowclipboard.xml");
        this.colony = colony;
        for (ICitizenDataView view : this.colony.getCitizens().values()) {
            if (view.getJobView() == null) continue;
            this.asyncRequest.addAll(view.getJobView().getAsyncRequests());
        }
        this.registerButton("important", this::toggleImportant);
    }

    private void toggleImportant() {
        this.hide = !this.hide;
        this.fillList();
    }

    public void onOpened() {
        this.fillList();
    }

    private void fillList() {
        this.resourceList = (ScrollingList)this.findPaneOfTypeByID(WINDOW_ID_LIST_REQUESTS, ScrollingList.class);
        this.resourceList.setDataProvider(() -> this.getOpenRequests().size(), (index, rowPane) -> {
            ImmutableList<IRequest<?>> openRequests = this.getOpenRequests();
            if (index < 0 || index >= openRequests.size()) {
                return;
            }
            IRequest request = (IRequest)openRequests.get(index);
            ItemIcon exampleStackDisplay = (ItemIcon)rowPane.findPaneOfTypeByID(LIST_ELEMENT_ID_REQUEST_STACK, ItemIcon.class);
            List<ItemStack> displayStacks = request.getDisplayStacks();
            if (!displayStacks.isEmpty()) {
                if (exampleStackDisplay != null) {
                    exampleStackDisplay.setItem(displayStacks.get(this.lifeCount / 30 % displayStacks.size()));
                }
            } else {
                Image logo = (Image)rowPane.findPaneOfTypeByID(DELIVERY_IMAGE, Image.class);
                logo.setVisible(true);
                logo.setImage(request.getDisplayIcon());
            }
            ((Label)rowPane.findPaneOfTypeByID(REQUESTER, Label.class)).setLabelText(request.getRequester().getRequesterDisplayName(this.colony.getRequestManager(), request).func_150254_d());
            ((Label)rowPane.findPaneOfTypeByID(REQUEST_SHORT_DETAIL, Label.class)).setLabelText(request.getShortDisplayString().func_150254_d().replace("\u00a7f", ""));
        });
    }

    public ImmutableList<IRequest<?>> getOpenRequests() {
        ArrayList requests = Lists.newArrayList();
        if (this.colony == null) {
            return ImmutableList.of();
        }
        IRequestManager requestManager = this.colony.getRequestManager();
        if (requestManager == null) {
            return ImmutableList.of();
        }
        IPlayerRequestResolver resolver = requestManager.getPlayerResolver();
        IRetryingRequestResolver retryingRequestResolver = requestManager.getRetryingRequestResolver();
        HashSet requestTokens = new HashSet();
        requestTokens.addAll((Collection<IToken<?>>)resolver.getAllAssignedRequests());
        requestTokens.addAll((Collection<IToken<?>>)retryingRequestResolver.getAllAssignedRequests());
        requests.addAll(requestTokens.stream().map(requestManager::getRequestForToken).filter(Objects::nonNull).collect(Collectors.toSet()));
        if (this.hide) {
            requests.removeIf(req -> this.asyncRequest.contains(req.getId()));
        }
        BlockPos playerPos = Minecraft.func_71410_x().field_71439_g.func_180425_c();
        requests.sort(Comparator.comparing(request -> request.getRequester().getLocation().getInDimensionLocation().func_177951_i(new Vec3i(playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p()))).thenComparingInt(request -> request.getId().hashCode()));
        return ImmutableList.copyOf((Collection)requests);
    }

    public void onUpdate() {
        super.onUpdate();
        if (!Screen.hasShiftDown()) {
            ++this.lifeCount;
        }
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        switch (button.getID()) {
            case "detail": {
                this.detailedClicked(button);
                break;
            }
            case "cancel": {
                this.cancel(button);
                break;
            }
            default: {
                super.onButtonClicked(button);
            }
        }
    }

    private void detailedClicked(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        if (this.getOpenRequests().size() > row && row >= 0) {
            WindowRequestDetail window = new WindowRequestDetail(this, (IRequest)this.getOpenRequests().get(row), this.colony.getID());
            window.open();
        }
    }

    private void cancel(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        if (this.getOpenRequests().size() > row && row >= 0) {
            IRequest request = (IRequest)this.getOpenRequests().get(row);
            Network.getNetwork().sendToServer(new UpdateRequestStateMessage(this.colony, (IToken<?>)request.getId(), RequestState.CANCELLED, null));
        }
    }
}

