/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.View;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.util.constant.WindowConstants;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowCitizen;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.network.messages.server.colony.GuardScepterMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.guard.GuardRecalculateMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.guard.GuardTaskMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class WindowGuardControl
extends AbstractWindowSkeleton {
    private final Button buttonTaskPatrol;
    private final Button buttonTaskFollow;
    private final Button buttonTaskGuard;
    private final Button buttonSetTarget;
    private ScrollingList listOfPoints;
    private boolean retrieveOnLowHealth = false;
    private boolean patrolManually = false;
    private boolean tightGrouping = true;
    private boolean hireTrainees = true;
    private GuardTask task = GuardTask.GUARD;
    private List<BlockPos> patrolTargets = new ArrayList<BlockPos>();
    private ScrollingList workersListPane;
    private AbstractBuildingGuards.View building;

    public WindowGuardControl(AbstractBuildingGuards.View building) {
        super("minecolonies:gui/windowguardcontrol.xml");
        this.building = building;
        this.registerButton("patrol", this::switchPatrolMode);
        this.registerButton("retrieve", this::switchRetrievalMode);
        this.registerButton("trainees", this::switchTraineeMode);
        this.registerButton("recalculate", this::recalculate);
        this.registerButton("setTarget", this::setTarget);
        this.registerButton("patrolling", this::switchTask);
        this.registerButton("following", this::switchTask);
        this.registerButton("guarding", this::switchTask);
        this.buttonTaskPatrol = (Button)this.findPaneOfTypeByID("patrolling", Button.class);
        this.buttonTaskFollow = (Button)this.findPaneOfTypeByID("following", Button.class);
        this.buttonTaskGuard = (Button)this.findPaneOfTypeByID("guarding", Button.class);
        this.buttonSetTarget = (Button)this.findPaneOfTypeByID("setTarget", Button.class);
    }

    public void onOpened() {
        super.onOpened();
        this.pullInfoFromHut();
        this.listOfPoints = (ScrollingList)this.findPaneOfTypeByID("positions", ScrollingList.class);
        if (this.task.equals((Object)GuardTask.PATROL)) {
            this.listOfPoints.setDataProvider(new ScrollingList.DataProvider(){

                public int getElementCount() {
                    return WindowGuardControl.this.patrolTargets.size();
                }

                public void updateElement(int index, @NotNull Pane rowPane) {
                    BlockPos pos = (BlockPos)WindowGuardControl.this.patrolTargets.get(index);
                    ((Label)rowPane.findPaneOfTypeByID("position", Label.class)).setLabelText(pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p());
                }
            });
        } else if (this.task.equals((Object)GuardTask.GUARD)) {
            this.listOfPoints.setDataProvider(new ScrollingList.DataProvider(){

                public int getElementCount() {
                    return 1;
                }

                public void updateElement(int index, @NotNull Pane rowPane) {
                    BlockPos pos = WindowGuardControl.this.building.getGuardPos();
                    ((Label)rowPane.findPaneOfTypeByID("position", Label.class)).setLabelText(pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p());
                }
            });
        }
        this.workersListPane = (ScrollingList)this.findPaneOfTypeByID("workers", ScrollingList.class);
        this.workersListPane.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowGuardControl.this.building.getGuards().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ICitizenDataView citizenDataView = WindowGuardControl.this.building.getColony().getCitizen(WindowGuardControl.this.building.getGuards().get(index));
                if (citizenDataView != null) {
                    BlockPos pos = citizenDataView.getPosition();
                    ((Label)rowPane.findPaneOfTypeByID("name", Label.class)).setLabelText(citizenDataView.getName());
                    ((Label)rowPane.findPaneOfTypeByID("position", Label.class)).setLabelText(pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p());
                    ((Label)rowPane.findPaneOfTypeByID("level", Label.class)).setLabelText("Level: " + citizenDataView.getCitizenSkillHandler().getJobModifier(WindowGuardControl.this.building));
                    WindowCitizen.createHealthBar(citizenDataView, (View)rowPane.findPaneOfTypeByID("healthBar", View.class));
                }
            }
        });
        this.handleButtons();
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        this.handleButtons();
    }

    public void onUpdate() {
        super.onUpdate();
        this.pullInfoFromHut();
        if (!this.task.equals((Object)GuardTask.PATROL)) {
            this.listOfPoints.hide();
        }
        ((ScrollingList)this.window.findPaneOfTypeByID("positions", ScrollingList.class)).refreshElementPanes();
        this.workersListPane.refreshElementPanes();
    }

    private void pullInfoFromHut() {
        this.patrolManually = this.building.isPatrolManually();
        this.retrieveOnLowHealth = this.building.isRetrieveOnLowHealth();
        this.hireTrainees = this.building.isHireTrainees();
        this.tightGrouping = this.building.isTightGrouping();
        this.task = this.building.getTask();
        this.patrolTargets = this.building.getPatrolTargets();
    }

    private void sendChangesToServer() {
        ResourceLocation resourceName = this.building.getGuardType() == null ? new ResourceLocation("") : this.building.getGuardType().getRegistryName();
        Network.getNetwork().sendToServer(new GuardTaskMessage(this.building, resourceName, this.building.isAssignManually(), this.patrolManually, this.retrieveOnLowHealth, this.task.ordinal(), this.tightGrouping, this.hireTrainees));
    }

    private void handleButtons() {
        ((Button)this.findPaneOfTypeByID("patrol", Button.class)).setLabel(this.patrolManually ? WindowConstants.GUI_SWITCH_MANUAL : WindowConstants.GUI_SWITCH_AUTO);
        ((Button)this.findPaneOfTypeByID("retrieve", Button.class)).setLabel(this.retrieveOnLowHealth ? WindowConstants.GUI_SWITCH_ON : WindowConstants.GUI_SWITCH_OFF);
        if (this.task.equals((Object)GuardTask.PATROL)) {
            this.buttonSetTarget.setEnabled(this.patrolManually);
            if (this.patrolManually) {
                this.buttonSetTarget.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.targetPatrol", (Object[])new Object[0]));
            } else {
                this.buttonSetTarget.setLabel("");
            }
            this.buttonTaskPatrol.setEnabled(false);
        } else if (this.task.equals((Object)GuardTask.FOLLOW)) {
            this.buttonTaskFollow.setEnabled(false);
            if (this.tightGrouping) {
                this.buttonSetTarget.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.followTight", (Object[])new Object[0]));
            } else {
                this.buttonSetTarget.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.followLoose", (Object[])new Object[0]));
            }
        } else if (this.task.equals((Object)GuardTask.GUARD)) {
            this.buttonSetTarget.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.targetGuard", (Object[])new Object[0]));
            this.buttonTaskGuard.setEnabled(false);
        }
    }

    private void switchTask(Button button) {
        if (button.getID().contains("patrolling")) {
            this.building.setTask(GuardTask.PATROL);
            this.buttonTaskPatrol.setEnabled(false);
            this.buttonTaskFollow.setEnabled(true);
            this.buttonTaskGuard.setEnabled(true);
            this.buttonSetTarget.show();
        } else if (button.getID().contains("following")) {
            this.building.setTask(GuardTask.FOLLOW);
            this.buttonTaskPatrol.setEnabled(true);
            this.buttonTaskFollow.setEnabled(false);
            this.buttonTaskGuard.setEnabled(true);
            this.buttonSetTarget.setEnabled(true);
            this.buttonSetTarget.show();
        } else {
            this.building.setTask(GuardTask.GUARD);
            this.buttonTaskPatrol.setEnabled(true);
            this.buttonTaskFollow.setEnabled(true);
            this.buttonTaskGuard.setEnabled(false);
            this.buttonSetTarget.show();
        }
        this.pullInfoFromHut();
        this.sendChangesToServer();
    }

    private void setTarget() {
        ClientPlayerEntity player = this.mc.field_71439_g;
        int emptySlot = player.field_71071_by.func_70447_i();
        this.pullInfoFromHut();
        if (emptySlot == -1) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.gui.workerhuts.noSpace", (Object[])new Object[0]);
        }
        if (this.patrolManually && this.task.equals((Object)GuardTask.PATROL)) {
            this.givePlayerScepter(GuardTask.PATROL);
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.job.guard.tool.taskPatrol", (Object[])new Object[0]);
        } else {
            if (this.task.equals((Object)GuardTask.FOLLOW)) {
                this.tightGrouping = !this.tightGrouping;
                this.building.setTightGrouping(this.tightGrouping);
                this.pullInfoFromHut();
                this.sendChangesToServer();
                return;
            }
            if (this.task.equals((Object)GuardTask.GUARD)) {
                this.givePlayerScepter(GuardTask.GUARD);
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.job.guard.tool.taskGuard", (Object[])new Object[0]);
            }
        }
        this.window.close();
    }

    private void recalculate() {
        Network.getNetwork().sendToServer(new GuardRecalculateMessage(this.building));
        this.pullInfoFromHut();
    }

    private void givePlayerScepter(GuardTask localTask) {
        Network.getNetwork().sendToServer(new GuardScepterMessage(this.building, localTask.ordinal()));
    }

    private void switchRetrievalMode() {
        this.building.setRetrieveOnLowHealth(!this.building.isRetrieveOnLowHealth());
        this.pullInfoFromHut();
        this.sendChangesToServer();
        ((Button)this.findPaneOfTypeByID("retrieve", Button.class)).setLabel(this.retrieveOnLowHealth ? WindowConstants.GUI_SWITCH_ON : WindowConstants.GUI_SWITCH_OFF);
    }

    private void switchTraineeMode() {
        this.building.setHireTrainees(!this.building.isHireTrainees());
        this.pullInfoFromHut();
        this.sendChangesToServer();
        ((Button)this.findPaneOfTypeByID("trainees", Button.class)).setLabel(this.hireTrainees ? WindowConstants.GUI_SWITCH_ON : WindowConstants.GUI_SWITCH_OFF);
    }

    private void switchPatrolMode() {
        this.building.setPatrolManually(!this.building.isPatrolManually());
        this.pullInfoFromHut();
        this.sendChangesToServer();
    }
}

