/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.controls.Button;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBeekeeper;
import com.minecolonies.coremod.network.messages.server.colony.building.beekeeper.BeekeeperScepterMessage;

public class WindowHutBeekeeper
extends AbstractWindowWorkerBuilding<BuildingBeekeeper.View> {
    private static final String BUTTON_HARVEST_HONEYCOMB = "harvestHoneycomb";
    private static final String BUTTON_GIVE_TOOL = "giveTool";
    private Button buttonHarvestHoneycombs;

    public WindowHutBeekeeper(BuildingBeekeeper.View building) {
        super(building, "minecolonies:gui/windowhutbeekeeper.xml");
        this.registerButton(BUTTON_HARVEST_HONEYCOMB, this::harvestHoneycombClicked);
        this.buttonHarvestHoneycombs = (Button)this.findPaneOfTypeByID(BUTTON_HARVEST_HONEYCOMB, Button.class);
        if (building.isHarvestHoneycombs()) {
            this.buttonHarvestHoneycombs.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.beekeeper.collect", (Object[])new Object[0]));
        } else {
            this.buttonHarvestHoneycombs.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.beekeeper.notcollect", (Object[])new Object[0]));
        }
        this.registerButton(BUTTON_GIVE_TOOL, this::givePlayerScepter);
    }

    private void givePlayerScepter() {
        Network.getNetwork().sendToServer(new BeekeeperScepterMessage(this.building));
    }

    private void harvestHoneycombClicked() {
        if (this.buttonHarvestHoneycombs.getLabel().equals(LanguageHandler.format((String)"com.minecolonies.coremod.gui.beekeeper.collect", (Object[])new Object[0]))) {
            this.buttonHarvestHoneycombs.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.beekeeper.notcollect", (Object[])new Object[0]));
            ((BuildingBeekeeper.View)this.building).setHarvestHoneycombs(false);
        } else {
            this.buttonHarvestHoneycombs.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.beekeeper.collect", (Object[])new Object[0]));
            ((BuildingBeekeeper.View)this.building).setHarvestHoneycombs(true);
        }
    }

    @Override
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerhuts.beekeeperHut";
    }
}

