/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.SwitchView;
import com.ldtteam.blockout.views.View;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.client.gui.WindowHutGuide;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.network.messages.server.colony.building.MarkBuildingDirtyMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.TransferItemsRequestMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowHutBuilder
extends AbstractWindowWorkerBuilding<BuildingBuilder.View> {
    public static final int RED = Color.getByName((String)"red", (int)0);
    public static final int DARKGREEN = Color.getByName((String)"darkgreen", (int)0);
    public static final int BLACK = Color.getByName((String)"black", (int)0);
    private static final ResourceLocation GUIDE_ADVANCEMENT = new ResourceLocation("minecolonies", "minecolonies/check_out_guide");
    @NotNull
    private final List<BuildingBuilderResource> resources = new ArrayList<BuildingBuilderResource>();
    private final boolean needGuide;
    private int tick = 0;

    public WindowHutBuilder(BuildingBuilder.View building) {
        this(building, true);
    }

    public WindowHutBuilder(BuildingBuilder.View building, boolean needGuide) {
        super(building, "minecolonies:gui/windowhutbuilder.xml");
        this.pullResourcesFromHut();
        this.registerButton("resourceAdd", this::transferItems);
        this.needGuide = needGuide;
    }

    private void pullResourcesFromHut() {
        PlayerInventory inventory = this.mc.field_71439_g.field_71071_by;
        boolean isCreative = this.mc.field_71439_g.func_184812_l_();
        this.resources.clear();
        this.resources.addAll(((BuildingBuilder.View)this.building).getResources().values());
        for (BuildingBuilderResource resource : this.resources) {
            int amountToSet = isCreative ? resource.getAmount() : InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)inventory), stack -> ItemStackUtils.isEmpty(stack) == false && stack.func_77969_a(resource.getItemStack()));
            resource.setPlayerAmount(amountToSet);
        }
        this.resources.sort(new BuildingBuilderResource.ResourceComparator());
    }

    @Override
    public void onOpened() {
        if (this.needGuide && Minecraft.func_71410_x().field_71439_g.field_71174_a.func_191982_f().func_194229_a().func_192084_a(GUIDE_ADVANCEMENT) == null) {
            this.close();
            new WindowHutGuide((BuildingBuilder.View)this.building).open();
            return;
        }
        super.onOpened();
        this.pullResourcesFromHut();
        ScrollingList resourceList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHutBuilder.this.resources.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                WindowHutBuilder.this.updateResourcePane(index, rowPane);
            }
        });
        Network.getNetwork().sendToServer(new MarkBuildingDirtyMessage(this.building));
        ((Label)this.findPaneOfTypeByID("constructionName", Label.class)).setLabelText(((BuildingBuilder.View)this.building).getConstructionName());
        ((Label)this.findPaneOfTypeByID("constructionPos", Label.class)).setLabelText(((BuildingBuilder.View)this.building).getConstructionPos());
        ((Label)this.findPaneOfTypeByID("progress", Label.class)).setLabelText(((BuildingBuilder.View)this.building).getProgress());
    }

    private void updateResourcePane(int index, @NotNull Pane rowPane) {
        BuildingBuilderResource resource = this.resources.get(index);
        Label resourceLabel = (Label)rowPane.findPaneOfTypeByID("resourceName", Label.class);
        Label resourceMissingLabel = (Label)rowPane.findPaneOfTypeByID("resourceMissing", Label.class);
        Label neededLabel = (Label)rowPane.findPaneOfTypeByID("resourceAvailableNeeded", Label.class);
        Button addButton = (Button)rowPane.findPaneOfTypeByID("resourceAdd", Button.class);
        switch (resource.getAvailabilityStatus()) {
            case DONT_HAVE: {
                addButton.disable();
                resourceLabel.setColor(RED, RED);
                resourceMissingLabel.setColor(RED, RED);
                neededLabel.setColor(RED, RED);
                break;
            }
            case NEED_MORE: {
                addButton.enable();
                resourceLabel.setColor(RED, RED);
                resourceMissingLabel.setColor(RED, RED);
                neededLabel.setColor(RED, RED);
                break;
            }
            case HAVE_ENOUGH: {
                addButton.enable();
                resourceLabel.setColor(DARKGREEN, DARKGREEN);
                resourceMissingLabel.setColor(DARKGREEN, DARKGREEN);
                neededLabel.setColor(DARKGREEN, DARKGREEN);
                break;
            }
            default: {
                addButton.disable();
                resourceLabel.setColor(BLACK, BLACK);
                resourceMissingLabel.setColor(BLACK, BLACK);
                neededLabel.setColor(BLACK, BLACK);
            }
        }
        int buttonX = rowPane.getWidth() - addButton.getWidth() - (rowPane.getHeight() - addButton.getHeight()) / 2;
        int buttonY = rowPane.getHeight() - addButton.getHeight() - 2;
        addButton.setPosition(buttonX, buttonY);
        resourceLabel.setLabelText(resource.getName());
        int missing = resource.getMissingFromPlayer();
        if (missing < 0) {
            resourceMissingLabel.setLabelText(Integer.toString(missing));
        } else {
            resourceMissingLabel.setLabelText("");
        }
        neededLabel.setLabelText(resource.getAvailable() + " / " + resource.getAmount());
        ((Label)rowPane.findPaneOfTypeByID("resourceId", Label.class)).setLabelText(Integer.toString(index));
        ((Label)rowPane.findPaneOfTypeByID("resourceQuantity", Label.class)).setLabelText(Integer.toString(resource.getAmount() - resource.getAvailable()));
        ItemStack stack = new ItemStack((IItemProvider)resource.getItem(), 1);
        stack.func_77982_d(resource.getItemStack().func_77978_p());
        ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(stack);
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerhuts.buildersHut";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        String currentPage = ((SwitchView)this.findPaneOfTypeByID("pages", SwitchView.class)).getCurrentView().getID();
        if (currentPage.equals("resourceActions")) {
            if (this.tick++ == 20) {
                this.pullResourcesFromHut();
                this.tick = 0;
            }
            ((ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class)).refreshElementPanes();
        }
    }

    private void transferItems(@NotNull Button button) {
        View pane = button.getParent();
        button.disable();
        Label idLabel = (Label)pane.findPaneOfTypeByID("resourceId", Label.class);
        int index = Integer.parseInt(idLabel.getLabelText());
        BuildingBuilderResource res = this.resources.get(index);
        if (res == null) {
            Log.getLogger().warn("WindowHutBuilder.transferItems: Error - Could not find the resource.");
        } else {
            ItemStack itemStack = res.getItemStack().func_77946_l();
            itemStack.func_190920_e(1);
            Label quantityLabel = (Label)pane.findPaneOfTypeByID("resourceQuantity", Label.class);
            int quantity = Integer.parseInt(quantityLabel.getLabelText());
            int needed = res.getAmount() - res.getAvailable();
            res.setAvailable(Math.min(res.getAmount(), res.getAvailable() + res.getPlayerAmount()));
            res.setPlayerAmount(Math.max(0, res.getPlayerAmount() - needed));
            this.resources.sort(new BuildingBuilderResource.ResourceComparator());
            Network.getNetwork().sendToServer(new TransferItemsRequestMessage((AbstractBuildingView)this.building, itemStack, quantity, true));
        }
    }
}

