/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Image;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.IDeliverymanRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingDeliveryman;
import com.minecolonies.coremod.colony.jobs.views.DmanJobView;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class WindowHutDeliveryman
extends AbstractWindowWorkerBuilding<BuildingDeliveryman.View> {
    private static final String HUT_DMAN_RESOURCE_SUFFIX = ":gui/windowhutdeliveryman.xml";
    private static final String LIST_DELIVERIES = "deliveries";

    public WindowHutDeliveryman(BuildingDeliveryman.View building) {
        super(building, "minecolonies:gui/windowhutdeliveryman.xml");
    }

    @Override
    public void onOpened() {
        super.onOpened();
        final ArrayList tasks = new ArrayList();
        for (int citizenId : ((BuildingDeliveryman.View)this.building).getWorkerId()) {
            ICitizenDataView citizen = ((BuildingDeliveryman.View)this.building).getColony().getCitizen(citizenId);
            if (!(citizen.getJobView() instanceof DmanJobView)) continue;
            tasks.addAll(((DmanJobView)citizen.getJobView()).getDataStore().getQueue());
        }
        ScrollingList deliveryList = (ScrollingList)this.findPaneOfTypeByID(LIST_DELIVERIES, ScrollingList.class);
        deliveryList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                tasks.removeIf(token -> ((BuildingDeliveryman.View)WindowHutDeliveryman.this.building).getColony().getRequestManager().getRequestForToken((IToken<?>)token) == null);
                return tasks.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                IRequest<?> request = ((BuildingDeliveryman.View)WindowHutDeliveryman.this.building).getColony().getRequestManager().getRequestForToken((IToken)tasks.get(index));
                IRequest<?> parent = ((BuildingDeliveryman.View)WindowHutDeliveryman.this.building).getColony().getRequestManager().getRequestForToken((IToken<?>)request.getParent());
                if (parent != null) {
                    ((Label)rowPane.findPaneOfTypeByID("requester", Label.class)).setLabelText(request.getRequester().getRequesterDisplayName(((BuildingDeliveryman.View)WindowHutDeliveryman.this.building).getColony().getRequestManager(), request).func_150254_d() + " ->");
                    ((Label)rowPane.findPaneOfTypeByID("parent", Label.class)).setLabelText(parent.getRequester().getRequesterDisplayName(((BuildingDeliveryman.View)WindowHutDeliveryman.this.building).getColony().getRequestManager(), parent).func_150254_d());
                } else {
                    ((Label)rowPane.findPaneOfTypeByID("requester", Label.class)).setLabelText(request.getRequester().getRequesterDisplayName(((BuildingDeliveryman.View)WindowHutDeliveryman.this.building).getColony().getRequestManager(), request).func_150254_d());
                    ((Label)rowPane.findPaneOfTypeByID("parent", Label.class)).setLabelText("");
                }
                ((Label)rowPane.findPaneOfTypeByID("shortDetail", Label.class)).setLabelText(request.getShortDisplayString().func_150254_d().replace("\u00a7f", ""));
                if (request.getRequest() instanceof IDeliverymanRequestable) {
                    ((Label)rowPane.findPaneOfTypeByID("priority", Label.class)).setLabelText(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.deliveryman.priority", (Object[])new Object[0]) + ((IDeliverymanRequestable)request.getRequest()).getPriority());
                }
                Image logo = (Image)rowPane.findPaneOfTypeByID("deliveryImage", Image.class);
                logo.setImage(request.getDisplayIcon());
            }
        });
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerhuts.deliveryman";
    }
}

