/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.SwitchView;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class WindowHutFarmer
extends AbstractWindowWorkerBuilding<BuildingFarmer.View> {
    private static final String VIEW_PAGES = "pages";
    private static final String HUT_FARMER_RESOURCE_SUFFIX = ":gui/windowhutfarmer.xml";
    private static final String PAGE_FIELDS = "pageFields";
    private static final String LIST_FIELDS = "fields";
    private static final String TAG_WORKER = "worker";
    private static final String TAG_DISTANCE = "dist";
    private static final String TAG_DIRECTION = "dir";
    private static final String TAG_BUTTON_ASSIGN = "assignFarm";
    private static final String TAG_BUTTON_ASSIGNMENT_MODE = "assignmentMode";
    private static final String TAG_BUTTON_REQUEST_FERTILIZER = "requestFert";
    private static final String RED_X = "\u00a7n\u00a74X";
    private static final String APPROVE = "\u2713";
    private static final String TAG_ICON = "icon";
    private List<BlockPos> fields = new ArrayList<BlockPos>();
    private ScrollingList fieldList;
    private final ClientWorld world;

    public WindowHutFarmer(BuildingFarmer.View building) {
        super(building, "minecolonies:gui/windowhutfarmer.xml");
        this.world = Minecraft.func_71410_x().field_71441_e;
        this.registerButton(TAG_BUTTON_ASSIGNMENT_MODE, this::assignmentModeClicked);
        this.registerButton(TAG_BUTTON_ASSIGN, this::assignClicked);
        this.registerButton(TAG_BUTTON_REQUEST_FERTILIZER, this::requestFertilizerClicked);
    }

    private void assignClicked(@NotNull Button button) {
        int row = this.fieldList.getListElementIndexByPane((Pane)button);
        BlockPos field = this.fields.get(row);
        TileEntity entity = this.world.func_175625_s(field);
        if (entity instanceof ScarecrowTileEntity) {
            if (button.getLabel().equals(RED_X)) {
                button.setLabel(APPROVE);
                ((BuildingFarmer.View)this.building).changeFields(field, false, (ScarecrowTileEntity)entity);
            } else {
                button.setLabel(RED_X);
                ((BuildingFarmer.View)this.building).changeFields(field, true, (ScarecrowTileEntity)entity);
            }
            this.pullLevelsFromHut();
            ((ScrollingList)this.window.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class)).refreshElementPanes();
        }
    }

    private void pullLevelsFromHut() {
        this.fields = ((BuildingFarmer.View)this.building).getFields();
    }

    private void assignmentModeClicked(@NotNull Button button) {
        if (button.getLabel().equals(LanguageHandler.format((String)"com.minecolonies.coremod.gui.hiring.off", (Object[])new Object[0]))) {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.hiring.on", (Object[])new Object[0]));
            ((BuildingFarmer.View)this.building).setAssignFieldManually(true);
        } else {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.hiring.off", (Object[])new Object[0]));
            ((BuildingFarmer.View)this.building).setAssignFieldManually(false);
        }
        ((ScrollingList)this.window.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class)).refreshElementPanes();
    }

    private void requestFertilizerClicked(@NotNull Button button) {
        if (button.getLabel().equals(LanguageHandler.format((String)"com.minecolonies.coremod.gui.requestfert.off", (Object[])new Object[0]))) {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.requestfert.on", (Object[])new Object[0]));
            ((BuildingFarmer.View)this.building).setRequestFertilizer(true);
        } else {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.requestfert.off", (Object[])new Object[0]));
            ((BuildingFarmer.View)this.building).setRequestFertilizer(false);
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        if (((BuildingFarmer.View)this.building).assignFieldManually()) {
            ((Button)this.findPaneOfTypeByID(TAG_BUTTON_ASSIGNMENT_MODE, Button.class)).setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.hiring.on", (Object[])new Object[0]));
        } else {
            ((Button)this.findPaneOfTypeByID(TAG_BUTTON_ASSIGNMENT_MODE, Button.class)).setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.hiring.off", (Object[])new Object[0]));
        }
        if (((BuildingFarmer.View)this.building).requestFertilizer()) {
            ((Button)this.findPaneOfTypeByID(TAG_BUTTON_REQUEST_FERTILIZER, Button.class)).setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.requestfert.on", (Object[])new Object[0]));
        } else {
            ((Button)this.findPaneOfTypeByID(TAG_BUTTON_REQUEST_FERTILIZER, Button.class)).setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.requestfert.off", (Object[])new Object[0]));
        }
        this.fieldList = (ScrollingList)this.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class);
        this.fieldList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHutFarmer.this.fields.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                BlockPos field = (BlockPos)WindowHutFarmer.this.fields.get(index);
                String distance = Integer.toString((int)Math.sqrt(BlockPosUtil.getDistanceSquared(field, ((BuildingFarmer.View)WindowHutFarmer.this.building).getPosition())));
                String direction = BlockPosUtil.calcDirection(((BuildingFarmer.View)WindowHutFarmer.this.building).getPosition(), field);
                TileEntity entity = WindowHutFarmer.this.world.func_175625_s(field);
                if (entity instanceof ScarecrowTileEntity) {
                    String owner = ((ScarecrowTileEntity)entity).getOwner().isEmpty() ? "<" + LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.farmerhut.unused", (Object[])new Object[0]) + ">" : ((ScarecrowTileEntity)entity).getOwner();
                    ((Label)rowPane.findPaneOfTypeByID(WindowHutFarmer.TAG_WORKER, Label.class)).setLabelText(owner);
                    ((Label)rowPane.findPaneOfTypeByID(WindowHutFarmer.TAG_DISTANCE, Label.class)).setLabelText(distance + "m");
                    ((Label)rowPane.findPaneOfTypeByID(WindowHutFarmer.TAG_DIRECTION, Label.class)).setLabelText(direction);
                    Button assignButton = (Button)rowPane.findPaneOfTypeByID(WindowHutFarmer.TAG_BUTTON_ASSIGN, Button.class);
                    assignButton.setEnabled(((BuildingFarmer.View)WindowHutFarmer.this.building).assignFieldManually());
                    if (((ScarecrowTileEntity)entity).isTaken()) {
                        assignButton.setLabel(WindowHutFarmer.RED_X);
                    } else {
                        assignButton.setLabel(WindowHutFarmer.APPROVE);
                        if (((BuildingFarmer.View)WindowHutFarmer.this.building).getBuildingLevel() <= ((BuildingFarmer.View)WindowHutFarmer.this.building).getAmountOfFields()) {
                            assignButton.disable();
                        }
                    }
                    if (((ScarecrowTileEntity)entity).getSeed() != null) {
                        ((ItemIcon)rowPane.findPaneOfTypeByID(WindowHutFarmer.TAG_ICON, ItemIcon.class)).setItem(((ScarecrowTileEntity)entity).getSeed());
                    }
                }
            }
        });
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "block.minecolonies.blockhutfarmer.name";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        String currentPage = ((SwitchView)this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class)).getCurrentView().getID();
        if (currentPage.equals(PAGE_FIELDS)) {
            this.pullLevelsFromHut();
            ((ScrollingList)this.window.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class)).refreshElementPanes();
        }
    }
}

