/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.views.View;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractHutFilterableLists;
import com.minecolonies.coremod.client.gui.ViewFilterableList;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.network.messages.server.colony.building.lumberjack.LumberjackReplantSaplingToggleMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.lumberjack.LumberjackRestrictionToggleMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.lumberjack.LumberjackScepterMessage;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class WindowHutLumberjack
extends AbstractHutFilterableLists {
    private static final String BUTTON_TOGGLE_REPLANT = "saplingReplant";
    private static final String BUTTON_GIVE_TOOL = "giveTool";
    private static final String BUTTON_TOGGLE_RESTRICTION = "toggleRestriction";
    private static final String PAGE_ITEMS_VIEW = "saplings";
    private static final String RESOURCE_STRING = ":gui/windowhutlumberjack.xml";
    private final BuildingLumberjack.View ownBuilding;

    public WindowHutLumberjack(BuildingLumberjack.View building) {
        super(building, "minecolonies:gui/windowhutlumberjack.xml", new Tuple[0]);
        ViewFilterableList window = new ViewFilterableList((View)this.findPaneOfTypeByID(PAGE_ITEMS_VIEW, View.class), this, building, LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.saplingList", (Object[])new Object[0]), PAGE_ITEMS_VIEW, true);
        this.views.put(PAGE_ITEMS_VIEW, window);
        this.ownBuilding = building;
        this.registerButton(BUTTON_TOGGLE_REPLANT, this::switchReplant);
        this.registerButton(BUTTON_TOGGLE_RESTRICTION, this::toggleRestriction);
        this.registerButton(BUTTON_GIVE_TOOL, this::giveTool);
        this.setupReplantButton((Button)this.findPaneOfTypeByID(BUTTON_TOGGLE_REPLANT, Button.class));
        this.setupRestrictionButton((Button)this.findPaneOfTypeByID(BUTTON_TOGGLE_RESTRICTION, Button.class));
        this.setupGiveToolButton((Button)this.findPaneOfTypeByID(BUTTON_GIVE_TOOL, Button.class));
    }

    private void giveTool() {
        this.givePlayerScepter();
    }

    private void givePlayerScepter() {
        Network.getNetwork().sendToServer(new LumberjackScepterMessage(this.building));
    }

    @Override
    public List<? extends ItemStorage> getBlockList(Predicate<ItemStack> filterPredicate, String id) {
        return IColonyManager.getInstance().getCompatibilityManager().getCopyOfSaplings().stream().filter(storage -> filterPredicate.test(storage.getItemStack())).collect(Collectors.toList());
    }

    private void setupReplantButton(Button button) {
        if (this.ownBuilding.shouldReplant) {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.togglereplantsaplingson", (Object[])new Object[0]));
        } else {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.togglereplantsaplingsoff", (Object[])new Object[0]));
        }
    }

    private void setupGiveToolButton(Button button) {
        button.setLabel(LanguageHandler.format((String)"Give tool", (Object[])new Object[0]));
    }

    private void setupRestrictionButton(Button button) {
        button.setLabel(LanguageHandler.format((String)(this.ownBuilding.shouldRestrict ? "com.minecolonies.coremod.gui.workerHuts.togglerestrictionon" : "com.minecolonies.coremod.gui.workerHuts.togglerestrictionoff"), (Object[])new Object[0]));
    }

    private void switchReplant(Button replant) {
        this.ownBuilding.shouldReplant = !this.ownBuilding.shouldReplant;
        this.setupReplantButton(replant);
        Network.getNetwork().sendToServer(new LumberjackReplantSaplingToggleMessage(this.ownBuilding, this.ownBuilding.shouldReplant));
    }

    private void toggleRestriction(Button restriction) {
        this.ownBuilding.shouldRestrict = !this.ownBuilding.shouldRestrict;
        this.setupRestrictionButton(restriction);
        Network.getNetwork().sendToServer(new LumberjackRestrictionToggleMessage(this.ownBuilding, this.ownBuilding.shouldRestrict));
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.job.lumberjack";
    }
}

