/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSifter;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowHutSifter
extends AbstractWindowWorkerBuilding<BuildingSifter.View> {
    private static final String BLOCK_BUTTON = "block";
    private static final String MESH_BUTTON = "buyMesh";
    private static final String BUTTON_SAVE = "save";
    private static final String QTY_INPUT = "qty";
    private static final String SIFTER_RESOURCE_SUFFIX = ":gui/windowhutsifter.xml";
    private final ScrollingList meshList;
    private ItemStorage block;
    private ItemStorage mesh;

    public WindowHutSifter(BuildingSifter.View building) {
        super(building, "minecolonies:gui/windowhutsifter.xml");
        Button crushingSettingsButton = (Button)this.findPaneOfTypeByID(BLOCK_BUTTON, Button.class);
        TextField sifterSettingsInput = (TextField)this.findPaneOfTypeByID(QTY_INPUT, TextField.class);
        this.meshList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.registerButton(MESH_BUTTON, this::switchMesh);
        this.registerButton(BLOCK_BUTTON, this::switchSievableBlock);
        this.registerButton(BUTTON_SAVE, this::save);
        this.block = building.getSifterBlock();
        this.mesh = building.getMesh();
        sifterSettingsInput.setText(String.valueOf(building.getDailyQuantity()));
        this.setupSettings(crushingSettingsButton);
        this.updateResourceList();
    }

    private void updateResourceList() {
        this.meshList.enable();
        this.meshList.show();
        final int size = ((BuildingSifter.View)this.building).getBuildingLevel() - ((BuildingSifter.View)this.building).getMeshes().size() + 3;
        this.meshList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return Math.max(Math.min(size, ((BuildingSifter.View)WindowHutSifter.this.building).getMeshes().size()), 1);
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = ((BuildingSifter.View)WindowHutSifter.this.building).getMeshes().get(index).getItemStack();
                Label resourceLabel = (Label)rowPane.findPaneOfTypeByID("resourceName", Label.class);
                boolean isSet = false;
                if (resource.func_77969_a(WindowHutSifter.this.mesh.getItemStack())) {
                    int green = Color.getByName((String)"green", (int)0);
                    resourceLabel.setColor(green, green);
                    resourceLabel.setLabelText(resource.func_200301_q().func_150254_d());
                    isSet = true;
                } else {
                    int black = Color.getByName((String)"black", (int)0);
                    resourceLabel.setColor(black, black);
                    resourceLabel.setLabelText(resource.func_200301_q().func_150254_d());
                }
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
                Button switchButton = (Button)rowPane.findPaneOfTypeByID(WindowHutSifter.MESH_BUTTON, Button.class);
                boolean isCreative = Minecraft.func_71410_x().field_71439_g.func_184812_l_();
                if (isSet || !isCreative && !InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by), stack -> stack.func_77969_a(resource))) {
                    switchButton.hide();
                } else {
                    switchButton.show();
                }
            }
        });
    }

    private void switchMesh(Button button) {
        int row = this.meshList.getListElementIndexByPane((Pane)button);
        this.mesh = ((BuildingSifter.View)this.building).getMeshes().get(row);
        TextField crushingSettingsInput = (TextField)this.findPaneOfTypeByID(QTY_INPUT, TextField.class);
        try {
            int qty = Integer.parseInt(crushingSettingsInput.getText());
            ((BuildingSifter.View)this.building).save(this.block, this.mesh, qty, true);
        }
        catch (NumberFormatException ex) {
            Log.getLogger().warn("Wrong input!");
        }
    }

    private void save() {
        TextField crushingSettingsInput = (TextField)this.findPaneOfTypeByID(QTY_INPUT, TextField.class);
        try {
            int qty = Integer.parseInt(crushingSettingsInput.getText());
            ((BuildingSifter.View)this.building).save(this.block, this.mesh, qty, false);
        }
        catch (NumberFormatException ex) {
            Log.getLogger().warn("Wrong input!");
        }
    }

    private void switchSievableBlock(Button crushingSettingsButton) {
        List<ItemStorage> modes = ((BuildingSifter.View)this.building).getSievableBlocks();
        int index = modes.indexOf(this.block) + 1;
        if (index >= modes.size()) {
            index = 0;
        }
        this.block = modes.get(index);
        this.setupSettings(crushingSettingsButton);
    }

    private void setupSettings(Button crushingSettingsButton) {
        crushingSettingsButton.setLabel(this.block.getItemStack().func_200301_q().func_150254_d());
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerhuts.Sifter";
    }
}

