/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.views.View;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.client.gui.WindowResearchTree;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingUniversity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class WindowHutUniversity
extends AbstractWindowWorkerBuilding<BuildingUniversity.View> {
    private final List<String> branches = new ArrayList<String>();

    public WindowHutUniversity(BuildingUniversity.View building) {
        super(building, "minecolonies:gui/windowhutuniversity.xml");
        View view = (View)this.findPaneOfTypeByID("pageBranches", View.class);
        int offset = 0;
        for (String branch : IGlobalResearchTree.getInstance().getBranches()) {
            ButtonImage button = new ButtonImage();
            button.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large.png"));
            button.setLabel(branch);
            button.setSize(129, 17);
            button.setTextColor(100);
            button.setPosition(this.x + 30, this.y + offset + 60);
            view.addChild((Pane)button);
            this.branches.add(branch);
            offset += button.getHeight() + 10;
        }
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        String label = button.getLabel();
        if (this.branches.contains(label)) {
            new WindowResearchTree(label, (BuildingUniversity.View)this.building, this).open();
        }
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerhuts.university";
    }
}

