/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Alignment;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.Box;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowCitizen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;

public class WindowInteraction
extends AbstractWindowSkeleton {
    public static final String BUTTON_RESPONSE_ID = "response_";
    private final ICitizenDataView citizen;
    private final List<IInteractionResponseHandler> interactions;
    private int currentInteraction = 0;

    public WindowInteraction(ICitizenDataView citizen) {
        super("minecolonies:gui/citizen/windowinteraction.xml", new WindowCitizen(citizen));
        this.citizen = citizen;
        this.interactions = citizen.getOrderedInteractions();
    }

    public void onOpened() {
        super.onOpened();
        this.setupInteraction();
    }

    private void setupInteraction() {
        if (this.currentInteraction >= this.interactions.size()) {
            this.close();
            return;
        }
        IInteractionResponseHandler handler = this.interactions.get(this.currentInteraction);
        Box group = (Box)this.findPaneOfTypeByID("responseOptions", Box.class);
        int y = 0;
        int x = 0;
        ((Text)this.findPaneOfTypeByID("chat", Text.class)).setTextAlignment(Alignment.TOP_LEFT);
        ((Text)this.findPaneOfTypeByID("chat", Text.class)).setAlignment(Alignment.TOP_LEFT);
        ((Text)this.findPaneOfTypeByID("chat", Text.class)).setTextContent(this.citizen.getName() + ": " + handler.getInquiry().func_150254_d());
        int responseIndex = 1;
        for (ITextComponent component : handler.getPossibleResponses()) {
            ButtonImage button = new ButtonImage();
            button.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large.png"));
            button.setLabel(component.func_150254_d());
            button.setSize(129, 17);
            button.setTextColor(100);
            button.setPosition(x, y);
            button.setID(BUTTON_RESPONSE_ID + responseIndex);
            group.addChild((Pane)button);
            if ((y += button.getHeight()) + button.getHeight() >= group.getHeight()) {
                y = 0;
                x += 20 + button.getWidth();
            }
            ++responseIndex;
        }
        handler.onWindowOpened(this, this.citizen);
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (!this.interactions.isEmpty()) {
            IInteractionResponseHandler handler = this.interactions.get(this.currentInteraction);
            for (ITextComponent component : handler.getPossibleResponses()) {
                if (!component.func_150254_d().equals(button.getLabel()) || !handler.onClientResponseTriggered(component, (PlayerEntity)Minecraft.func_71410_x().field_71439_g, this.citizen, this)) continue;
                ++this.currentInteraction;
                this.setupInteraction();
                return;
            }
        }
    }
}

