/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonHandler;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.views.Box;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.ChangeRecipePriorityMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class WindowListRecipes
extends Window
implements ButtonHandler {
    private static final String RECIPE_LIST = "recipes";
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowlistrecipes.xml";
    private static final String OUTPUT_ICON = "output";
    private static final String RESOURCE = "resource%d";
    private static final String RES = "res%d";
    private final List<IRecipeStorage> recipes = new ArrayList<IRecipeStorage>();
    private final AbstractBuildingWorker.View building;
    private final ScrollingList recipeList;

    public WindowListRecipes(IColonyView c, BlockPos buildingId) {
        super("minecolonies:gui/windowlistrecipes.xml");
        this.building = (AbstractBuildingWorker.View)c.getBuilding(buildingId);
        this.recipeList = (ScrollingList)this.findPaneOfTypeByID(RECIPE_LIST, ScrollingList.class);
        this.updateRecipes();
    }

    private void updateRecipes() {
        this.recipes.clear();
        this.recipes.addAll(this.building.getRecipes());
    }

    public void onOpened() {
        this.updateRecipes();
        this.recipeList.enable();
        this.recipeList.show();
        this.recipeList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowListRecipes.this.recipes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                String name;
                Button removeButton;
                IRecipeStorage recipe = (IRecipeStorage)WindowListRecipes.this.recipes.get(index);
                ItemIcon icon = (ItemIcon)rowPane.findPaneOfTypeByID(WindowListRecipes.OUTPUT_ICON, ItemIcon.class);
                icon.setItem(recipe.getPrimaryOutput());
                if (!WindowListRecipes.this.building.isRecipeAlterationAllowed() && (removeButton = (Button)rowPane.findPaneOfTypeByID("remove", Button.class)) != null) {
                    removeButton.setVisible(false);
                }
                if (recipe.getInput().size() <= 4) {
                    name = WindowListRecipes.RESOURCE;
                } else {
                    name = WindowListRecipes.RES;
                    ((Box)rowPane.findPaneOfTypeByID("3x3", Box.class)).setVisible(true);
                    ((Box)rowPane.findPaneOfTypeByID("2x2", Box.class)).setVisible(false);
                    icon.setPosition(80, 17);
                }
                for (int i = 0; i < recipe.getInput().size(); ++i) {
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(name, i + 1), ItemIcon.class)).setItem(recipe.getInput().get(i));
                }
            }
        });
    }

    public void onUpdate() {
        this.updateRecipes();
        ((ScrollingList)this.window.findPaneOfTypeByID(RECIPE_LIST, ScrollingList.class)).refreshElementPanes();
    }

    public void onButtonClicked(@NotNull Button button) {
        int row = this.recipeList.getListElementIndexByPane((Pane)button);
        if (button.getID().equals("remove") && this.building.isRecipeAlterationAllowed()) {
            IRecipeStorage data = this.recipes.get(row);
            this.building.removeRecipe(row);
            Network.getNetwork().sendToServer(new AddRemoveRecipeMessage(this.building, true, data));
        } else if (button.getID().equals("up")) {
            this.building.switchIndex(row, row - 1);
            Network.getNetwork().sendToServer(new ChangeRecipePriorityMessage(this.building, row, true));
        } else if (button.getID().equals("down")) {
            this.building.switchIndex(row + 1, row);
            Network.getNetwork().sendToServer(new ChangeRecipePriorityMessage(this.building, row, false));
        } else if (button.getID().equals("cancel")) {
            this.building.openGui(false);
        }
    }
}

