/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowHutBuilder;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.network.messages.server.colony.building.MarkBuildingDirtyMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowResourceList
extends AbstractWindowSkeleton {
    @Nullable
    private final BuildingBuilder.View builder;
    @NotNull
    private final List<BuildingBuilderResource> resources = new ArrayList<BuildingBuilderResource>();

    public WindowResourceList(int colonyId, BlockPos buildingPos) {
        super("minecolonies:gui/windowresourcescroll.xml");
        IBuildingView buildingView;
        IColonyView colonyView = IColonyManager.getInstance().getColonyView(colonyId, Minecraft.func_71410_x().field_71441_e.func_201675_m().func_186058_p().func_186068_a());
        if (colonyView != null && (buildingView = colonyView.getBuilding(buildingPos)) instanceof BuildingBuilder.View) {
            this.builder = (BuildingBuilder.View)buildingView;
            return;
        }
        LanguageHandler.sendPlayerMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (String)"com.minecolonies.coremod.gui.resourcescroll.nobuilder", (Object[])new Object[0]);
        this.builder = null;
    }

    private void pullResourcesFromHut() {
        IBuildingView newView = this.builder.getColony().getBuilding(this.builder.getID());
        if (newView instanceof BuildingBuilder.View) {
            BuildingBuilder.View updatedView = (BuildingBuilder.View)newView;
            PlayerInventory inventory = this.mc.field_71439_g.field_71071_by;
            boolean isCreative = this.mc.field_71439_g.func_184812_l_();
            this.resources.clear();
            this.resources.addAll(updatedView.getResources().values());
            for (BuildingBuilderResource resource : this.resources) {
                int amountToSet = isCreative ? resource.getAmount() : InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)inventory), stack -> ItemStackUtils.isEmpty(stack) == false && stack.func_77969_a(resource.getItemStack()));
                resource.setPlayerAmount(amountToSet);
            }
            this.resources.sort(new BuildingBuilderResource.ResourceComparator());
        }
    }

    public void onOpened() {
        if (this.builder == null) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.resourcescroll.nobuilder", new Object[0]));
            this.close();
            return;
        }
        super.onOpened();
        this.pullResourcesFromHut();
        ScrollingList resourceList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        if (resourceList == null) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.resourcescroll.null", new Object[0]));
            this.close();
            return;
        }
        resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowResourceList.this.resources.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                WindowResourceList.this.updateResourcePane(index, rowPane);
            }
        });
        Network.getNetwork().sendToServer(new MarkBuildingDirtyMessage(this.builder));
        ((Label)this.findPaneOfTypeByID("workerName", Label.class)).setLabelText(this.builder.getWorkerName());
        ((Label)this.findPaneOfTypeByID("constructionName", Label.class)).setLabelText(this.builder.getConstructionName());
        ((Label)this.findPaneOfTypeByID("progress", Label.class)).setLabelText(this.builder.getProgress());
    }

    private void updateResourcePane(int index, @NotNull Pane rowPane) {
        BuildingBuilderResource resource = this.resources.get(index);
        Label resourceLabel = (Label)rowPane.findPaneOfTypeByID("resourceName", Label.class);
        Label resourceMissingLabel = (Label)rowPane.findPaneOfTypeByID("resourceMissing", Label.class);
        Label neededLabel = (Label)rowPane.findPaneOfTypeByID("resourceAvailableNeeded", Label.class);
        switch (resource.getAvailabilityStatus()) {
            case DONT_HAVE: {
                resourceLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                resourceMissingLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                neededLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                break;
            }
            case NEED_MORE: {
                resourceLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                resourceMissingLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                neededLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                break;
            }
            case HAVE_ENOUGH: {
                resourceLabel.setColor(WindowHutBuilder.DARKGREEN, WindowHutBuilder.DARKGREEN);
                resourceMissingLabel.setColor(WindowHutBuilder.DARKGREEN, WindowHutBuilder.DARKGREEN);
                neededLabel.setColor(WindowHutBuilder.DARKGREEN, WindowHutBuilder.DARKGREEN);
                break;
            }
            default: {
                resourceLabel.setColor(WindowHutBuilder.BLACK, WindowHutBuilder.BLACK);
                resourceMissingLabel.setColor(WindowHutBuilder.BLACK, WindowHutBuilder.BLACK);
                neededLabel.setColor(WindowHutBuilder.BLACK, WindowHutBuilder.BLACK);
            }
        }
        resourceLabel.setLabelText(resource.getName());
        int missing = resource.getMissingFromPlayer();
        if (missing < 0) {
            resourceMissingLabel.setLabelText(Integer.toString(missing));
        } else {
            resourceMissingLabel.setLabelText("");
        }
        neededLabel.setLabelText(resource.getAvailable() + " / " + resource.getAmount());
        ((Label)rowPane.findPaneOfTypeByID("resourceId", Label.class)).setLabelText(Integer.toString(index));
        ((Label)rowPane.findPaneOfTypeByID("resourceQuantity", Label.class)).setLabelText(Integer.toString(resource.getAmount() - resource.getAvailable()));
        ItemStack stack = new ItemStack((IItemProvider)resource.getItem(), 1);
        stack.func_77982_d(resource.getItemStack().func_77978_p());
        ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(stack);
    }

    public void onUpdate() {
        super.onUpdate();
        this.pullResourcesFromHut();
        ((ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class)).refreshElementPanes();
    }
}

