/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.network.messages.server.colony.building.AddMinimumStockToBuildingMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class WindowSelectRes
extends AbstractWindowSkeleton {
    private static final String BUTTON_DONE = "done";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String INPUT_NAME = "name";
    private static final int WHITE = Color.getByName((String)"white", (int)0);
    private final List<ItemStack> allItems = new ArrayList<ItemStack>();
    private final ScrollingList resourceList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
    private final Predicate<ItemStack> test;
    private String filter = "";
    private final Window origin;
    private final IBuildingView building;

    public WindowSelectRes(Window origin, IBuildingView building, Predicate<ItemStack> test) {
        super("minecolonies:gui/windowselectres.xml");
        this.origin = origin;
        this.registerButton(BUTTON_DONE, this::doneClicked);
        this.registerButton(BUTTON_CANCEL, this::cancelClicked);
        this.registerButton("select", this::selectClicked);
        ((TextField)this.findPaneOfTypeByID("qty", TextField.class)).setText("1");
        ((ItemIcon)this.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(new ItemStack((IItemProvider)Items.field_190931_a));
        ((Label)this.findPaneOfTypeByID("resourceName", Label.class)).setLabelText(new ItemStack((IItemProvider)Items.field_190931_a).func_200301_q().func_150261_e());
        this.building = building;
        this.test = test;
    }

    private void selectClicked(Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        ItemStack to = this.allItems.get(row);
        ((ItemIcon)this.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(to);
        ((Label)this.findPaneOfTypeByID("resourceName", Label.class)).setLabelText(to.func_200301_q().func_150261_e());
    }

    private void cancelClicked() {
        this.close();
        this.origin.open();
    }

    private void doneClicked() {
        ItemStack to = ((ItemIcon)this.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).getItem();
        int qty = 1;
        try {
            qty = Integer.parseInt(((TextField)this.findPaneOfTypeByID("qty", TextField.class)).getText());
        }
        catch (NumberFormatException ex) {
            Log.getLogger().warn("Invalid input in Selection Window for Quantity, defaulting to 1!");
        }
        if (!ItemStackUtils.isEmpty((ItemStack)to).booleanValue()) {
            Network.getNetwork().sendToServer(new AddMinimumStockToBuildingMessage(this.building, to, qty));
            this.origin.open();
        }
        this.close();
    }

    public void onOpened() {
        this.updateResources();
    }

    private void updateResources() {
        this.allItems.clear();
        this.allItems.addAll((Collection<ItemStack>)ImmutableList.copyOf((Collection)StreamSupport.stream(Spliterators.spliteratorUnknownSize(ForgeRegistries.ITEMS.iterator(), 16), false).map(ItemStack::new).filter(stack -> this.test.test((ItemStack)stack) && (this.filter.isEmpty() || stack.func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.func_200301_q().func_150254_d().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)))).collect(Collectors.toList())));
        this.updateResourceList();
    }

    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        String name = ((TextField)this.findPaneOfTypeByID(INPUT_NAME, TextField.class)).getText();
        if (!name.isEmpty()) {
            this.filter = name;
        }
        this.updateResources();
        return result;
    }

    private void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        final ArrayList<ItemStack> tempRes = new ArrayList<ItemStack>(this.allItems);
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = (ItemStack)tempRes.get(index);
                Label resourceLabel = (Label)rowPane.findPaneOfTypeByID("resourceName", Label.class);
                resourceLabel.setLabelText(resource.func_200301_q().func_150261_e());
                resourceLabel.setColor(WHITE, WHITE);
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }
}

