/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.Image;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.DropDownList;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.SwitchView;
import com.ldtteam.blockout.views.View;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.CompactColonyReference;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.colonyEvents.descriptions.IBuildingEventDescription;
import com.minecolonies.api.colony.colonyEvents.descriptions.ICitizenEventDescription;
import com.minecolonies.api.colony.colonyEvents.descriptions.IColonyEventDescription;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.PermissionEvent;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.colony.workorders.WorkOrderView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowBuilding;
import com.minecolonies.coremod.client.gui.WindowBannerPicker;
import com.minecolonies.coremod.client.gui.WindowCitizen;
import com.minecolonies.coremod.client.gui.WindowHutBuilder;
import com.minecolonies.coremod.client.gui.WindowTownHallMercenary;
import com.minecolonies.coremod.client.gui.WindowTownHallNameEntry;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingBuilderView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSchool;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.colony.colonyEvents.citizenEvents.CitizenDiedEvent;
import com.minecolonies.coremod.commands.ClickEventWithExecutable;
import com.minecolonies.coremod.network.messages.PermissionsMessage;
import com.minecolonies.coremod.network.messages.server.colony.ChangeFreeToInteractBlockMessage;
import com.minecolonies.coremod.network.messages.server.colony.TeamColonyColorChangeMessage;
import com.minecolonies.coremod.network.messages.server.colony.TeleportToColonyMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleHelpMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleHousingMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleJobMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleMoveInMessage;
import com.minecolonies.coremod.network.messages.server.colony.WorkOrderChangeMessage;
import com.minecolonies.coremod.network.messages.server.colony.citizen.RecallSingleCitizenMessage;
import com.minecolonies.coremod.network.messages.server.colony.citizen.RecallTownhallMessage;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class WindowTownHall
extends AbstractWindowBuilding<ITownHallView> {
    private final List<WorkOrderView> workOrders = new ArrayList<WorkOrderView>();
    private final ITownHallView townHall;
    @NotNull
    private final List<Player> users = new ArrayList<Player>();
    @NotNull
    private final List<ICitizenDataView> citizens = new ArrayList<ICitizenDataView>();
    @NotNull
    private final Map<String, String> tabsToPages = new HashMap<String, String>();
    private DropDownList colorDropDownList;
    private Button lastTabButton;
    private ScrollingList eventList;
    private ScrollingList userList;
    private ScrollingList actionsList;
    private ScrollingList freeBlocksList;
    private final ScrollingList alliesList;
    private final ScrollingList feudsList;
    private boolean permissionEvents;

    public WindowTownHall(BuildingTownHall.View townHall) {
        super(townHall, "minecolonies:gui/townhall/windowtownhall.xml");
        this.townHall = townHall;
        this.alliesList = (ScrollingList)this.findPaneOfTypeByID("allies", ScrollingList.class);
        this.feudsList = (ScrollingList)this.findPaneOfTypeByID("feuds", ScrollingList.class);
        this.initColorPicker();
        this.updateUsers();
        this.updateCitizens();
        this.updateWorkOrders();
        this.tabsToPages.put("actions", "pageActions");
        this.tabsToPages.put("infopage", "pageInfo");
        this.tabsToPages.put("settings", "pageSettings");
        this.tabsToPages.put("permissions", "pagePermissions");
        this.tabsToPages.put("citizens", "pageCitizens");
        this.tabsToPages.put("workOrder", "pageWorkOrder");
        this.tabsToPages.put("happiness", "pageHappiness");
        this.tabsToPages.keySet().forEach(key -> this.registerButton((String)key, this::onTabClicked));
        this.registerButton("addPlayer", this::addPlayerCLicked);
        this.registerButton("rename", this::renameClicked);
        this.registerButton("mercenaries", this::mercenaryClicked);
        this.registerButton("removePlayer", this::removePlayerClicked);
        this.registerButton("promote", this::promoteDemoteClicked);
        this.registerButton("demote", this::promoteDemoteClicked);
        this.registerButton("recall", this::recallClicked);
        this.registerButton("changeSpec", this::doNothing);
        this.registerButton("toggleJob", this::toggleHiring);
        this.registerButton("toggleHousing", this::toggleHousing);
        this.registerButton("toggleMoveIn", this::toggleMoveIn);
        this.registerButton("togglePrintProgress", this::togglePrintProgress);
        this.registerButton("bannerPicker", this::openBannerPicker);
        this.registerButton("name", this::fillCitizenInfo);
        this.registerButton("recallone", this::recallOneClicked);
        this.registerButton("officerPage", this::editOfficer);
        this.registerButton("friendPage", this::editFriend);
        this.registerButton("neutralPage", this::editNeutral);
        this.registerButton("hostilePage", this::editHostile);
        this.registerButton("permissionEvents", this::permissionEventsClicked);
        this.registerButton("addfakeplayer", this::addPlayerToColonyClicked);
        this.registerButton("tp", this::teleportToColony);
        this.registerButton("plus", this::updatePriority);
        this.registerButton("minus", this::updatePriority);
        this.registerButton("delete", this::deleteWorkOrder);
        this.registerButton("trigger", this::trigger);
        this.registerButton("addBlock", this::addBlock);
        this.registerButton("removeBlock", this::removeBlock);
        ((Button)this.findPaneOfTypeByID("officerPage", Button.class)).setEnabled(false);
        this.colorDropDownList.setSelectedIndex(townHall.getColony().getTeamColonyColor().ordinal());
    }

    private void initColorPicker() {
        this.registerButton("previousColor", this::previousStyle);
        this.registerButton("nextColor", this::nextStyle);
        ((DropDownList)this.findPaneOfTypeByID("colorPicker", DropDownList.class)).setEnabled(this.enabled);
        this.colorDropDownList = (DropDownList)this.findPaneOfTypeByID("colorPicker", DropDownList.class);
        this.colorDropDownList.setHandler(this::onDropDownListChanged);
        final List textColors = Arrays.stream(TextFormatting.values()).filter(TextFormatting::func_96302_c).collect(Collectors.toList());
        this.colorDropDownList.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return textColors.size();
            }

            public String getLabel(int index) {
                if (index >= 0 && index < textColors.size()) {
                    return ((TextFormatting)textColors.get(index)).func_96297_d();
                }
                return "";
            }
        });
    }

    private void onDropDownListChanged(DropDownList dropDownList) {
        Network.getNetwork().sendToServer(new TeamColonyColorChangeMessage(dropDownList.getSelectedIndex(), this.townHall));
    }

    private void nextStyle() {
        this.colorDropDownList.selectNext();
    }

    private void previousStyle() {
        this.colorDropDownList.selectPrevious();
    }

    private void updateUsers() {
        this.users.clear();
        this.users.addAll(this.townHall.getColony().getPlayers().values());
        this.users.sort(Comparator.comparing(Player::getRank, Enum::compareTo));
    }

    private void teleportToColony(@NotNull Button button) {
        int row = this.alliesList.getListElementIndexByPane((Pane)button);
        CompactColonyReference ally = ((ITownHallView)this.building).getColony().getAllies().get(row);
        ITextComponent teleport = new StringTextComponent(LanguageHandler.format((String)"com.minecolonies.coremod.gui.townhall.tp", (Object[])new Object[]{ally.name})).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a((ClickEvent)new ClickEventWithExecutable(ClickEvent.Action.RUN_COMMAND, "", () -> Network.getNetwork().sendToServer(new TeleportToColonyMessage(ally.id, ally.dimension)))));
        Minecraft.func_71410_x().field_71439_g.func_145747_a(teleport);
        this.close();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        if (this.lastTabButton != null) {
            return;
        }
        this.createAndSetStatistics();
        ((SwitchView)this.findPaneOfTypeByID("pages", SwitchView.class)).setView("pageActions");
        this.lastTabButton = (Button)this.findPaneOfTypeByID("actions", Button.class);
        this.lastTabButton.off();
        ((Image)this.findPaneOfTypeByID(this.lastTabButton.getID() + "0", Image.class)).hide();
        ((ButtonImage)this.findPaneOfTypeByID(this.lastTabButton.getID() + "1", ButtonImage.class)).show();
        this.fillUserList();
        this.fillCitizensList();
        this.fillWorkOrderList();
        this.fillFreeBlockList();
        this.fillAlliesAndFeudsList();
        this.fillEventsList();
        this.updateHappiness();
        if (this.townHall.getColony().isManualHiring()) {
            ((Button)this.findPaneOfTypeByID("toggleJob", Button.class)).setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.hiring.on", (Object[])new Object[0]));
        }
        if (!this.townHall.getColony().isPrintingProgress()) {
            ((Button)this.findPaneOfTypeByID("togglePrintProgress", Button.class)).setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.townHall.off", (Object[])new Object[0]));
        }
        if (this.townHall.getColony().isManualHousing()) {
            ((Button)this.findPaneOfTypeByID("toggleHousing", Button.class)).setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.hiring.on", (Object[])new Object[0]));
        }
        if (this.townHall.getColony().canMoveIn()) {
            ((Button)this.findPaneOfTypeByID("toggleMoveIn", Button.class)).setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.townHall.on", (Object[])new Object[0]));
        }
        if (this.townHall.getColony().getMercenaryUseTime() != 0L && this.townHall.getColony().getWorld().func_82737_E() - this.townHall.getColony().getMercenaryUseTime() < 48000L) {
            ((Button)this.findPaneOfTypeByID("mercenaries", Button.class)).disable();
        }
    }

    private void updateCitizens() {
        this.citizens.clear();
        this.citizens.addAll(this.townHall.getColony().getCitizens().values());
    }

    private void updateWorkOrders() {
        this.workOrders.clear();
        this.workOrders.addAll(this.townHall.getColony().getWorkOrders());
        this.sortWorkOrders();
    }

    private void sortWorkOrders() {
        this.workOrders.sort(Comparator.comparing(WorkOrderView::getPriority, Comparator.reverseOrder()));
    }

    private void removeBlock(Button button) {
        int row = this.freeBlocksList.getListElementIndexByPane((Pane)button);
        if (row >= 0) {
            List<Block> freeBlocks = this.townHall.getColony().getFreeBlocks();
            List<BlockPos> freePositions = this.townHall.getColony().getFreePositions();
            if (row < freeBlocks.size()) {
                Network.getNetwork().sendToServer(new ChangeFreeToInteractBlockMessage(this.townHall.getColony(), freeBlocks.get(row), ChangeFreeToInteractBlockMessage.MessageType.REMOVE_BLOCK));
                this.townHall.getColony().removeFreeBlock(freeBlocks.get(row));
            } else if (row < freeBlocks.size() + freePositions.size()) {
                BlockPos freePos = freePositions.get(row - freeBlocks.size());
                Network.getNetwork().sendToServer(new ChangeFreeToInteractBlockMessage(this.townHall.getColony(), freePos, ChangeFreeToInteractBlockMessage.MessageType.REMOVE_BLOCK));
                this.townHall.getColony().removeFreePosition(freePos);
            }
            this.fillFreeBlockList();
        }
    }

    private void fillFreeBlockList() {
        final List<Block> freeBlocks = this.townHall.getColony().getFreeBlocks();
        final List<BlockPos> freePositions = this.townHall.getColony().getFreePositions();
        this.freeBlocksList = (ScrollingList)this.findPaneOfTypeByID("blocks", ScrollingList.class);
        this.freeBlocksList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return freeBlocks.size() + freePositions.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                if (index < freeBlocks.size()) {
                    ((Label)rowPane.findPaneOfTypeByID("name", Label.class)).setLabelText(((Block)freeBlocks.get(index)).getRegistryName().toString());
                } else {
                    BlockPos pos = (BlockPos)freePositions.get(index - freeBlocks.size());
                    ((Label)rowPane.findPaneOfTypeByID("name", Label.class)).setLabelText(pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p());
                }
            }
        });
    }

    private void addBlock() {
        TextField input = (TextField)this.findPaneOfTypeByID("addBlockName", TextField.class);
        String inputText = input.getText();
        try {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(inputText));
            if (block != null) {
                this.townHall.getColony().addFreeBlock(block);
                Network.getNetwork().sendToServer(new ChangeFreeToInteractBlockMessage(this.townHall.getColony(), block, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK));
            }
        }
        catch (ResourceLocationException block) {
            // empty catch block
        }
        BlockPos pos = BlockPosUtil.getBlockPosOfString(inputText);
        if (pos != null) {
            Network.getNetwork().sendToServer(new ChangeFreeToInteractBlockMessage(this.townHall.getColony(), pos, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK));
            this.townHall.getColony().addFreePosition(pos);
        }
        this.fillFreeBlockList();
        input.setText("");
    }

    private void trigger(@NotNull Button button) {
        Pane pane = (Pane)button.getParent().getChildren().get(2);
        int index = 0;
        if (pane instanceof Label) {
            index = Integer.valueOf(((Label)pane).getLabelText());
        }
        boolean trigger = LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon", (Object[])new Object[0]).equals(button.getLabel());
        Action action = Action.values()[index];
        Rank rank = Rank.valueOf(this.actionsList.getParent().getID().toUpperCase(Locale.ENGLISH));
        Network.getNetwork().sendToServer(new PermissionsMessage.Permission(this.townHall.getColony(), PermissionsMessage.MessageType.TOGGLE_PERMISSION, rank, action));
        this.townHall.getColony().getPermissions().togglePermission(rank, action);
        if (trigger) {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff", (Object[])new Object[0]));
        } else {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon", (Object[])new Object[0]));
        }
    }

    private void fillPermissionList(@NotNull String category) {
        this.actionsList = (ScrollingList)this.findPaneOfTypeByID("actions" + category, ScrollingList.class);
        this.actionsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return Action.values().length - 3;
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                int actionIndex = index <= 3 ? index : index + 3;
                Action action = Action.values()[actionIndex];
                String name = LanguageHandler.format((String)("com.minecolonies.coremod.permission." + action.toString().toLowerCase(Locale.US)), (Object[])new Object[0]);
                if (name.contains("com.minecolonies.coremod.permission.")) {
                    Log.getLogger().warn("Didn't work for:" + name);
                    return;
                }
                ((Label)rowPane.findPaneOfTypeByID("name", Label.class)).setLabelText(name);
                boolean isTriggered = WindowTownHall.this.townHall.getColony().getPermissions().hasPermission(Rank.valueOf(WindowTownHall.this.actionsList.getParent().getID().toUpperCase(Locale.ENGLISH)), action);
                ((Button)rowPane.findPaneOfTypeByID("trigger", Button.class)).setLabel(isTriggered ? LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon", (Object[])new Object[0]) : LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff", (Object[])new Object[0]));
                ((Label)rowPane.findPaneOfTypeByID("index", Label.class)).setLabelText(Integer.toString(actionIndex));
            }
        });
    }

    private void editOfficer() {
        ((SwitchView)this.findPaneOfTypeByID("userGroups", SwitchView.class)).setView("officer");
        ((Button)this.findPaneOfTypeByID("officerPage", Button.class)).setEnabled(false);
        ((Button)this.findPaneOfTypeByID("friendPage", Button.class)).setEnabled(true);
        ((Button)this.findPaneOfTypeByID("neutralPage", Button.class)).setEnabled(true);
        ((Button)this.findPaneOfTypeByID("hostilePage", Button.class)).setEnabled(true);
        this.fillPermissionList("officer");
    }

    private void editFriend() {
        ((SwitchView)this.findPaneOfTypeByID("userGroups", SwitchView.class)).setView("friend");
        ((Button)this.findPaneOfTypeByID("officerPage", Button.class)).setEnabled(true);
        ((Button)this.findPaneOfTypeByID("friendPage", Button.class)).setEnabled(false);
        ((Button)this.findPaneOfTypeByID("neutralPage", Button.class)).setEnabled(true);
        ((Button)this.findPaneOfTypeByID("hostilePage", Button.class)).setEnabled(true);
        this.fillPermissionList("friend");
    }

    private void editNeutral() {
        ((SwitchView)this.findPaneOfTypeByID("userGroups", SwitchView.class)).setView("neutral");
        ((Button)this.findPaneOfTypeByID("officerPage", Button.class)).setEnabled(true);
        ((Button)this.findPaneOfTypeByID("friendPage", Button.class)).setEnabled(true);
        ((Button)this.findPaneOfTypeByID("neutralPage", Button.class)).setEnabled(false);
        ((Button)this.findPaneOfTypeByID("hostilePage", Button.class)).setEnabled(true);
        this.fillPermissionList("neutral");
    }

    private void editHostile() {
        ((SwitchView)this.findPaneOfTypeByID("userGroups", SwitchView.class)).setView("hostile");
        ((Button)this.findPaneOfTypeByID("officerPage", Button.class)).setEnabled(true);
        ((Button)this.findPaneOfTypeByID("friendPage", Button.class)).setEnabled(true);
        ((Button)this.findPaneOfTypeByID("neutralPage", Button.class)).setEnabled(true);
        ((Button)this.findPaneOfTypeByID("hostilePage", Button.class)).setEnabled(false);
        this.fillPermissionList("hostile");
    }

    private void createAndSetStatistics() {
        DecimalFormat df = new DecimalFormat("#.#");
        df.setRoundingMode(RoundingMode.CEILING);
        String roundedHappiness = df.format(((ITownHallView)this.building).getColony().getOverallHappiness());
        ((Label)this.findPaneOfTypeByID("happinessLevel", Label.class)).setLabelText(roundedHappiness);
        int citizensSize = this.townHall.getColony().getCitizens().size();
        String numberOfCitizens = LanguageHandler.format((String)"com.minecolonies.coremod.gui.townHall.population.totalcitizens", (Object[])new Object[]{citizensSize, this.townHall.getColony().getCitizenCount()});
        ((Label)this.findPaneOfTypeByID("totalCitizens", Label.class)).setLabelText(numberOfCitizens);
        int children = 0;
        int totalWorkers = 0;
        HashMap<String, Tuple<Integer, Integer>> jobMaxCountMap = new HashMap<String, Tuple<Integer, Integer>>();
        for (IBuildingView building : this.townHall.getColony().getBuildings()) {
            if (!(building instanceof AbstractBuildingWorker.View)) continue;
            int max = ((AbstractBuildingWorker.View)building).getMaxInhabitants();
            int workers = ((AbstractBuildingWorker.View)building).getWorkerId().size();
            String jobName = ((AbstractBuildingWorker.View)building).getJobName().toLowerCase(Locale.ENGLISH);
            if (building instanceof AbstractBuildingGuards.View) {
                jobName = ((AbstractBuildingGuards.View)building).getGuardType().getJobTranslationKey();
            }
            if (building instanceof BuildingSchool.View) {
                String teacherJobName = LanguageHandler.format((String)"com.minecolonies.coremod.job.teacher", (Object[])new Object[0]);
                int maxTeachers = 1;
                --max;
                workers = 0;
                int teachers = 0;
                for (Integer workerId : ((BuildingSchool.View)building).getWorkerId()) {
                    ICitizenDataView view = this.townHall.getColony().getCitizen(workerId);
                    if (view != null && view.isChild()) {
                        ++workers;
                        continue;
                    }
                    ++teachers;
                }
                Tuple<Integer, Integer> teacherTuple = jobMaxCountMap.getOrDefault(teacherJobName, new Tuple<Integer, Integer>(0, 0));
                jobMaxCountMap.put(teacherJobName, new Tuple<Integer, Integer>(teacherTuple.getA() + teachers, teacherTuple.getB() + maxTeachers));
                totalWorkers += teachers;
                Tuple<Integer, Integer> tuple = jobMaxCountMap.getOrDefault(jobName, new Tuple<Integer, Integer>(0, 0));
                jobMaxCountMap.put(jobName, new Tuple<Integer, Integer>(tuple.getA() + workers, tuple.getB() + max));
                continue;
            }
            Tuple<Integer, Integer> tuple = jobMaxCountMap.getOrDefault(jobName, new Tuple<Integer, Integer>(0, 0));
            jobMaxCountMap.put(jobName, new Tuple<Integer, Integer>(tuple.getA() + workers, tuple.getB() + max));
            totalWorkers += workers;
        }
        for (ICitizenDataView iCitizenDataView : this.townHall.getColony().getCitizens().values()) {
            if (!iCitizenDataView.isChild()) continue;
            ++children;
        }
        final String numberOfUnemployed = LanguageHandler.format((String)"com.minecolonies.coremod.gui.townHall.population.unemployed", (Object[])new Object[]{citizensSize - totalWorkers - children});
        final String numberOfKids = LanguageHandler.format((String)"com.minecolonies.coremod.gui.townHall.population.childs", (Object[])new Object[]{children});
        ScrollingList list = (ScrollingList)this.findPaneOfTypeByID("citizen-stats", ScrollingList.class);
        if (list == null) {
            return;
        }
        final int maxJobs = jobMaxCountMap.size();
        final ArrayList theList = new ArrayList(jobMaxCountMap.entrySet());
        list.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return maxJobs + 2;
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                Label label = (Label)rowPane.findPaneOfTypeByID("citizensAmount", Label.class);
                if (index < theList.size()) {
                    Map.Entry entry = (Map.Entry)theList.get(index);
                    String job = LanguageHandler.format((String)((String)entry.getKey()), (Object[])new Object[0]);
                    String numberOfWorkers = LanguageHandler.format((String)"com.minecolonies.coremod.gui.townHall.population.each", (Object[])new Object[]{job, ((Tuple)entry.getValue()).getA(), ((Tuple)entry.getValue()).getB()});
                    label.setLabelText(numberOfWorkers);
                } else if (index == maxJobs + 1) {
                    label.setLabelText(numberOfUnemployed);
                } else {
                    label.setLabelText(numberOfKids);
                }
            }
        });
    }

    private void fillUserList() {
        this.userList = (ScrollingList)this.findPaneOfTypeByID("users", ScrollingList.class);
        this.userList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowTownHall.this.users.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                Player player = (Player)WindowTownHall.this.users.get(index);
                String rank = player.getRank().name();
                rank = Character.toUpperCase(rank.charAt(0)) + rank.toLowerCase(Locale.ENGLISH).substring(1);
                ((Label)rowPane.findPaneOfTypeByID("name", Label.class)).setLabelText(player.getName());
                ((Label)rowPane.findPaneOfTypeByID("rank", Label.class)).setLabelText(rank);
            }
        });
    }

    private void fillAlliesAndFeudsList() {
        this.alliesList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((ITownHallView)WindowTownHall.this.building).getColony().getAllies().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                CompactColonyReference colonyReference = ((ITownHallView)WindowTownHall.this.building).getColony().getAllies().get(index);
                ((Label)rowPane.findPaneOfTypeByID("name", Label.class)).setLabelText(colonyReference.name);
                long distance = BlockPosUtil.getDistance2D(colonyReference.center, ((ITownHallView)WindowTownHall.this.building).getPosition());
                ((Label)rowPane.findPaneOfTypeByID("dist", Label.class)).setLabelText((int)distance + "b");
                Button button = (Button)rowPane.findPaneOfTypeByID("tp", Button.class);
                if (colonyReference.hasTownHall && (WindowTownHall.this.townHall.getBuildingLevel() < (Integer)MineColonies.getConfig().getCommon().minThLevelToTeleport.get() || !WindowTownHall.this.townHall.canPlayerUseTP())) {
                    button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.townhall.tooLow", (Object[])new Object[0]));
                    button.disable();
                } else {
                    button.enable();
                }
            }
        });
        this.feudsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((ITownHallView)WindowTownHall.this.building).getColony().getFeuds().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                CompactColonyReference colonyReference = ((ITownHallView)WindowTownHall.this.building).getColony().getFeuds().get(index);
                ((Label)rowPane.findPaneOfTypeByID("name", Label.class)).setLabelText(colonyReference.name);
                long distance = BlockPosUtil.getDistance2D(colonyReference.center, ((ITownHallView)WindowTownHall.this.building).getPosition());
                ((Label)rowPane.findPaneOfTypeByID("dist", Label.class)).setLabelText(String.valueOf((int)distance));
            }
        });
    }

    private void fillEventsList() {
        this.eventList = (ScrollingList)this.findPaneOfTypeByID("eventsList", ScrollingList.class);
        this.eventList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowTownHall.this.permissionEvents ? ((ITownHallView)WindowTownHall.this.building).getPermissionEvents().size() : ((ITownHallView)WindowTownHall.this.building).getColonyEvents().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                if (WindowTownHall.this.permissionEvents) {
                    String name;
                    PermissionEvent event = ((ITownHallView)WindowTownHall.this.building).getPermissionEvents().get(index);
                    ((Label)rowPane.findPaneOfTypeByID("name", Label.class)).setLabelText(event.getName() + (event.getId() == null ? " <fake>" : ""));
                    ((Label)rowPane.findPaneOfTypeByID("pos", Label.class)).setLabelText(event.getPosition().func_177958_n() + " " + event.getPosition().func_177956_o() + " " + event.getPosition().func_177952_p());
                    if (event.getId() == null) {
                        ((Button)rowPane.findPaneOfTypeByID("addfakeplayer", Button.class)).hide();
                    }
                    if ((name = LanguageHandler.format((String)("com.minecolonies.coremod.permission." + event.getAction().toString().toLowerCase(Locale.US)), (Object[])new Object[0])).contains("com.minecolonies.coremod.permission.")) {
                        Log.getLogger().warn("Didn't work for:" + name);
                        return;
                    }
                    ((Label)rowPane.findPaneOfTypeByID("action", Label.class)).setLabelText(name);
                } else {
                    IColonyEventDescription event = ((ITownHallView)WindowTownHall.this.building).getColonyEvents().get(index);
                    if (event instanceof CitizenDiedEvent) {
                        ((Label)rowPane.findPaneOfTypeByID("action", Label.class)).setLabelText(((CitizenDiedEvent)event).getDeathCause());
                    } else {
                        ((Label)rowPane.findPaneOfTypeByID("action", Label.class)).setLabelText(event.getName());
                    }
                    if (event instanceof ICitizenEventDescription) {
                        ((Label)rowPane.findPaneOfTypeByID("name", Label.class)).setLabelText(((ICitizenEventDescription)event).getCitizenName());
                    } else if (event instanceof IBuildingEventDescription) {
                        IBuildingEventDescription buildEvent = (IBuildingEventDescription)event;
                        ((Label)rowPane.findPaneOfTypeByID("name", Label.class)).setLabelText(buildEvent.getBuildingName() + " " + buildEvent.getLevel());
                    }
                    ((Label)rowPane.findPaneOfTypeByID("pos", Label.class)).setLabelText(event.getEventPos().func_177958_n() + " " + event.getEventPos().func_177956_o() + " " + event.getEventPos().func_177952_p());
                    ((Button)rowPane.findPaneOfTypeByID("addfakeplayer", Button.class)).hide();
                }
            }
        });
    }

    private void updateHappiness() {
        HashMap<String, Double> happinessMap = new HashMap<String, Double>();
        for (ICitizenDataView data : ((ITownHallView)this.building).getColony().getCitizens().values()) {
            for (String string : data.getHappinessHandler().getModifiers()) {
                happinessMap.put(string, happinessMap.getOrDefault(string, 0.0) + data.getHappinessHandler().getModifier(string).getFactor());
            }
        }
        View pane = (View)this.findPaneOfTypeByID("happinesspage", View.class);
        int yPos = 62;
        for (Map.Entry entry : happinessMap.entrySet()) {
            double value = (Double)entry.getValue() / (double)this.citizens.size();
            Image image = new Image();
            image.setSize(11, 11);
            image.setPosition(25, yPos);
            Label label = new Label();
            label.setSize(136, 11);
            label.setPosition(50, yPos);
            label.setColor(WindowHutBuilder.BLACK);
            label.setLabelText(LanguageHandler.format((String)("com.minecolonies.coremod.gui.townhall.happiness." + (String)entry.getKey()), (Object[])new Object[0]));
            if (value > 1.0) {
                image.setImage("minecolonies:textures/gui/green_icon.png");
            } else if (value == 1.0) {
                image.setImage("minecolonies:textures/gui/blue_icon.png");
            } else if (value > 0.75) {
                image.setImage("minecolonies:textures/gui/yellow_icon.png");
            } else {
                image.setImage("minecolonies:textures/gui/red_icon.png");
            }
            pane.addChild((Pane)image);
            pane.addChild((Pane)label);
            yPos += 12;
        }
    }

    private void updatePriority(@NotNull Button button) {
        Label idLabel = (Label)button.getParent().getChildren().get(5);
        int id = Integer.parseInt(idLabel.getLabelText());
        String buttonLabel = button.getID();
        for (int i = 0; i < this.workOrders.size(); ++i) {
            WorkOrderView workOrder = this.workOrders.get(i);
            if (workOrder.getId() != id) continue;
            if (buttonLabel.equals("plus") && i > 0) {
                workOrder.setPriority(this.workOrders.get(i - 1).getPriority() + 1);
                Network.getNetwork().sendToServer(new WorkOrderChangeMessage(this.building, id, false, workOrder.getPriority()));
            } else if (buttonLabel.equals("minus") && i <= this.workOrders.size()) {
                workOrder.setPriority(this.workOrders.get(i + 1).getPriority() - 1);
                Network.getNetwork().sendToServer(new WorkOrderChangeMessage(this.building, id, false, workOrder.getPriority()));
            }
            this.sortWorkOrders();
            ((ScrollingList)this.window.findPaneOfTypeByID("workOrderList", ScrollingList.class)).refreshElementPanes();
            return;
        }
    }

    private void deleteWorkOrder(@NotNull Button button) {
        Label idLabel = (Label)button.getParent().getChildren().get(5);
        int id = Integer.parseInt(idLabel.getLabelText());
        for (int i = 0; i < this.workOrders.size(); ++i) {
            if (this.workOrders.get(i).getId() != id) continue;
            this.workOrders.remove(i);
            break;
        }
        Network.getNetwork().sendToServer(new WorkOrderChangeMessage(this.building, id, true, 0));
        ((ScrollingList)this.window.findPaneOfTypeByID("workOrderList", ScrollingList.class)).refreshElementPanes();
    }

    private void fillCitizenInfo(Button button) {
        ScrollingList citizenList = (ScrollingList)this.findPaneOfTypeByID("citizenList", ScrollingList.class);
        for (Pane pane : citizenList.getContainer().getChildren()) {
            ((ButtonImage)pane.findPaneOfTypeByID("name", ButtonImage.class)).enable();
        }
        int row = citizenList.getListElementIndexByPane((Pane)button);
        this.findPaneByID("citizenInfoBox").show();
        button.disable();
        ICitizenDataView view = this.citizens.get(row);
        WindowCitizen.createHappinessBar(view, this);
        WindowCitizen.createSkillContent(view, this);
        ((Label)this.findPaneOfTypeByID("job", Label.class)).setLabelText("\u00a7l" + LanguageHandler.format((String)(view.getJob().trim().isEmpty() ? "com.minecolonies.coremod.gui.townHall.citizens.unemployed" : view.getJob()), (Object[])new Object[0]));
        ((Label)this.findPaneOfTypeByID("hiddenCitizenId", Label.class)).setLabelText(String.valueOf(view.getId()));
    }

    private void recallOneClicked(Button button) {
        String citizenidLabel = ((Label)button.getParent().findPaneOfTypeByID("hiddenCitizenId", Label.class)).getLabelText();
        int citizenid = Integer.parseInt(citizenidLabel);
        Network.getNetwork().sendToServer(new RecallSingleCitizenMessage(this.townHall, citizenid));
    }

    private void fillCitizensList() {
        ScrollingList citizenList = (ScrollingList)this.findPaneOfTypeByID("citizenList", ScrollingList.class);
        citizenList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowTownHall.this.citizens.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ICitizenDataView citizen = (ICitizenDataView)WindowTownHall.this.citizens.get(index);
                ((ButtonImage)rowPane.findPaneOfTypeByID("name", ButtonImage.class)).setLabel(citizen.getName());
            }
        });
    }

    private void fillWorkOrderList() {
        ScrollingList workOrderList = (ScrollingList)this.findPaneOfTypeByID("workOrderList", ScrollingList.class);
        workOrderList.enable();
        workOrderList.show();
        workOrderList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowTownHall.this.workOrders.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                WorkOrderView workOrder = (WorkOrderView)WindowTownHall.this.workOrders.get(index);
                String claimingCitizen = "";
                int numElements = this.getElementCount();
                if (index == 0) {
                    if (numElements == 1) {
                        ((Button)rowPane.findPaneOfTypeByID("minus", Button.class)).hide();
                    } else {
                        ((Button)rowPane.findPaneOfTypeByID("minus", Button.class)).show();
                    }
                    ((Button)rowPane.findPaneOfTypeByID("plus", Button.class)).hide();
                } else if (index == numElements - 1) {
                    ((Button)rowPane.findPaneOfTypeByID("minus", Button.class)).hide();
                }
                for (IBuildingView buildingView : ((ITownHallView)WindowTownHall.this.building).getColony().getBuildings()) {
                    if (!buildingView.getPosition().equals((Object)workOrder.getClaimedBy()) || !(buildingView instanceof AbstractBuildingBuilderView)) continue;
                    claimingCitizen = ((AbstractBuildingBuilderView)buildingView).getWorkerName();
                    break;
                }
                ((Label)rowPane.findPaneOfTypeByID("work", Label.class)).setLabelText(workOrder.get());
                ((Label)rowPane.findPaneOfTypeByID("assignee", Label.class)).setLabelText(claimingCitizen);
                ((Label)rowPane.findPaneOfTypeByID("hiddenId", Label.class)).setLabelText(Integer.toString(workOrder.getId()));
            }
        });
    }

    private void toggleHiring(@NotNull Button button) {
        boolean toggle;
        if (button.getLabel().equals(LanguageHandler.format((String)"com.minecolonies.coremod.gui.hiring.off", (Object[])new Object[0]))) {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.hiring.on", (Object[])new Object[0]));
            toggle = true;
        } else {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.hiring.off", (Object[])new Object[0]));
            toggle = false;
        }
        Network.getNetwork().sendToServer(new ToggleJobMessage(((ITownHallView)this.building).getColony(), toggle));
    }

    private void toggleHousing(@NotNull Button button) {
        boolean toggle;
        if (button.getLabel().equals(LanguageHandler.format((String)"com.minecolonies.coremod.gui.hiring.off", (Object[])new Object[0]))) {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.hiring.on", (Object[])new Object[0]));
            toggle = true;
        } else {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.hiring.off", (Object[])new Object[0]));
            toggle = false;
        }
        Network.getNetwork().sendToServer(new ToggleHousingMessage(((ITownHallView)this.building).getColony(), toggle));
    }

    private void toggleMoveIn(@NotNull Button button) {
        boolean toggle;
        if (button.getLabel().equals(LanguageHandler.format((String)"com.minecolonies.coremod.gui.townHall.off", (Object[])new Object[0]))) {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.townHall.on", (Object[])new Object[0]));
            toggle = true;
        } else {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.townHall.off", (Object[])new Object[0]));
            toggle = false;
        }
        Network.getNetwork().sendToServer(new ToggleMoveInMessage(((ITownHallView)this.building).getColony(), toggle));
    }

    private void togglePrintProgress(@NotNull Button button) {
        if (button.getLabel().equals(LanguageHandler.format((String)"com.minecolonies.coremod.gui.townHall.off", (Object[])new Object[0]))) {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.townHall.on", (Object[])new Object[0]));
        } else {
            button.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.townHall.off", (Object[])new Object[0]));
        }
        Network.getNetwork().sendToServer(new ToggleHelpMessage(((ITownHallView)this.building).getColony()));
    }

    private void openBannerPicker(@NotNull Button button) {
        WindowBannerPicker window = new WindowBannerPicker(this.townHall.getColony(), this);
        Minecraft.func_71410_x().execute(() -> Minecraft.func_71410_x().func_147108_a(window));
    }

    private void onTabClicked(@NotNull Button button) {
        String oldId = this.lastTabButton.getID();
        String newId = button.getID();
        ((SwitchView)this.findPaneOfTypeByID("pages", SwitchView.class)).setView(this.tabsToPages.get(newId));
        ((Image)this.findPaneOfTypeByID(oldId + "0", Image.class)).show();
        ((ButtonImage)this.findPaneOfTypeByID(oldId + "1", ButtonImage.class)).hide();
        ((Image)this.findPaneOfTypeByID(newId + "0", Image.class)).hide();
        ((ButtonImage)this.findPaneOfTypeByID(newId + "1", ButtonImage.class)).show();
        this.lastTabButton.on();
        button.off();
        this.lastTabButton = button;
        this.setPage("");
    }

    @Override
    public String getBuildingName() {
        return this.townHall.getColony().getName();
    }

    @Override
    public void onUpdate() {
        String currentPage;
        super.onUpdate();
        switch (currentPage = ((SwitchView)this.findPaneOfTypeByID("pages", SwitchView.class)).getCurrentView().getID()) {
            case "pagePermissions": {
                this.updateUsers();
                ((ScrollingList)this.window.findPaneOfTypeByID("users", ScrollingList.class)).refreshElementPanes();
                break;
            }
            case "pageCitizens": {
                this.updateCitizens();
                ((ScrollingList)this.window.findPaneOfTypeByID("citizenList", ScrollingList.class)).refreshElementPanes();
                break;
            }
            case "pageWorkOrder": {
                this.updateWorkOrders();
                ((ScrollingList)this.window.findPaneOfTypeByID("workOrderList", ScrollingList.class)).refreshElementPanes();
            }
        }
    }

    private void renameClicked() {
        WindowTownHallNameEntry window = new WindowTownHallNameEntry(this.townHall.getColony());
        window.open();
    }

    private void mercenaryClicked() {
        WindowTownHallMercenary window = new WindowTownHallMercenary(this.townHall.getColony());
        window.open();
    }

    private void addPlayerCLicked() {
        TextField input = (TextField)this.findPaneOfTypeByID("addPlayerName", TextField.class);
        Network.getNetwork().sendToServer(new PermissionsMessage.AddPlayer(this.townHall.getColony(), input.getText()));
        input.setText("");
    }

    private void removePlayerClicked(Button button) {
        Player user;
        int row = this.userList.getListElementIndexByPane((Pane)button);
        if (row >= 0 && row < this.users.size() && (user = this.users.get(row)).getRank() != Rank.OWNER) {
            Network.getNetwork().sendToServer(new PermissionsMessage.RemovePlayer(this.townHall.getColony(), user.getID()));
        }
    }

    private void addPlayerToColonyClicked(@NotNull Button button) {
        int row = this.eventList.getListElementIndexByPane((Pane)button);
        if (row >= 0 && row < ((ITownHallView)this.building).getPermissionEvents().size()) {
            PermissionEvent user = ((ITownHallView)this.building).getPermissionEvents().get(row);
            Network.getNetwork().sendToServer(new PermissionsMessage.AddPlayerOrFakePlayer(this.townHall.getColony(), user.getName(), user.getId()));
        }
    }

    private void promoteDemoteClicked(@NotNull Button button) {
        int row = this.userList.getListElementIndexByPane((Pane)button);
        if (row >= 0 && row < this.users.size()) {
            Player user = this.users.get(row);
            if (button.getID().equals("promote")) {
                Network.getNetwork().sendToServer(new PermissionsMessage.ChangePlayerRank(this.townHall.getColony(), user.getID(), PermissionsMessage.ChangePlayerRank.Type.PROMOTE));
            } else {
                Network.getNetwork().sendToServer(new PermissionsMessage.ChangePlayerRank(this.townHall.getColony(), user.getID(), PermissionsMessage.ChangePlayerRank.Type.DEMOTE));
            }
        }
    }

    private void recallClicked() {
        Network.getNetwork().sendToServer(new RecallTownhallMessage(this.townHall.getColony()));
    }

    @Override
    public void setPage(@NotNull String button) {
        String curSwitch = this.lastTabButton == null ? ((Button)this.findPaneOfTypeByID("actions", Button.class)).getID() : this.lastTabButton.getID();
        this.switchView = (SwitchView)this.findPaneOfTypeByID("switch" + this.tabsToPages.get(curSwitch), SwitchView.class);
        this.pageNum.on();
        super.setPage(button);
        if (this.switchView.getCurrentView().getID().equals("managePermissions")) {
            this.editOfficer();
        }
    }

    public void permissionEventsClicked(@NotNull Button button) {
        this.permissionEvents = !this.permissionEvents;
        button.setLabel(LanguageHandler.format((String)(this.permissionEvents ? "com.minecolonies.coremod.gui.townHall.colonyevents" : "com.minecolonies.coremod.gui.townHall.permissionevents"), (Object[])new Object[0]));
    }
}

