/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.IJobDataManager;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.entity.citizen.AbstractCivilianEntity;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSkillHandler;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.interactionhandling.ServerCitizenInteraction;
import com.minecolonies.coremod.colony.interactionhandling.SimpleNotificationInteraction;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenHappinessHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenSkillHandler;
import com.minecolonies.coremod.research.AdditionModifierResearchEffect;
import com.minecolonies.coremod.research.MultiplierModifierResearchEffect;
import com.minecolonies.coremod.util.AttributeModifierUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenData
implements ICitizenData {
    private static final float MAX_HEALTH = 20.0f;
    private static final int LETTERS_IN_THE_ALPHABET = 26;
    private static final int MIN_SATURATION = 0;
    private static final List<String> SUFFIXES = Arrays.asList("_b", "_d", "_a", "_w");
    private final int id;
    private final IColony colony;
    protected InventoryCitizen inventory;
    private String name;
    private boolean female;
    private boolean isChild = false;
    private boolean paused;
    private boolean restartScheduled;
    private ServerPlayerEntity originPlayerRestart;
    private int textureId;
    private boolean isAsleep;
    private BlockPos bedPos = BlockPos.field_177992_a;
    @Nullable
    private IBuilding homeBuilding;
    @Nullable
    private IBuildingWorker workBuilding;
    private IJob<?> job;
    private boolean dirty;
    @NotNull
    private WeakReference<AbstractEntityCitizen> entity = new WeakReference<Object>(null);
    private double saturation;
    private boolean justAte;
    private BlockPos lastPosition = new BlockPos(0, 0, 0);
    private final CitizenHappinessHandler citizenHappinessHandler;
    private final CitizenSkillHandler citizenSkillHandler;
    protected final Map<ITextComponent, IInteractionResponseHandler> citizenChatOptions = new HashMap<ITextComponent, IInteractionResponseHandler>();
    private boolean idle;
    private String textureSuffix;
    private VisibleCitizenStatus status;
    private Random random = new Random();
    private static final int NO_GUARD_COMPLAIN_CHANCE = 10;

    public CitizenData(int id, IColony colony) {
        this.id = id;
        this.colony = colony;
        this.inventory = new InventoryCitizen("Minecolonies Inventory", true, this);
        this.citizenHappinessHandler = new CitizenHappinessHandler(this);
        this.citizenSkillHandler = new CitizenSkillHandler();
    }

    @Override
    public void onResponseTriggered(@NotNull ITextComponent key, @NotNull ITextComponent response, PlayerEntity player) {
        if (this.citizenChatOptions.containsKey(key)) {
            this.citizenChatOptions.get(key).onServerResponseTriggered(response, player, this);
            this.markDirty();
        }
    }

    @Override
    @NotNull
    public Optional<AbstractEntityCitizen> getEntity() {
        AbstractEntityCitizen citizen = (AbstractEntityCitizen)this.entity.get();
        return Optional.ofNullable(citizen);
    }

    @Override
    public void setEntity(@Nullable AbstractCivilianEntity citizen) {
        if (this.entity.get() != null) {
            this.entity.clear();
        }
        if (citizen != null) {
            this.entity = new WeakReference<AbstractEntityCitizen>((AbstractEntityCitizen)citizen);
            citizen.setCivilianData(this);
        }
    }

    @Override
    public void markDirty() {
        this.dirty = true;
        this.colony.getCitizenManager().markDirty();
    }

    private static String getRandomElement(@NotNull Random rand, @NotNull String[] array) {
        return array[rand.nextInt(array.length)];
    }

    private static char getRandomLetter(@NotNull Random rand) {
        return (char)(rand.nextInt(26) + 65);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CitizenData data = (CitizenData)o;
        if (this.id != data.id) {
            return false;
        }
        return this.colony != null ? data.colony != null && this.colony.getID() == data.colony.getID() : data.colony == null;
    }

    @Override
    public IColony getColony() {
        return this.colony;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void initForNewCivilian() {
        this.female = this.random.nextBoolean();
        this.textureSuffix = SUFFIXES.get(this.random.nextInt(SUFFIXES.size()));
        this.paused = false;
        this.name = this.generateName(this.random);
        this.textureId = this.random.nextInt(255);
        this.saturation = 10.0;
        int levelCap = (int)this.colony.getOverallHappiness();
        this.citizenSkillHandler.init(levelCap);
        this.markDirty();
    }

    @Override
    public void initEntityValues() {
        if (!this.getEntity().isPresent()) {
            return;
        }
        AbstractEntityCitizen citizen = this.getEntity().get();
        citizen.setCitizenId(this.getId());
        citizen.getCitizenColonyHandler().setColonyId(this.getColony().getID());
        citizen.setIsChild(this.isChild());
        citizen.func_200203_b((ITextComponent)new StringTextComponent(this.getName()));
        citizen.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        citizen.setFemale(this.isFemale());
        citizen.setTextureId(this.getTextureId());
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_COLONY_ID, (Object)this.colony.getID());
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_CITIZEN_ID, (Object)citizen.getCivilianID());
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_IS_FEMALE, (Object)(citizen.isFemale() ? 1 : 0));
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_TEXTURE, (Object)citizen.getTextureId());
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_TEXTURE_SUFFIX, (Object)this.getTextureSuffix());
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_IS_ASLEEP, (Object)this.isAsleep());
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_IS_CHILD, (Object)this.isChild());
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_BED_POS, (Object)this.getBedPos());
        citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_STYLE, (Object)this.colony.getStyle());
        citizen.getCitizenExperienceHandler().updateLevel();
        this.setLastPosition(citizen.func_180425_c());
        citizen.getCitizenJobHandler().onJobChanged(citizen.getCitizenJobHandler().getColonyJob());
        this.applyResearchEffects();
        this.markDirty();
    }

    private String generateName(@NotNull Random rand) {
        String firstName = this.female ? CitizenData.getRandomElement(rand, ((List)MineColonies.getConfig().getServer().femaleFirstNames.get()).toArray(new String[0])) : CitizenData.getRandomElement(rand, ((List)MineColonies.getConfig().getServer().maleFirstNames.get()).toArray(new String[0]));
        String middleInitial = String.valueOf(CitizenData.getRandomLetter(rand));
        String lastName = CitizenData.getRandomElement(rand, ((List)MineColonies.getConfig().getServer().lastNames.get()).toArray(new String[0]));
        String citizenName = (Boolean)MineColonies.getConfig().getServer().useMiddleInitial.get() != false ? String.format("%s %s. %s", firstName, middleInitial, lastName) : String.format("%s %s", firstName, lastName);
        for (ICitizenData citizen : this.getColony().getCitizenManager().getCitizens()) {
            if (citizen == null || !citizen.getName().equals(citizenName)) continue;
            citizenName = this.generateName(rand);
            break;
        }
        return citizenName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFemale() {
        return this.female;
    }

    @Override
    public void setIsFemale(@NotNull boolean isFemale) {
        this.female = isFemale;
        this.name = this.generateName(this.random);
        this.markDirty();
    }

    @Override
    public void setPaused(boolean p) {
        this.paused = p;
        this.markDirty();
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public int getTextureId() {
        return this.textureId;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void clearDirty() {
        this.dirty = false;
    }

    @Override
    public void onRemoveBuilding(IBuilding building) {
        if (this.getHomeBuilding() == building) {
            this.setHomeBuilding(null);
        }
        if (this.getWorkBuilding() == building) {
            this.setWorkBuilding(null);
        }
    }

    @Override
    @Nullable
    public IBuilding getHomeBuilding() {
        return this.homeBuilding;
    }

    @Override
    public void setHomeBuilding(@Nullable IBuilding building) {
        if (this.homeBuilding != null && building != null && !this.homeBuilding.equals(building)) {
            this.homeBuilding.removeCitizen(this);
        }
        this.homeBuilding = building;
        this.markDirty();
        if (this.getEntity().isPresent() && this.getEntity().get().getCitizenJobHandler().getColonyJob() == null) {
            this.getEntity().get().getCitizenJobHandler().setModelDependingOnJob(null);
        }
        this.setBedPos(BlockPos.field_177992_a);
    }

    @Override
    @Nullable
    public IBuildingWorker getWorkBuilding() {
        return this.workBuilding;
    }

    @Override
    public void setWorkBuilding(@Nullable IBuildingWorker building) {
        if (this.workBuilding != null && building != null && this.workBuilding != building) {
            Log.getLogger().warn("CitizenData.setWorkBuilding() - already assigned a work building when setting a new work building");
        } else if (this.workBuilding != building) {
            this.workBuilding = building;
            if (this.workBuilding != null) {
                if (this.job == null) {
                    this.setJob(this.workBuilding.createJob(this));
                    this.colony.getWorkManager().clearWorkForCitizen(this);
                }
            } else if (this.job != null) {
                this.getEntity().ifPresent(entityCitizen -> entityCitizen.getTasks().field_220892_d.stream().filter(task -> task.func_220772_j() instanceof AbstractAISkeleton).findFirst().ifPresent(e -> entityCitizen.getTasks().func_85156_a((Goal)e)));
                this.setJob(null);
                this.colony.getWorkManager().clearWorkForCitizen(this);
            }
            this.markDirty();
        }
    }

    @Override
    public void updateEntityIfNecessary() {
        Entity entity;
        if (this.getEntity().isPresent() && (entity = (Entity)this.getEntity().get()).func_70089_S() && entity.field_70175_ag && WorldUtil.isEntityBlockLoaded((IWorld)entity.field_70170_p, entity.func_180425_c())) {
            return;
        }
        this.colony.getCitizenManager().spawnOrCreateCivilian(this, this.colony.getWorld(), this.lastPosition, true);
    }

    @Override
    public IJob<?> getJob() {
        return this.job;
    }

    @Override
    public void setJob(IJob<?> job) {
        if (this.job != null && job == null) {
            this.job.onRemoval();
        }
        this.job = job;
        this.getEntity().ifPresent(entityCitizen -> entityCitizen.getCitizenJobHandler().onJobChanged(job));
        this.markDirty();
    }

    @Override
    @Nullable
    public <J extends IJob<?>> J getJob(@NotNull Class<J> type) {
        if (type.isInstance(this.job)) {
            return (J)((IJob)type.cast(this.job));
        }
        return null;
    }

    @Override
    public void serializeViewNetworkData(@NotNull PacketBuffer buf) {
        buf.func_180714_a(this.name);
        buf.writeBoolean(this.female);
        buf.writeInt(this.getEntity().map(Entity::func_145782_y).orElse(-1).intValue());
        buf.writeBoolean(this.paused);
        buf.writeBoolean(this.isChild);
        buf.writeBoolean(this.homeBuilding != null);
        if (this.homeBuilding != null) {
            buf.func_179255_a(this.homeBuilding.getID());
        }
        buf.writeBoolean(this.workBuilding != null);
        if (this.workBuilding != null) {
            buf.func_179255_a(this.workBuilding.getID());
        }
        buf.writeFloat(this.getEntity().map(LivingEntity::func_110143_aJ).orElse(Float.valueOf(20.0f)).floatValue());
        buf.writeFloat(this.getEntity().map(LivingEntity::func_110138_aP).orElse(Float.valueOf(20.0f)).floatValue());
        buf.writeDouble(this.getSaturation());
        buf.writeDouble(this.citizenHappinessHandler.getHappiness());
        buf.func_150786_a(this.citizenSkillHandler.write());
        buf.func_180714_a(this.job != null ? this.job.getName() : "");
        buf.writeInt(this.colony.getID());
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("inventory", (INBT)this.inventory.write(new ListNBT()));
        buf.func_150786_a(compound);
        buf.func_179255_a(this.lastPosition);
        if (this.colony.getWorld() != null) {
            List subInteractions = this.citizenChatOptions.values().stream().filter(e -> e.isVisible(this.colony.getWorld())).collect(Collectors.toList());
            buf.writeInt(subInteractions.size());
            for (IInteractionResponseHandler interactionHandler : subInteractions) {
                buf.func_150786_a((CompoundNBT)interactionHandler.serializeNBT());
            }
        } else {
            buf.writeInt(0);
        }
        CompoundNBT happinessCompound = new CompoundNBT();
        this.citizenHappinessHandler.write(happinessCompound);
        buf.func_150786_a(happinessCompound);
        buf.writeInt(this.status != null ? this.status.getId() : -1);
        buf.writeBoolean(this.job != null);
        if (this.job != null) {
            this.job.serializeToView(buf);
        }
    }

    @Override
    public void increaseSaturation(double extraSaturation) {
        this.saturation = Math.min(10.0, this.saturation + Math.abs(extraSaturation));
    }

    @Override
    public void decreaseSaturation(double extraSaturation) {
        if (this.colony != null && this.colony.isActive()) {
            this.saturation = Math.max(0.0, this.saturation - Math.abs(extraSaturation * (Double)MineColonies.getConfig().getCommon().foodModifier.get()));
            this.justAte = false;
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setLastPosition(BlockPos lastPosition) {
        this.lastPosition = lastPosition;
    }

    @Override
    public BlockPos getLastPosition() {
        return this.lastPosition;
    }

    @Override
    public double getSaturation() {
        return this.saturation;
    }

    @Override
    public void setSaturation(double saturation) {
        this.saturation = saturation;
    }

    @Override
    public InventoryCitizen getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isAsleep() {
        return this.isAsleep;
    }

    @Override
    public BlockPos getBedPos() {
        return this.bedPos;
    }

    @Override
    public void setAsleep(boolean asleep) {
        this.isAsleep = asleep;
    }

    @Override
    public void setBedPos(BlockPos bedPos) {
        this.bedPos = bedPos;
    }

    @Override
    public CitizenHappinessHandler getCitizenHappinessHandler() {
        return this.citizenHappinessHandler;
    }

    @Override
    public ICitizenSkillHandler getCitizenSkillHandler() {
        return this.citizenSkillHandler;
    }

    @Override
    public void scheduleRestart(ServerPlayerEntity player) {
        this.originPlayerRestart = player;
        this.restartScheduled = true;
    }

    @Override
    public boolean shouldRestart() {
        return this.restartScheduled;
    }

    @Override
    public void restartDone() {
        this.restartScheduled = false;
        LanguageHandler.sendPlayerMessage((PlayerEntity)this.originPlayerRestart, (String)"com.minecolonies.coremod.gui.hiring.restartMessageDone", (Object[])new Object[]{this.getName()});
    }

    @Override
    public void setIsChild(boolean isChild) {
        this.isChild = isChild;
        this.markDirty();
        if (this.colony != null) {
            this.colony.updateHasChilds();
        }
    }

    @Override
    public boolean isChild() {
        return this.isChild;
    }

    @Override
    public boolean justAte() {
        return this.justAte;
    }

    @Override
    public void setJustAte(boolean justAte) {
        this.justAte = justAte;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        nbtTagCompound.func_74768_a("id", this.id);
        nbtTagCompound.func_74778_a("name", this.name);
        nbtTagCompound.func_74778_a("suffix", this.textureSuffix);
        nbtTagCompound.func_74757_a("female", this.female);
        nbtTagCompound.func_74757_a("paused", this.paused);
        nbtTagCompound.func_74757_a("child", this.isChild);
        nbtTagCompound.func_74768_a("texture", this.textureId);
        nbtTagCompound.func_218657_a("newSkills", (INBT)this.citizenSkillHandler.write());
        BlockPosUtil.write(nbtTagCompound, "pos", this.getEntity().isPresent() ? this.getEntity().get().func_180425_c() : this.lastPosition);
        nbtTagCompound.func_74780_a("saturation", this.saturation);
        if (this.job != null) {
            INBT jobCompound = this.job.serializeNBT();
            nbtTagCompound.func_218657_a("job", jobCompound);
        }
        this.citizenHappinessHandler.write(nbtTagCompound);
        nbtTagCompound.func_218657_a("inventory", (INBT)this.inventory.write(new ListNBT()));
        nbtTagCompound.func_74768_a("HeldItemSlot", this.inventory.getHeldItemSlot(Hand.MAIN_HAND));
        nbtTagCompound.func_74768_a("OffhandHeldItemSlot", this.inventory.getHeldItemSlot(Hand.OFF_HAND));
        BlockPosUtil.write(nbtTagCompound, "beds", this.bedPos);
        nbtTagCompound.func_74757_a("asleep", this.isAsleep);
        nbtTagCompound.func_74757_a("justAte", this.justAte);
        ListNBT chatTagList = new ListNBT();
        for (IInteractionResponseHandler entry : this.citizenChatOptions.values()) {
            CompoundNBT chatOptionCompound = new CompoundNBT();
            chatOptionCompound.func_218657_a("chatoption", entry.serializeNBT());
            chatTagList.add((Object)chatOptionCompound);
        }
        nbtTagCompound.func_218657_a("chatoptions", (INBT)chatTagList);
        nbtTagCompound.func_74757_a("idle", this.idle);
        return nbtTagCompound;
    }

    public void deserializeNBT(CompoundNBT nbtTagCompound) {
        this.name = nbtTagCompound.func_74779_i("name");
        this.female = nbtTagCompound.func_74767_n("female");
        this.paused = nbtTagCompound.func_74767_n("paused");
        this.isChild = nbtTagCompound.func_74767_n("child");
        this.textureId = nbtTagCompound.func_74762_e("texture");
        this.textureSuffix = nbtTagCompound.func_150296_c().contains("suffix") ? nbtTagCompound.func_74779_i("suffix") : SUFFIXES.get(this.random.nextInt(SUFFIXES.size()));
        this.lastPosition = BlockPosUtil.read(nbtTagCompound, "pos");
        this.citizenSkillHandler.read(nbtTagCompound.func_74775_l("newSkills"));
        this.saturation = nbtTagCompound.func_74769_h("saturation");
        if (nbtTagCompound.func_150296_c().contains("job")) {
            this.setJob(IJobDataManager.getInstance().createFrom(this, nbtTagCompound.func_74775_l("job")));
        }
        if (nbtTagCompound.func_150296_c().contains("inventory")) {
            ListNBT nbttaglist = nbtTagCompound.func_150295_c("inventory", 10);
            this.inventory.read(nbttaglist);
            this.inventory.setHeldItem(Hand.MAIN_HAND, nbtTagCompound.func_74762_e("HeldItemSlot"));
            this.inventory.setHeldItem(Hand.OFF_HAND, nbtTagCompound.func_74762_e("OffhandHeldItemSlot"));
        }
        if (this.name.isEmpty()) {
            this.name = this.generateName(this.random);
        }
        if (nbtTagCompound.func_150296_c().contains("asleep")) {
            this.bedPos = BlockPosUtil.read(nbtTagCompound, "beds");
            this.isAsleep = nbtTagCompound.func_74767_n("asleep");
        }
        if (nbtTagCompound.func_150296_c().contains("justAte")) {
            this.justAte = nbtTagCompound.func_74767_n("justAte");
        }
        if (nbtTagCompound.func_150296_c().contains("chatoptions")) {
            ListNBT handlerTagList = nbtTagCompound.func_150295_c("chatoptions", 10);
            for (int i = 0; i < handlerTagList.size(); ++i) {
                ServerCitizenInteraction handler = (ServerCitizenInteraction)MinecoloniesAPIProxy.getInstance().getInteractionResponseHandlerDataManager().createFrom(this, handlerTagList.func_150305_b(i).func_74775_l("chatoption"));
                this.citizenChatOptions.put(handler.getInquiry(), handler);
            }
        }
        this.citizenHappinessHandler.read(nbtTagCompound);
        if (nbtTagCompound.func_150296_c().contains("levelMap") && !nbtTagCompound.func_150296_c().contains("newSkills")) {
            this.citizenSkillHandler.init((int)this.citizenHappinessHandler.getHappiness());
            HashMap<String, Integer> levels = new HashMap<String, Integer>();
            ListNBT levelTagList = nbtTagCompound.func_150295_c("levelMap", 10);
            for (int i = 0; i < levelTagList.size(); ++i) {
                CompoundNBT levelExperienceAtJob = levelTagList.func_150305_b(i);
                String jobName = levelExperienceAtJob.func_74779_i("name");
                int level = Math.min(levelExperienceAtJob.func_74762_e("level"), 99);
                levels.put(jobName, level);
            }
            for (Map.Entry entry : levels.entrySet()) {
                Skill primary = Skill.values()[this.random.nextInt(Skill.values().length)];
                Skill secondary = Skill.values()[this.random.nextInt(Skill.values().length)];
                this.citizenSkillHandler.incrementLevel(primary, (Integer)entry.getValue() / 2);
                this.citizenSkillHandler.incrementLevel(secondary, (Integer)entry.getValue() / 4);
            }
        }
        this.idle = nbtTagCompound.func_74767_n("idle");
    }

    @Override
    public void tick() {
        if (!this.getEntity().isPresent() || !this.getEntity().get().func_70089_S()) {
            return;
        }
        ArrayList<IInteractionResponseHandler> toRemove = new ArrayList<IInteractionResponseHandler>();
        for (IInteractionResponseHandler handler : this.citizenChatOptions.values()) {
            try {
                if (handler.isValid(this)) continue;
                toRemove.add(handler);
            }
            catch (Exception e) {
                Log.getLogger().warn("Error during validation of handler: " + handler.getInquiry(), (Throwable)e);
                toRemove.add(handler);
            }
        }
        if (!toRemove.isEmpty()) {
            this.markDirty();
        }
        for (IInteractionResponseHandler handler : toRemove) {
            this.citizenChatOptions.remove(handler.getInquiry());
            for (ITextComponent comp : handler.getPossibleResponses()) {
                if (!this.citizenChatOptions.containsKey(handler.getResponseResult(comp))) continue;
                this.citizenChatOptions.get(handler.getResponseResult(comp)).removeParent(handler.getInquiry());
            }
        }
    }

    @Override
    public void triggerInteraction(@NotNull IInteractionResponseHandler handler) {
        if (!this.citizenChatOptions.containsKey(handler.getInquiry())) {
            this.citizenChatOptions.put(handler.getInquiry(), handler);
            for (IInteractionResponseHandler childHandler : handler.genChildInteractions()) {
                this.citizenChatOptions.put(childHandler.getInquiry(), (ServerCitizenInteraction)childHandler);
            }
            this.markDirty();
        }
    }

    @Override
    public int getJobModifier() {
        return this.getCitizenSkillHandler().getJobModifier(this);
    }

    @Override
    public boolean isIdleAtJob() {
        return this.idle;
    }

    @Override
    public void setIdleAtJob(boolean idle) {
        this.idle = idle;
    }

    @Override
    public String getTextureSuffix() {
        return this.textureSuffix;
    }

    @Override
    public void setSuffix(String suffix) {
        this.textureSuffix = suffix;
    }

    @Override
    public <R extends IRequestable> IToken<?> createRequest(@NotNull R requested) {
        return this.getWorkBuilding().createRequest(this, requested, false);
    }

    @Override
    public <R extends IRequestable> IToken<?> createRequestAsync(@NotNull R requested) {
        return this.getWorkBuilding().createRequest(this, requested, true);
    }

    @Override
    public void onRequestCancelled(@NotNull IToken<?> token) {
        if (this.isRequestAsync(token)) {
            this.job.getAsyncRequests().remove(token);
        }
    }

    @Override
    public boolean isRequestAsync(@NotNull IToken<?> token) {
        if (this.job != null) {
            return this.job.getAsyncRequests().contains(token);
        }
        return false;
    }

    @Override
    public VisibleCitizenStatus getStatus() {
        return this.status;
    }

    @Override
    public void setVisibleStatus(VisibleCitizenStatus status) {
        if (this.status != status) {
            this.markDirty();
        }
        this.status = status;
    }

    public static CitizenData loadFromNBT(IColony colony, CompoundNBT nbt) {
        CitizenData data = new CitizenData(nbt.func_74762_e("id"), colony);
        data.deserializeNBT(nbt);
        return data;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public void applyResearchEffects() {
        if (this.getEntity().isPresent()) {
            AdditionModifierResearchEffect healthEffect;
            AbstractEntityCitizen citizen = this.getEntity().get();
            citizen.getNavigator().getPathingOptions().setCanUseRails(((EntityCitizen)citizen).canPathOnRails());
            MultiplierModifierResearchEffect speedEffect = this.colony.getResearchManager().getResearchEffects().getEffect("Walking", MultiplierModifierResearchEffect.class);
            if (speedEffect != null) {
                citizen.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3 + 0.3 * speedEffect.getEffect());
            }
            if ((healthEffect = this.colony.getResearchManager().getResearchEffects().getEffect("Health", AdditionModifierResearchEffect.class)) != null) {
                AttributeModifier healthModLevel = new AttributeModifier("Health", healthEffect.getEffect().doubleValue(), AttributeModifier.Operation.ADDITION);
                AttributeModifierUtils.addHealthModifier((LivingEntity)citizen, healthModLevel);
            }
        }
    }

    @Override
    public void onGoSleep() {
        if (this.random.nextInt(10) != 0) {
            return;
        }
        if (this.workBuilding != null && !this.workBuilding.isGuardBuildingNear()) {
            this.triggerInteraction(new SimpleNotificationInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.chat.noguardnearwork", new Object[0]), ChatPriority.CHITCHAT));
        }
        if (this.homeBuilding != null && !this.homeBuilding.isGuardBuildingNear()) {
            this.triggerInteraction(new SimpleNotificationInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.chat.noguardnearhome", new Object[0]), ChatPriority.CHITCHAT));
        }
    }
}

