/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.jobs.IJobView;
import com.minecolonies.api.colony.jobs.registry.IJobDataManager;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenHappinessHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSkillHandler;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.coremod.colony.interactionhandling.ServerCitizenInteraction;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenHappinessHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenSkillHandler;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenDataView
implements ICitizenDataView {
    private static final String TAG_HELD_ITEM_SLOT = "HeldItemSlot";
    private static final ResourceLocation BLOCKING_RESOURCE = new ResourceLocation("minecolonies", "textures/icons/blocking.png");
    private static final ResourceLocation PENDING_RESOURCE = new ResourceLocation("minecolonies", "textures/icons/warning.png");
    private final int id;
    protected int entityId;
    protected String name;
    protected boolean female;
    protected boolean paused;
    protected boolean isChild;
    private IJobView jobView;
    protected int colonyId;
    private double health;
    private double maxHealth;
    private double saturation;
    private double happiness;
    private BlockPos position;
    private String job;
    @Nullable
    private BlockPos homeBuilding;
    @Nullable
    private BlockPos workBuilding;
    private InventoryCitizen inventory;
    private final Map<ITextComponent, IInteractionResponseHandler> citizenChatOptions = new LinkedHashMap<ITextComponent, IInteractionResponseHandler>();
    private List<IInteractionResponseHandler> sortedInteractions;
    private final CitizenSkillHandler citizenSkillHandler;
    private final CitizenHappinessHandler citizenHappinessHandler;
    private VisibleCitizenStatus statusIcon;

    protected CitizenDataView(int id) {
        this.id = id;
        this.citizenSkillHandler = new CitizenSkillHandler();
        this.citizenHappinessHandler = new CitizenHappinessHandler();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFemale() {
        return this.female;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isChild() {
        return this.isChild;
    }

    @Override
    public void setPaused(boolean p) {
        this.paused = p;
    }

    @Override
    public String getJob() {
        return this.job;
    }

    @Override
    @Nullable
    public BlockPos getHomeBuilding() {
        return this.homeBuilding;
    }

    @Override
    @Nullable
    public BlockPos getWorkBuilding() {
        return this.workBuilding;
    }

    @Override
    public void setWorkBuilding(BlockPos bp) {
        this.workBuilding = bp;
    }

    @Override
    public int getColonyId() {
        return this.colonyId;
    }

    @Override
    public double getHappiness() {
        return this.happiness;
    }

    @Override
    public double getSaturation() {
        return this.saturation;
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    @Override
    public double getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public BlockPos getPosition() {
        return this.position;
    }

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        this.name = buf.func_150789_c(Short.MAX_VALUE);
        this.female = buf.readBoolean();
        this.entityId = buf.readInt();
        this.paused = buf.readBoolean();
        this.isChild = buf.readBoolean();
        this.homeBuilding = buf.readBoolean() ? buf.func_179259_c() : null;
        this.workBuilding = buf.readBoolean() ? buf.func_179259_c() : null;
        this.health = buf.readFloat();
        this.maxHealth = buf.readFloat();
        this.saturation = buf.readDouble();
        this.happiness = buf.readDouble();
        this.citizenSkillHandler.read(buf.func_150793_b());
        this.job = buf.func_150789_c(Short.MAX_VALUE);
        this.colonyId = buf.readInt();
        CompoundNBT compound = buf.func_150793_b();
        this.inventory = new InventoryCitizen(this.name, true);
        ListNBT ListNBT2 = compound.func_150295_c("inventory", 10);
        this.inventory.read(ListNBT2);
        this.inventory.setHeldItem(Hand.MAIN_HAND, compound.func_74762_e(TAG_HELD_ITEM_SLOT));
        this.inventory.setHeldItem(Hand.OFF_HAND, compound.func_74762_e("OffhandHeldItemSlot"));
        this.position = buf.func_179259_c();
        this.citizenChatOptions.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            CompoundNBT compoundNBT = buf.func_150793_b();
            ServerCitizenInteraction handler = (ServerCitizenInteraction)MinecoloniesAPIProxy.getInstance().getInteractionResponseHandlerDataManager().createFrom(this, compoundNBT);
            this.citizenChatOptions.put(handler.getInquiry(), handler);
        }
        this.sortedInteractions = this.citizenChatOptions.values().stream().sorted(Comparator.comparingInt(e -> e.getPriority().getPriority())).collect(Collectors.toList());
        this.citizenHappinessHandler.read(buf.func_150793_b());
        int statusindex = buf.readInt();
        VisibleCitizenStatus visibleCitizenStatus = this.statusIcon = statusindex >= 0 ? VisibleCitizenStatus.getForId(statusindex) : null;
        if (buf.readBoolean()) {
            IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.colonyId, Minecraft.func_71410_x().field_71441_e.func_201675_m().func_186058_p().func_186068_a());
            this.jobView = IJobDataManager.getInstance().createViewFrom(colonyView, this, buf);
        }
    }

    @Override
    public IJobView getJobView() {
        return this.jobView;
    }

    @Override
    public InventoryCitizen getInventory() {
        return this.inventory;
    }

    @Override
    public List<IInteractionResponseHandler> getOrderedInteractions() {
        return this.sortedInteractions;
    }

    @Override
    @Nullable
    public IInteractionResponseHandler getSpecificInteraction(@NotNull ITextComponent component) {
        return this.citizenChatOptions.getOrDefault(component, null);
    }

    @Override
    public boolean hasBlockingInteractions() {
        if (this.sortedInteractions.isEmpty()) {
            return false;
        }
        IInteractionResponseHandler interaction = this.sortedInteractions.get(0);
        if (interaction != null) {
            return interaction.getPriority().getPriority() >= ChatPriority.IMPORTANT.getPriority();
        }
        return false;
    }

    @Override
    public boolean hasPendingInteractions() {
        if (this.sortedInteractions.isEmpty()) {
            return false;
        }
        IInteractionResponseHandler interaction = this.sortedInteractions.get(0);
        if (interaction != null) {
            return interaction.isPrimary();
        }
        return false;
    }

    @Override
    public ICitizenSkillHandler getCitizenSkillHandler() {
        return this.citizenSkillHandler;
    }

    @Override
    public ICitizenHappinessHandler getHappinessHandler() {
        return this.citizenHappinessHandler;
    }

    @Override
    public ResourceLocation getInteractionIcon() {
        if (this.sortedInteractions == null || this.sortedInteractions.isEmpty()) {
            return null;
        }
        ResourceLocation icon = this.sortedInteractions.get(0).getInteractionIcon();
        if (icon == null) {
            icon = this.hasBlockingInteractions() ? BLOCKING_RESOURCE : PENDING_RESOURCE;
        }
        return icon;
    }

    @Override
    public VisibleCitizenStatus getVisibleStatus() {
        return this.statusIcon;
    }
}

