/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.google.common.collect.ImmutableList;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.ColonyState;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.managers.interfaces.IBuildingManager;
import com.minecolonies.api.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.api.colony.managers.interfaces.IColonyPackageManager;
import com.minecolonies.api.colony.managers.interfaces.IEventDescriptionManager;
import com.minecolonies.api.colony.managers.interfaces.IEventManager;
import com.minecolonies.api.colony.managers.interfaces.IProgressManager;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.colony.managers.interfaces.IVisitorManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.research.IResearchManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.managers.BuildingManager;
import com.minecolonies.coremod.colony.managers.CitizenManager;
import com.minecolonies.coremod.colony.managers.ColonyPackageManager;
import com.minecolonies.coremod.colony.managers.EventDescriptionManager;
import com.minecolonies.coremod.colony.managers.EventManager;
import com.minecolonies.coremod.colony.managers.ProgressManager;
import com.minecolonies.coremod.colony.managers.RaidManager;
import com.minecolonies.coremod.colony.managers.ResearchManager;
import com.minecolonies.coremod.colony.managers.VisitorManager;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.colony.pvp.AttackingPlayer;
import com.minecolonies.coremod.colony.requestsystem.management.manager.StandardRequestManager;
import com.minecolonies.coremod.colony.workorders.WorkManager;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewRemoveWorkOrderMessage;
import com.minecolonies.coremod.permissions.ColonyPermissionEventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.nbt.StringNBT;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Colony
implements IColony {
    private String style = "wooden";
    private final int id;
    private int dimensionId;
    private Set<Long> loadedChunks = new HashSet<Long>();
    private Set<Long> pendingChunks = new HashSet<Long>();
    private final Map<BlockPos, BlockState> wayPoints = new HashMap<BlockPos, BlockState>();
    private final WorkManager workManager = new WorkManager(this);
    private final IBuildingManager buildingManager = new BuildingManager(this);
    private final ICitizenManager citizenManager = new CitizenManager(this);
    private final IVisitorManager visitorManager = new VisitorManager(this);
    private final IRaiderManager raidManager = new RaidManager(this);
    private final IEventManager eventManager = new EventManager(this);
    private final IEventDescriptionManager eventDescManager = new EventDescriptionManager(this);
    private final IColonyPackageManager packageManager = new ColonyPackageManager(this);
    private final IProgressManager progressManager = new ProgressManager(this);
    private final Set<BlockPos> freePositions = new HashSet<BlockPos>();
    private final Set<Block> freeBlocks = new HashSet<Block>();
    private ColonyPermissionEventHandler eventHandler;
    private boolean canColonyBeAutoDeleted = true;
    private boolean isDay = true;
    @Nullable
    private World world = null;
    private boolean manualHiring = false;
    private boolean manualHousing = false;
    private boolean moveIn = true;
    private String name = "ERROR(Wasn't placed by player)";
    private BlockPos center;
    @NotNull
    private Permissions permissions;
    private IRequestManager requestManager;
    private IResearchManager researchManager = new ResearchManager();
    private CompoundNBT colonyTag;
    private final List<PlayerEntity> visitingPlayers = new ArrayList<PlayerEntity>();
    private final List<AttackingPlayer> attackingPlayers = new ArrayList<AttackingPlayer>();
    private final ITickRateStateMachine<ColonyState> colonyStateMachine;
    private boolean needToMourn = false;
    private boolean mourning = false;
    private boolean isActive = true;
    private TextFormatting colonyTeamColor = TextFormatting.WHITE;
    private ListNBT colonyFlag = new BannerPattern.Builder().func_222477_a(BannerPattern.BASE, DyeColor.WHITE).func_222476_a();
    private long mercenaryLastUse = 0L;
    private int additionalChildTime = 0;
    private boolean hasChilds = false;
    public long lastOnlineTime = 0L;
    private int forceLoadTimer = 0;

    Colony(int id, @Nullable World w, BlockPos c) {
        this(id, w);
        this.center = c;
        this.permissions = new Permissions(this);
        this.requestManager = new StandardRequestManager(this);
    }

    protected Colony(int id, @Nullable World world) {
        this.id = id;
        if (world != null) {
            this.dimensionId = world.func_201675_m().func_186058_p().func_186068_a();
            this.onWorldLoad(world);
            this.checkOrCreateTeam();
        }
        this.permissions = new Permissions(this);
        for (String s : (List)MineColonies.getConfig().getCommon().freeToInteractBlocks.get()) {
            try {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
                if (block == null || block instanceof AirBlock) continue;
                this.freeBlocks.add(block);
            }
            catch (Exception ex) {
                BlockPos pos = BlockPosUtil.getBlockPosOfString(s);
                if (pos == null) continue;
                this.freePositions.add(pos);
            }
        }
        this.colonyStateMachine = new TickRateStateMachine<ColonyState>(ColonyState.INACTIVE, e -> {});
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.INACTIVE, () -> true, this::updateState, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.UNLOADED, () -> true, this::updateState, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, () -> true, this::updateState, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, () -> true, () -> {
            this.getCitizenManager().tickCitizenData();
            return null;
        }, 20));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::updateSubscribers, () -> ColonyState.ACTIVE, 20));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::tickRequests, () -> ColonyState.ACTIVE, 11));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::checkDayTime, () -> ColonyState.ACTIVE, 20));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::updateWayPoints, () -> ColonyState.ACTIVE, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::worldTickSlow, () -> ColonyState.ACTIVE, 500));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.UNLOADED, this::worldTickUnloaded, () -> ColonyState.UNLOADED, 500));
    }

    private ColonyState updateState() {
        if (this.world == null) {
            return ColonyState.INACTIVE;
        }
        this.packageManager.updateAwayTime();
        if (!this.packageManager.getCloseSubscribers().isEmpty() || this.loadedChunks.size() > 40 && !this.packageManager.getImportantColonyPlayers().isEmpty()) {
            this.isActive = true;
            return ColonyState.ACTIVE;
        }
        if (!this.packageManager.getImportantColonyPlayers().isEmpty()) {
            this.isActive = true;
            return ColonyState.UNLOADED;
        }
        return ColonyState.INACTIVE;
    }

    private boolean updateSubscribers() {
        this.packageManager.updateSubscribers();
        return false;
    }

    private boolean tickRequests() {
        if (this.getRequestManager() != null) {
            this.getRequestManager().func_73660_a();
        }
        return false;
    }

    private boolean worldTickSlow() {
        long pastTime;
        this.buildingManager.cleanUpBuildings(this);
        this.citizenManager.onColonyTick(this);
        this.visitorManager.onColonyTick(this);
        this.updateAttackingPlayers();
        this.eventManager.onColonyTick(this);
        this.buildingManager.onColonyTick(this);
        this.workManager.onColonyTick(this);
        long currTime = System.currentTimeMillis();
        if (this.lastOnlineTime != 0L && (pastTime = currTime - this.lastOnlineTime) > 3600000L) {
            for (IBuilding building : this.buildingManager.getBuildings().values()) {
                building.processOfflineTime(pastTime / 1000L);
            }
        }
        this.lastOnlineTime = currTime;
        this.updateChildTime();
        this.updateChunkLoadTimer();
        return false;
    }

    private void updateChunkLoadTimer() {
        if (((Boolean)MineColonies.getConfig().getCommon().forceLoadColony.get()).booleanValue()) {
            for (ServerPlayerEntity sub : this.getPackageManager().getCloseSubscribers()) {
                if (!this.getPermissions().hasPermission((PlayerEntity)sub, Action.CAN_KEEP_COLONY_ACTIVE_WHILE_AWAY)) continue;
                this.forceLoadTimer = 12000;
                for (long pending : this.pendingChunks) {
                    int chunkX = ChunkPos.func_212578_a((long)pending);
                    int chunkZ = ChunkPos.func_212579_b((long)pending);
                    if (!(this.world instanceof ServerWorld)) continue;
                    ((ServerWorld)this.world).func_217458_b(chunkX, chunkZ, true);
                }
                return;
            }
            if (this.forceLoadTimer > 0) {
                this.forceLoadTimer -= 500;
                if (this.forceLoadTimer <= 0) {
                    Iterator<Object> iterator = this.loadedChunks.iterator();
                    while (iterator.hasNext()) {
                        long chunkPos = (Long)iterator.next();
                        int chunkX = ChunkPos.func_212578_a((long)chunkPos);
                        int chunkZ = ChunkPos.func_212579_b((long)chunkPos);
                        if (!(this.world instanceof ServerWorld)) continue;
                        ((ServerWorld)this.world).func_217458_b(chunkX, chunkZ, false);
                    }
                }
            }
        }
    }

    private boolean worldTickUnloaded() {
        this.updateChildTime();
        this.updateChunkLoadTimer();
        return false;
    }

    private void updateChildTime() {
        this.additionalChildTime = this.hasChilds ? (this.additionalChildTime += 500) : 0;
    }

    private boolean checkDayTime() {
        if (this.isDay && !WorldUtil.isDayTime(this.world)) {
            this.isDay = false;
            this.eventManager.onNightFall();
            this.raidManager.onNightFall();
            if (!this.packageManager.getCloseSubscribers().isEmpty()) {
                this.citizenManager.checkCitizensForHappiness();
            }
            this.citizenManager.updateCitizenSleep(false);
            if (this.mourning) {
                this.mourning = false;
                this.citizenManager.updateCitizenMourn(false);
            }
        } else if (!this.isDay && WorldUtil.isDayTime(this.world)) {
            this.isDay = true;
            if (this.needToMourn) {
                this.needToMourn = false;
                this.mourning = true;
                this.citizenManager.updateCitizenMourn(true);
            }
        }
        return false;
    }

    public void updateAttackingPlayers() {
        ArrayList<PlayerEntity> visitors = new ArrayList<PlayerEntity>(this.visitingPlayers);
        for (PlayerEntity playerEntity : visitors) {
            if (this.packageManager.getCloseSubscribers().contains(playerEntity)) continue;
            this.visitingPlayers.remove(playerEntity);
            this.attackingPlayers.remove(new AttackingPlayer(playerEntity));
        }
        for (AttackingPlayer attackingPlayer : this.attackingPlayers) {
            if (attackingPlayer.getGuards().isEmpty()) continue;
            attackingPlayer.refreshList(this);
            if (!attackingPlayer.getGuards().isEmpty()) continue;
            LanguageHandler.sendPlayersMessage(this.getImportantMessageEntityPlayers(), (String)("You successfully defended your colony against, " + attackingPlayer.getPlayer().func_200200_C_()), (Object[])new Object[0]);
        }
    }

    @Override
    public ScorePlayerTeam getTeam() {
        return this.checkOrCreateTeam();
    }

    private ScorePlayerTeam checkOrCreateTeam() {
        if (this.world.func_96441_U().func_96508_e(this.getTeamName()) == null) {
            this.world.func_96441_U().func_96527_f(this.getTeamName());
            this.world.func_96441_U().func_96508_e(this.getTeamName()).func_96660_a(false);
        }
        return this.world.func_96441_U().func_96508_e(this.getTeamName());
    }

    @Override
    public void setColonyColor(TextFormatting colonyColor) {
        if (this.world != null) {
            this.checkOrCreateTeam();
            this.colonyTeamColor = colonyColor;
            this.world.func_96441_U().func_96508_e(this.getTeamName()).func_178774_a(colonyColor);
            this.world.func_96441_U().func_96508_e(this.getTeamName()).func_207408_a((ITextComponent)new StringTextComponent(colonyColor.toString()));
            this.markDirty();
        }
    }

    @Override
    public void setColonyFlag(ListNBT colonyFlag) {
        this.colonyFlag = colonyFlag;
        this.markDirty();
    }

    @Nullable
    public static Colony loadColony(@NotNull CompoundNBT compound, @Nullable World world) {
        try {
            int id = compound.func_74762_e("id");
            Colony c = new Colony(id, world);
            c.name = compound.func_74779_i("name");
            c.center = BlockPosUtil.read(compound, "center");
            c.setRequestManager();
            c.read(compound);
            if (c.getProgressManager().isPrintingProgress() && (c.getBuildingManager().getBuildings().size() > 10 || c.getCitizenManager().getCitizens().size() > 20)) {
                c.getProgressManager().togglePrintProgress();
            }
            return c;
        }
        catch (Exception e) {
            Log.getLogger().warn("Something went wrong loading a colony, please report this to the administrators", (Throwable)e);
            return null;
        }
    }

    private void setRequestManager() {
        this.requestManager = new StandardRequestManager(this);
    }

    @Override
    public void read(@NotNull CompoundNBT compound) {
        this.manualHiring = compound.func_74767_n("manualHiring");
        this.dimensionId = compound.func_74762_e("dimension");
        if (compound.func_150296_c().contains("needToMourn")) {
            this.needToMourn = compound.func_74767_n("needToMourn");
            this.mourning = compound.func_74767_n("mourning");
        } else {
            this.needToMourn = false;
            this.mourning = false;
        }
        this.mercenaryLastUse = compound.func_74763_f("mercenaryUseTime");
        this.additionalChildTime = compound.func_74762_e("childTime");
        this.permissions.loadPermissions(compound);
        this.citizenManager.read(compound.func_74775_l("citizenManager"));
        this.visitorManager.read(compound);
        this.buildingManager.read(compound.func_74775_l("buildingManager"));
        this.citizenManager.calculateMaxCitizens();
        if (compound.func_150296_c().contains("progressManager")) {
            this.progressManager.read(compound);
        }
        this.eventManager.readFromNBT(compound);
        this.eventDescManager.deserializeNBT((INBT)compound.func_74775_l("event_desc_manager"));
        if (compound.func_150296_c().contains("research")) {
            this.researchManager.readFromNBT(compound.func_74775_l("research"));
        }
        this.workManager.read(compound.func_74775_l("work"));
        this.wayPoints.clear();
        ListNBT wayPointTagList = compound.func_150295_c("waypoints", 10);
        for (int i = 0; i < wayPointTagList.size(); ++i) {
            CompoundNBT blockAtPos = wayPointTagList.func_150305_b(i);
            BlockPos pos = BlockPosUtil.read(blockAtPos, "waypoints");
            BlockState state = NBTUtil.func_190008_d((CompoundNBT)blockAtPos);
            this.wayPoints.put(pos, state);
        }
        this.freeBlocks.clear();
        ListNBT freeBlockTagList = compound.func_150295_c("freeBlocks", 8);
        for (int i = 0; i < freeBlockTagList.size(); ++i) {
            this.freeBlocks.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(freeBlockTagList.func_150307_f(i))));
        }
        this.freePositions.clear();
        ListNBT freePositionTagList = compound.func_150295_c("freePositions", 10);
        for (int i = 0; i < freePositionTagList.size(); ++i) {
            CompoundNBT blockTag = freePositionTagList.func_150305_b(i);
            BlockPos block = BlockPosUtil.read(blockTag, "freePositions");
            this.freePositions.add(block);
        }
        this.packageManager.setLastContactInHours(compound.func_74762_e("abandoned"));
        this.manualHousing = compound.func_74767_n("manualHousing");
        if (compound.func_150296_c().contains("moveIn")) {
            this.moveIn = compound.func_74767_n("moveIn");
        }
        if (compound.func_150296_c().contains("style")) {
            this.style = compound.func_74779_i("style");
        }
        this.raidManager.read(compound);
        this.canColonyBeAutoDeleted = compound.func_150296_c().contains("autoDelete") ? compound.func_74767_n("autoDelete") : true;
        if (compound.func_150296_c().contains("teamcolor")) {
            this.setColonyColor(TextFormatting.values()[compound.func_74762_e("teamcolor")]);
        }
        if (compound.func_150296_c().contains("colonyflag")) {
            this.setColonyFlag(compound.func_150295_c("colonyflag", 10));
        }
        this.requestManager.reset();
        if (compound.func_150296_c().contains("requestManager")) {
            this.requestManager.deserializeNBT((INBT)compound.func_74775_l("requestManager"));
        }
        this.lastOnlineTime = compound.func_74763_f("lastOnlineTime");
        this.colonyTag = compound;
    }

    public ColonyPermissionEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public CompoundNBT write(@NotNull CompoundNBT compound) {
        compound.func_74768_a("id", this.id);
        compound.func_74768_a("dimension", this.dimensionId);
        compound.func_74778_a("name", this.name);
        BlockPosUtil.write(compound, "center", this.center);
        compound.func_74757_a("manualHiring", this.manualHiring);
        compound.func_74757_a("needToMourn", this.needToMourn);
        compound.func_74757_a("mourning", this.mourning);
        compound.func_74772_a("mercenaryUseTime", this.mercenaryLastUse);
        compound.func_74768_a("childTime", this.additionalChildTime);
        this.permissions.savePermissions(compound);
        CompoundNBT buildingCompound = new CompoundNBT();
        this.buildingManager.write(buildingCompound);
        compound.func_218657_a("buildingManager", (INBT)buildingCompound);
        CompoundNBT citizenCompound = new CompoundNBT();
        this.citizenManager.write(citizenCompound);
        compound.func_218657_a("citizenManager", (INBT)citizenCompound);
        this.visitorManager.write(compound);
        CompoundNBT workManagerCompound = new CompoundNBT();
        this.workManager.write(workManagerCompound);
        compound.func_218657_a("work", (INBT)workManagerCompound);
        this.progressManager.write(compound);
        this.eventManager.writeToNBT(compound);
        compound.func_218657_a("event_desc_manager", this.eventDescManager.serializeNBT());
        this.raidManager.write(compound);
        CompoundNBT researchManagerCompound = new CompoundNBT();
        this.researchManager.writeToNBT(researchManagerCompound);
        compound.func_218657_a("research", (INBT)researchManagerCompound);
        ListNBT wayPointTagList = new ListNBT();
        for (Map.Entry<BlockPos, BlockState> entry : this.wayPoints.entrySet()) {
            CompoundNBT wayPointCompound = new CompoundNBT();
            BlockPosUtil.write(wayPointCompound, "waypoints", entry.getKey());
            wayPointCompound.func_218657_a("block", (INBT)NBTUtil.func_190009_a((BlockState)entry.getValue()));
            wayPointTagList.add((Object)wayPointCompound);
        }
        compound.func_218657_a("waypoints", (INBT)wayPointTagList);
        ListNBT freeBlocksTagList = new ListNBT();
        for (Block block : this.freeBlocks) {
            freeBlocksTagList.add((Object)StringNBT.func_229705_a_((String)block.getRegistryName().toString()));
        }
        compound.func_218657_a("freeBlocks", (INBT)freeBlocksTagList);
        ListNBT listNBT = new ListNBT();
        for (BlockPos pos : this.freePositions) {
            CompoundNBT wayPointCompound = new CompoundNBT();
            BlockPosUtil.write(wayPointCompound, "freePositions", pos);
            listNBT.add((Object)wayPointCompound);
        }
        compound.func_218657_a("freePositions", (INBT)listNBT);
        compound.func_74768_a("abandoned", this.packageManager.getLastContactInHours());
        compound.func_74757_a("manualHousing", this.manualHousing);
        compound.func_74757_a("moveIn", this.moveIn);
        compound.func_218657_a("requestManager", this.getRequestManager().serializeNBT());
        compound.func_74778_a("style", this.style);
        compound.func_74757_a("autoDelete", this.canColonyBeAutoDeleted);
        compound.func_74768_a("teamcolor", this.colonyTeamColor.ordinal());
        compound.func_218657_a("colonyflag", (INBT)this.colonyFlag);
        compound.func_74772_a("lastOnlineTime", this.lastOnlineTime);
        this.colonyTag = compound;
        this.isActive = false;
        return compound;
    }

    @Override
    public int getDimension() {
        return this.dimensionId;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public IResearchManager getResearchManager() {
        return this.researchManager;
    }

    @Override
    public void onWorldLoad(@NotNull World w) {
        if (w.func_201675_m().func_186058_p().func_186068_a() == this.dimensionId) {
            this.world = w;
            if (this.eventHandler == null) {
                this.eventHandler = new ColonyPermissionEventHandler(this);
                MinecraftForge.EVENT_BUS.register((Object)this.eventHandler);
            }
        }
    }

    @Override
    public void onWorldUnload(@NotNull World w) {
        if (w != this.world) {
            return;
        }
        if (this.eventHandler != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.eventHandler);
        }
        this.world = null;
    }

    @Override
    public void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
    }

    @Override
    @NotNull
    public IWorkManager getWorkManager() {
        return this.workManager;
    }

    public Set<BlockPos> getFreePositions() {
        return new HashSet<BlockPos>(this.freePositions);
    }

    public Set<Block> getFreeBlocks() {
        return new HashSet<Block>(this.freeBlocks);
    }

    @Override
    public void addFreePosition(@NotNull BlockPos pos) {
        this.freePositions.add(pos);
        this.markDirty();
    }

    @Override
    public void addFreeBlock(@NotNull Block block) {
        this.freeBlocks.add(block);
        this.markDirty();
    }

    @Override
    public void removeFreePosition(@NotNull BlockPos pos) {
        this.freePositions.remove(pos);
        this.markDirty();
    }

    @Override
    public void removeFreeBlock(@NotNull Block block) {
        this.freeBlocks.remove(block);
        this.markDirty();
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (event.world != this.getWorld()) {
            return;
        }
        this.colonyStateMachine.tick();
    }

    public static boolean shallUpdate(World world, int averageTicks) {
        return world.func_82737_E() % (long)(world.field_73012_v.nextInt(averageTicks * 2) + 1) == 0L;
    }

    private boolean updateWayPoints() {
        if (!this.wayPoints.isEmpty() && this.world != null) {
            int randomPos = this.world.field_73012_v.nextInt(this.wayPoints.size());
            int count = 0;
            for (Map.Entry<BlockPos, BlockState> entry : this.wayPoints.entrySet()) {
                Block worldBlock;
                if (count++ != randomPos) continue;
                if (WorldUtil.isBlockLoaded((IWorld)this.world, entry.getKey()) && ((worldBlock = this.world.func_180495_p(entry.getKey()).func_177230_c()) != entry.getValue().func_177230_c() && entry.getValue().func_177230_c() != ModBlocks.blockWayPoint && worldBlock != ModBlocks.blockConstructionTape || this.world.func_175623_d(entry.getKey().func_177977_b()) && !entry.getValue().func_185904_a().func_76220_a())) {
                    this.wayPoints.remove(entry.getKey());
                    this.markDirty();
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public BlockPos getCenter() {
        return this.center;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String n) {
        this.name = n;
        this.markDirty();
    }

    @Override
    @NotNull
    public Permissions getPermissions() {
        return this.permissions;
    }

    @Override
    public boolean isCoordInColony(@NotNull World w, @NotNull BlockPos pos) {
        if (w.func_201675_m().func_186058_p().func_186068_a() != this.dimensionId) {
            return false;
        }
        Chunk chunk = w.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null);
        return cap != null && cap.getOwningColony() == this.getID();
    }

    @Override
    public long getDistanceSquared(@NotNull BlockPos pos) {
        return BlockPosUtil.getDistanceSquared2D(this.center, pos);
    }

    @Override
    public boolean hasTownHall() {
        return this.buildingManager.hasTownHall();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public boolean hasWarehouse() {
        return this.buildingManager.hasWarehouse();
    }

    @Override
    public int getLastContactInHours() {
        return this.packageManager.getLastContactInHours();
    }

    @Override
    @Nullable
    public World getWorld() {
        return this.world;
    }

    @Override
    @NotNull
    public IRequestManager getRequestManager() {
        return this.requestManager;
    }

    @Override
    public void markDirty() {
        this.packageManager.setDirty();
        this.isActive = true;
    }

    @Override
    public boolean canBeAutoDeleted() {
        return this.canColonyBeAutoDeleted;
    }

    @Override
    @Nullable
    public IRequester getRequesterBuildingForPosition(@NotNull BlockPos pos) {
        return this.buildingManager.getBuilding(pos);
    }

    @Override
    @NotNull
    public List<PlayerEntity> getMessagePlayerEntities() {
        ArrayList<PlayerEntity> players = new ArrayList<PlayerEntity>();
        for (ServerPlayerEntity player : this.packageManager.getCloseSubscribers()) {
            if (!this.permissions.hasPermission((PlayerEntity)player, Action.RECEIVE_MESSAGES)) continue;
            players.add((PlayerEntity)player);
        }
        return players;
    }

    @Override
    @NotNull
    public List<PlayerEntity> getImportantMessageEntityPlayers() {
        HashSet<PlayerEntity> playerList = new HashSet<PlayerEntity>(this.getMessagePlayerEntities());
        for (ServerPlayerEntity player : this.packageManager.getImportantColonyPlayers()) {
            if (!this.permissions.hasPermission((PlayerEntity)player, Action.RECEIVE_MESSAGES_FAR_AWAY)) continue;
            playerList.add((PlayerEntity)player);
        }
        return new ArrayList<PlayerEntity>(playerList);
    }

    @Override
    public boolean isManualHiring() {
        return this.manualHiring;
    }

    @Override
    public void setManualHiring(boolean manualHiring) {
        this.manualHiring = manualHiring;
        this.progressManager.progressEmploymentModeChange();
        this.markDirty();
    }

    @Override
    public boolean isManualHousing() {
        return this.manualHousing;
    }

    @Override
    public void setManualHousing(boolean manualHousing) {
        this.manualHousing = manualHousing;
        this.markDirty();
    }

    @Override
    public boolean canMoveIn() {
        return this.moveIn;
    }

    @Override
    public void setMoveIn(boolean newMoveIn) {
        this.moveIn = newMoveIn;
        this.markDirty();
    }

    public void removeWorkOrderInView(int orderId) {
        for (ServerPlayerEntity player : this.packageManager.getCloseSubscribers()) {
            Network.getNetwork().sendToPlayer(new ColonyViewRemoveWorkOrderMessage(this, orderId), player);
        }
    }

    @Override
    public void onBuildingUpgradeComplete(@Nullable IBuilding building, int level) {
        if (building != null) {
            building.onUpgradeComplete(level);
            this.citizenManager.calculateMaxCitizens();
            this.markDirty();
        }
    }

    @Override
    public void addWayPoint(BlockPos point, BlockState block) {
        this.wayPoints.put(point, block);
        this.markDirty();
    }

    @Override
    public double getOverallHappiness() {
        if (this.citizenManager.getCitizens().size() <= 0) {
            return 5.5;
        }
        double happinessSum = 0.0;
        for (ICitizenData citizen : this.citizenManager.getCitizens()) {
            happinessSum += citizen.getCitizenHappinessHandler().getHappiness();
        }
        return happinessSum / (double)this.citizenManager.getCitizens().size();
    }

    @Override
    public Map<BlockPos, BlockState> getWayPoints() {
        return new HashMap<BlockPos, BlockState>(this.wayPoints);
    }

    @Override
    public void setCanBeAutoDeleted(boolean canBeDeleted) {
        this.canColonyBeAutoDeleted = canBeDeleted;
        this.markDirty();
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
        this.markDirty();
    }

    @Override
    public IBuildingManager getBuildingManager() {
        return this.buildingManager;
    }

    @Override
    public ICitizenManager getCitizenManager() {
        return this.citizenManager;
    }

    @Override
    public IVisitorManager getVisitorManager() {
        return this.visitorManager;
    }

    @Override
    public IRaiderManager getRaiderManager() {
        return this.raidManager;
    }

    @Override
    public IEventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public IEventDescriptionManager getEventDescriptionManager() {
        return this.eventDescManager;
    }

    @Override
    public IColonyPackageManager getPackageManager() {
        return this.packageManager;
    }

    @Override
    public IProgressManager getProgressManager() {
        return this.progressManager;
    }

    public ImmutableList<PlayerEntity> getVisitingPlayers() {
        return ImmutableList.copyOf(this.visitingPlayers);
    }

    @Override
    public void addVisitingPlayer(PlayerEntity player) {
        Rank rank = this.getPermissions().getRank(player);
        if (rank != Rank.OWNER && rank != Rank.OFFICER && !this.visitingPlayers.contains(player) && ((Boolean)MineColonies.getConfig().getCommon().sendEnteringLeavingMessages.get()).booleanValue()) {
            this.visitingPlayers.add(player);
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.enteringcolony", (Object[])new Object[]{this.getPermissions().getOwnerName()});
            LanguageHandler.sendPlayersMessage(this.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.enteringcolonynotify", (Object[])new Object[]{player.func_200200_C_().func_150254_d(), this.getName()});
        }
        if (this.getPermissions().hasPermission(rank, Action.CAN_KEEP_COLONY_ACTIVE_WHILE_AWAY) && this.forceLoadTimer <= 0 && ((Boolean)MineColonies.getConfig().getCommon().forceLoadColony.get()).booleanValue()) {
            for (long chunkPos : this.loadedChunks) {
                int chunkX = ChunkPos.func_212578_a((long)chunkPos);
                int chunkZ = ChunkPos.func_212579_b((long)chunkPos);
                if (!(this.world instanceof ServerWorld)) continue;
                ((ServerWorld)this.world).func_217458_b(chunkX, chunkZ, true);
            }
            this.forceLoadTimer = 12000;
        }
    }

    @Override
    public void removeVisitingPlayer(PlayerEntity player) {
        if (!this.getMessagePlayerEntities().contains(player) && ((Boolean)MineColonies.getConfig().getCommon().sendEnteringLeavingMessages.get()).booleanValue()) {
            this.visitingPlayers.remove(player);
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.leavingcolony", (Object[])new Object[]{this.getPermissions().getOwnerName()});
            LanguageHandler.sendPlayersMessage(this.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.leavingcolonynotify", (Object[])new Object[]{player.func_200200_C_().func_150254_d(), this.getName()});
        }
    }

    @Override
    public CompoundNBT getColonyTag() {
        try {
            if (this.colonyTag == null || this.isActive) {
                this.write(new CompoundNBT());
            }
        }
        catch (Exception e) {
            Log.getLogger().warn("Something went wrong persisting colony: " + this.id, (Throwable)e);
        }
        return this.colonyTag;
    }

    @Override
    public boolean isNeedToMourn() {
        return this.needToMourn;
    }

    @Override
    public void setNeedToMourn(boolean needToMourn, String name) {
        this.needToMourn = needToMourn;
        if (needToMourn) {
            LanguageHandler.sendPlayersMessage(this.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.mourning", (Object[])new Object[]{name});
        }
    }

    @Override
    public boolean isMourning() {
        return this.mourning;
    }

    @Override
    public boolean isValidAttackingPlayer(PlayerEntity player) {
        if (this.packageManager.getLastContactInHours() > 1) {
            return false;
        }
        for (AttackingPlayer attackingPlayer : this.attackingPlayers) {
            if (!attackingPlayer.getPlayer().equals((Object)player)) continue;
            return attackingPlayer.isValidAttack(this);
        }
        return false;
    }

    @Override
    public boolean isValidAttackingGuard(AbstractEntityCitizen entity) {
        if (this.packageManager.getLastContactInHours() > 1) {
            return false;
        }
        return AttackingPlayer.isValidAttack(entity, this);
    }

    @Override
    public void addGuardToAttackers(AbstractEntityCitizen IEntityCitizen, PlayerEntity player) {
        if (player == null) {
            return;
        }
        for (AttackingPlayer attackingPlayer : this.attackingPlayers) {
            if (!attackingPlayer.getPlayer().equals((Object)player)) continue;
            if (attackingPlayer.addGuard(IEntityCitizen)) {
                LanguageHandler.sendPlayersMessage(this.getImportantMessageEntityPlayers(), (String)("Beware, " + attackingPlayer.getPlayer().func_200200_C_() + " has now: " + attackingPlayer.getGuards().size() + " guards!"), (Object[])new Object[0]);
            }
            return;
        }
        for (PlayerEntity visitingPlayer : this.visitingPlayers) {
            if (!visitingPlayer.equals((Object)player)) continue;
            AttackingPlayer attackingPlayer = new AttackingPlayer(visitingPlayer);
            attackingPlayer.addGuard(IEntityCitizen);
            this.attackingPlayers.add(attackingPlayer);
            LanguageHandler.sendPlayersMessage(this.getImportantMessageEntityPlayers(), (String)("Beware, " + visitingPlayer.func_200200_C_() + " is attacking you and he brought guards."), (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isColonyUnderAttack() {
        return !this.attackingPlayers.isEmpty();
    }

    public TextFormatting getTeamColonyColor() {
        return this.colonyTeamColor;
    }

    @Override
    public ListNBT getColonyFlag() {
        return this.colonyFlag;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public void usedMercenaries() {
        this.mercenaryLastUse = this.world.func_82737_E();
        this.markDirty();
    }

    @Override
    public long getMercenaryUseTime() {
        return this.mercenaryLastUse;
    }

    @Override
    public boolean useAdditionalChildTime(int amount) {
        if (this.additionalChildTime < amount) {
            return false;
        }
        this.additionalChildTime -= amount;
        return true;
    }

    @Override
    public void updateHasChilds() {
        for (ICitizenData data : this.getCitizenManager().getCitizens()) {
            if (!data.isChild()) continue;
            this.hasChilds = true;
            return;
        }
        this.hasChilds = false;
    }

    @Override
    public void addLoadedChunk(long chunkPos) {
        if (this.forceLoadTimer > 0 && this.world instanceof ServerWorld && ((Boolean)MineColonies.getConfig().getCommon().forceLoadColony.get()).booleanValue()) {
            this.pendingChunks.add(chunkPos);
        }
        this.loadedChunks.add(chunkPos);
    }

    @Override
    public void removeLoadedChunk(long chunkPos) {
        this.loadedChunks.remove(chunkPos);
    }

    @Override
    public int getLoadedChunkCount() {
        return this.loadedChunks.size();
    }

    @Override
    public ColonyState getState() {
        return (ColonyState)this.colonyStateMachine.getState();
    }

    @Override
    public boolean isActive() {
        return this.colonyStateMachine.getState() != ColonyState.INACTIVE;
    }

    @Override
    public boolean isDay() {
        return this.isDay;
    }
}

