/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.compatibility.CompatibilityManager;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.crafting.IRecipeManager;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.ColonyManagerConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyList;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.colony.requestsystem.management.manager.StandardRecipeManager;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewRemoveMessage;
import com.minecolonies.coremod.util.BackUpHelper;
import com.minecolonies.coremod.util.ChunkDataHelper;
import com.minecolonies.coremod.util.FurnaceRecipes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerMultiWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyManager
implements IColonyManager {
    @NotNull
    private final Map<Integer, ColonyList<IColonyView>> colonyViews = new HashMap<Integer, ColonyList<IColonyView>>();
    private final IRecipeManager recipeManager = new StandardRecipeManager();
    private final ICompatibilityManager compatibilityManager = new CompatibilityManager();
    private UUID serverUUID = null;
    private boolean schematicDownloaded = false;
    private boolean loaded = false;

    @Override
    public void createColony(@NotNull World w, BlockPos pos, @NotNull PlayerEntity player, @NotNull String style) {
        IColonyManagerCapability cap = (IColonyManagerCapability)w.getCapability(MineColonies.COLONY_MANAGER_CAP, null).orElseGet(null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return;
        }
        IColony colony = cap.createColony(w, pos);
        colony.setStyle(style);
        String colonyName = LanguageHandler.format((String)"com.minecolonies.coremod.gui.townHall.defaultName", (Object[])new Object[]{player.func_200200_C_().func_150254_d()});
        colony.setName(colonyName);
        colony.getPermissions().setOwner(player);
        colony.getPackageManager().addImportantColonyPlayer((ServerPlayerEntity)player);
        colony.getPackageManager().addCloseSubscriber((ServerPlayerEntity)player);
        Log.getLogger().info(String.format("New Colony Id: %d by %s", colony.getID(), player.func_200200_C_().func_150254_d()));
        if (colony.getWorld() == null) {
            Log.getLogger().error("Unable to claim chunks because of the missing world in the colony, please report this to the mod authors!", (Throwable)new Exception());
            return;
        }
        ChunkDataHelper.claimColonyChunks(colony.getWorld(), true, colony.getID(), colony.getCenter(), colony.getDimension());
    }

    @Override
    public void deleteColonyByWorld(int id, boolean canDestroy, World world) {
        this.deleteColony(this.getColonyByWorld(id, world), canDestroy);
    }

    @Override
    public void deleteColonyByDimension(int id, boolean canDestroy, int dimension) {
        this.deleteColony(this.getColonyByDimension(id, dimension), canDestroy);
    }

    private void deleteColony(@Nullable IColony iColony, boolean canDestroy) {
        if (!(iColony instanceof Colony)) {
            return;
        }
        Colony colony = (Colony)iColony;
        int id = colony.getID();
        World world = colony.getWorld();
        try {
            ChunkDataHelper.claimColonyChunks(world, false, id, colony.getCenter(), colony.getDimension());
            Log.getLogger().info("Removing citizens for " + id);
            for (ICitizenData citizenData : new ArrayList<ICitizenData>(colony.getCitizenManager().getCitizens())) {
                Log.getLogger().info("Kill Citizen " + citizenData.getName());
                citizenData.getEntity().ifPresent(entityCitizen -> entityCitizen.func_70645_a(ColonyManagerConstants.CONSOLE_DAMAGE_SOURCE));
            }
            Log.getLogger().info("Removing buildings for " + id);
            for (IBuilding building : new ArrayList<IBuilding>(colony.getBuildingManager().getBuildings().values())) {
                BlockPos location = building.getPosition();
                Log.getLogger().info("Delete Building at " + location);
                if (canDestroy) {
                    building.deconstruct();
                }
                building.destroy();
                if (!(world.func_180495_p(location).func_177230_c() instanceof AbstractBlockHut)) continue;
                Log.getLogger().info("Found Block, deleting " + world.func_180495_p(location).func_177230_c());
                world.func_217377_a(location, false);
            }
            try {
                MinecraftForge.EVENT_BUS.unregister((Object)colony.getEventHandler());
            }
            catch (NullPointerException e) {
                Log.getLogger().warn("Can't unregister the event handler twice");
            }
            Log.getLogger().info("Deleting colony: " + colony.getID());
            IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).orElseGet(null);
            if (cap == null) {
                Log.getLogger().warn("Missing world capability with colony manager!");
                return;
            }
            cap.deleteColony(id);
            BackUpHelper.markColonyDeleted(colony.getID(), colony.getDimension());
            colony.getImportantMessageEntityPlayers().forEach(player -> Network.getNetwork().sendToPlayer(new ColonyViewRemoveMessage(colony.getID(), colony.getDimension()), (ServerPlayerEntity)player));
            Log.getLogger().info("Successfully deleted colony: " + id);
        }
        catch (RuntimeException e) {
            Log.getLogger().warn("Deleting Colony " + id + " errored:", (Throwable)e);
        }
    }

    @Override
    public void removeColonyView(int id, int dimension) {
        if (this.colonyViews.containsKey(dimension)) {
            this.colonyViews.get(dimension).remove(id);
        }
    }

    @Override
    @Nullable
    public IColony getColonyByWorld(int id, World world) {
        IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).orElseGet(null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return null;
        }
        return cap.getColony(id);
    }

    @Override
    @Nullable
    public IColony getColonyByDimension(int id, int dimension) {
        ServerWorld world = ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.func_186069_a((int)dimension));
        IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).orElseGet(null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return null;
        }
        return cap.getColony(id);
    }

    @Override
    public IBuilding getBuilding(@NotNull World w, @NotNull BlockPos pos) {
        IBuilding building;
        IColony colony = this.getColonyByPosFromWorld(w, pos);
        if (colony != null && (building = colony.getBuildingManager().getBuilding(pos)) != null) {
            return building;
        }
        for (IColony otherColony : this.getColonies(w)) {
            IBuilding building2 = otherColony.getBuildingManager().getBuilding(pos);
            if (building2 == null) continue;
            return building2;
        }
        return null;
    }

    @Override
    public IColony getColonyByPosFromWorld(@NotNull World w, @NotNull BlockPos pos) {
        Chunk centralChunk = w.func_175726_f(pos);
        int id = ((IColonyTagCapability)centralChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null)).getOwningColony();
        if (id == 0) {
            return null;
        }
        return this.getColonyByWorld(id, w);
    }

    @Override
    public IColony getColonyByPosFromDim(int dim, @NotNull BlockPos pos) {
        ServerWorld w = ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.func_186069_a((int)dim));
        return this.getColonyByPosFromWorld((World)w, pos);
    }

    @Override
    public boolean isTooCloseToColony(@NotNull World w, @NotNull BlockPos pos) {
        return !ChunkDataHelper.canClaimChunksInRange(w, pos, Math.max((Integer)MineColonies.getConfig().getCommon().minColonyDistance.get(), (Integer)MineColonies.getConfig().getCommon().initialColonySize.get()));
    }

    @Override
    @NotNull
    public List<IColony> getColonies(@NotNull World w) {
        IColonyManagerCapability cap = (IColonyManagerCapability)w.getCapability(MineColonies.COLONY_MANAGER_CAP, null).orElseGet(null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return Collections.emptyList();
        }
        return cap.getColonies();
    }

    @Override
    @NotNull
    public List<IColony> getAllColonies() {
        ArrayList<IColony> allColonies = new ArrayList<IColony>();
        for (World world : ServerLifecycleHooks.getCurrentServer().func_212370_w()) {
            IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).orElseGet(null);
            if (cap == null) continue;
            allColonies.addAll(cap.getColonies());
        }
        return allColonies;
    }

    @Override
    @NotNull
    public List<IColony> getColoniesAbandonedSince(int abandonedSince) {
        ArrayList<IColony> sortedList = new ArrayList<IColony>();
        for (IColony colony : this.getAllColonies()) {
            if (colony.getLastContactInHours() < abandonedSince) continue;
            sortedList.add(colony);
        }
        return sortedList;
    }

    @Override
    public IBuildingView getBuildingView(int dimension, BlockPos pos) {
        if (this.colonyViews.containsKey(dimension)) {
            for (IColonyView colony : this.colonyViews.get(dimension)) {
                IBuildingView building = colony.getBuilding(pos);
                if (building == null) continue;
                return building;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IColony getIColony(@NotNull World w, @NotNull BlockPos pos) {
        return w.field_72995_K ? this.getColonyView(w, pos) : this.getColonyByPosFromWorld(w, pos);
    }

    private IColonyView getColonyView(@NotNull World w, @NotNull BlockPos pos) {
        Chunk centralChunk = w.func_175726_f(pos);
        int id = ((IColonyTagCapability)centralChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null)).getOwningColony();
        if (id == 0) {
            return null;
        }
        return this.getColonyView(id, w.func_201675_m().func_186058_p().func_186068_a());
    }

    @Override
    @Nullable
    public IColony getClosestIColony(@NotNull World w, @NotNull BlockPos pos) {
        return w.field_72995_K ? this.getClosestColonyView(w, pos) : this.getClosestColony(w, pos);
    }

    @Override
    @Nullable
    public IColonyView getClosestColonyView(@Nullable World w, @Nullable BlockPos pos) {
        if (w == null || pos == null) {
            return null;
        }
        Chunk chunk = w.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null);
        if (cap.getOwningColony() != 0) {
            return this.getColonyView(cap.getOwningColony(), w.func_201675_m().func_186058_p().func_186068_a());
        }
        if (!cap.getAllCloseColonies().isEmpty()) {
            IColonyView closestColony = null;
            long closestDist = Long.MAX_VALUE;
            for (int cId : cap.getAllCloseColonies()) {
                long dist;
                IColonyView c = this.getColonyView(cId, w.func_201675_m().func_186058_p().func_186068_a());
                if (c == null || c.getDimension() != w.func_201675_m().func_186058_p().func_186068_a() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
                closestColony = c;
                closestDist = dist;
            }
            return closestColony;
        }
        IColonyView closestColony = null;
        long closestDist = Long.MAX_VALUE;
        if (this.colonyViews.containsKey(w.func_201675_m().func_186058_p().func_186068_a())) {
            for (IColonyView c : this.colonyViews.get(w.func_201675_m().func_186058_p().func_186068_a())) {
                long dist;
                if (c.getDimension() != w.func_201675_m().func_186058_p().func_186068_a() || c.getCenter() == null || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
                closestColony = c;
                closestDist = dist;
            }
        }
        return closestColony;
    }

    @Override
    public IColony getClosestColony(@NotNull World w, @NotNull BlockPos pos) {
        Chunk chunk = w.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null);
        if (cap.getOwningColony() != 0) {
            return this.getColonyByWorld(cap.getOwningColony(), w);
        }
        if (!cap.getAllCloseColonies().isEmpty()) {
            IColony closestColony = null;
            long closestDist = Long.MAX_VALUE;
            for (int cId : cap.getAllCloseColonies()) {
                long dist;
                IColony c = this.getColonyByWorld(cId, w);
                if (c == null || c.getDimension() != w.func_201675_m().func_186058_p().func_186068_a() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
                closestColony = c;
                closestDist = dist;
            }
            return closestColony;
        }
        IColony closestColony = null;
        long closestDist = Long.MAX_VALUE;
        for (IColony c : this.getColonies(w)) {
            long dist;
            if (c.getDimension() != w.func_201675_m().func_186058_p().func_186068_a() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
            closestColony = c;
            closestDist = dist;
        }
        return closestColony;
    }

    @Override
    @Nullable
    public IColony getIColonyByOwner(@NotNull World w, @NotNull PlayerEntity owner) {
        return this.getIColonyByOwner(w, w.field_72995_K ? owner.func_110124_au() : owner.func_146103_bH().getId());
    }

    @Override
    @Nullable
    public IColony getIColonyByOwner(@NotNull World w, UUID owner) {
        return w.field_72995_K ? this.getColonyViewByOwner(owner, w.func_201675_m().func_186058_p().func_186068_a()) : this.getColonyByOwner(owner);
    }

    private IColony getColonyViewByOwner(UUID owner, int dimension) {
        if (this.colonyViews.containsKey(dimension)) {
            for (IColonyView c : this.colonyViews.get(dimension)) {
                Player p = c.getPlayers().get(owner);
                if (p == null || !p.getRank().equals((Object)Rank.OWNER)) continue;
                return c;
            }
        }
        return null;
    }

    @Nullable
    private IColony getColonyByOwner(@Nullable UUID owner) {
        if (owner == null) {
            return null;
        }
        return this.getAllColonies().stream().filter(c -> owner.equals(c.getPermissions().getOwner())).findFirst().orElse(null);
    }

    @Override
    public int getMinimumDistanceBetweenTownHalls() {
        return (Integer)MineColonies.getConfig().getCommon().minColonyDistance.get() * 16;
    }

    @Override
    public void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (IColony c : this.getAllColonies()) {
                c.onServerTick(event);
            }
        }
    }

    @Override
    public void write(@NotNull CompoundNBT compound) {
        if (this.serverUUID != null) {
            compound.func_186854_a("uuid", this.serverUUID);
        }
        CompoundNBT compCompound = new CompoundNBT();
        this.compatibilityManager.write(compCompound);
        compound.func_218657_a("compatabilityManager", (INBT)compCompound);
        compound.func_74757_a("dist", true);
        CompoundNBT recipeCompound = new CompoundNBT();
        this.recipeManager.write(recipeCompound);
        compound.func_218657_a("recipeManager", (INBT)recipeCompound);
    }

    @Override
    public void read(@NotNull CompoundNBT compound) {
        if (compound.func_186855_b("uuid")) {
            this.serverUUID = compound.func_186857_a("uuid");
        }
        if (compound.func_150296_c().contains("compatabilityManager")) {
            this.compatibilityManager.read(compound.func_74775_l("compatabilityManager"));
        }
        this.recipeManager.read(compound.func_74775_l("recipeManager"));
    }

    @Override
    public void onClientTick(@NotNull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e == null && !this.colonyViews.isEmpty()) {
            this.colonyViews.clear();
        }
        if (!this.compatibilityManager.isDiscoveredAlready() && ItemStackUtils.ISFOOD != null && FurnaceRecipes.getInstance().loaded()) {
            this.compatibilityManager.discover(false);
        }
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.getColonies(event.world).forEach(c -> c.onWorldTick(event));
        }
        if (!this.compatibilityManager.isDiscoveredAlready() && FurnaceRecipes.getInstance().loaded()) {
            this.compatibilityManager.discover(true);
        }
    }

    @Override
    public void onWorldLoad(@NotNull World world) {
        if (!world.field_72995_K) {
            if (!this.loaded) {
                File file = BackUpHelper.getSaveLocation((ServerWorld)world);
                CompoundNBT data = BackUpHelper.loadNBTFromPath(file);
                if (data != null) {
                    this.read(data);
                }
                if (this.serverUUID == null) {
                    this.serverUUID = UUID.randomUUID();
                    Log.getLogger().info(String.format("New Server UUID %s", this.serverUUID));
                } else {
                    Log.getLogger().info(String.format("Server UUID %s", this.serverUUID));
                }
                this.loaded = true;
                BackUpHelper.loadMissingColonies();
            }
            for (IColony c : this.getColonies(world)) {
                c.onWorldLoad(world);
            }
        }
    }

    @Override
    public UUID getServerUUID() {
        return this.serverUUID;
    }

    @Override
    public void setServerUUID(UUID uuid) {
        this.serverUUID = uuid;
    }

    @Override
    public void onWorldUnload(@NotNull World world) {
        if (!world.field_72995_K && !(world instanceof ServerMultiWorld)) {
            for (IColony c : this.getColonies(world)) {
                c.onWorldUnload(world);
            }
            if (this.loaded) {
                BackUpHelper.backupColonyData();
                this.loaded = false;
            }
        }
    }

    @Override
    public void handleColonyViewMessage(int colonyId, @NotNull PacketBuffer colonyData, @NotNull World world, boolean isNewSubscription, int dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view == null) {
            view = ColonyView.createFromNetwork(colonyId);
            if (this.colonyViews.containsKey(dim)) {
                this.colonyViews.get(dim).add(view);
            } else {
                ColonyList<IColonyView> list = new ColonyList<IColonyView>();
                list.add(view);
                this.colonyViews.put(dim, list);
            }
        }
        view.handleColonyViewMessage(colonyData, world, isNewSubscription);
    }

    @Override
    public IColonyView getColonyView(int id, int dimension) {
        if (this.colonyViews.containsKey(dimension)) {
            return this.colonyViews.get(dimension).get(id);
        }
        return null;
    }

    @Override
    public void handlePermissionsViewMessage(int colonyID, @NotNull PacketBuffer data, int dim) {
        IColonyView view = this.getColonyView(colonyID, dim);
        if (view == null) {
            Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyID), (Throwable)new Exception());
        } else {
            view.handlePermissionsViewMessage(data);
        }
    }

    @Override
    public void handleColonyViewCitizensMessage(int colonyId, int citizenId, PacketBuffer buf, int dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view == null) {
            return;
        }
        view.handleColonyViewCitizensMessage(citizenId, buf);
    }

    @Override
    public void handleColonyViewWorkOrderMessage(int colonyId, PacketBuffer buf, int dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view == null) {
            return;
        }
        view.handleColonyViewWorkOrderMessage(buf);
    }

    @Override
    public void handleColonyViewRemoveCitizenMessage(int colonyId, int citizenId, int dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyViewRemoveCitizenMessage(citizenId);
        }
    }

    @Override
    public void handleColonyBuildingViewMessage(int colonyId, BlockPos buildingId, @NotNull PacketBuffer buf, int dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyBuildingViewMessage(buildingId, buf);
        } else {
            Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyId), (Throwable)new Exception());
        }
    }

    @Override
    public void handleColonyViewRemoveBuildingMessage(int colonyId, BlockPos buildingId, int dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyViewRemoveBuildingMessage(buildingId);
        }
    }

    @Override
    public void handleColonyViewRemoveWorkOrderMessage(int colonyId, int workOrderId, int dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyViewRemoveWorkOrderMessage(workOrderId);
        }
    }

    @Override
    public boolean isSchematicDownloaded() {
        return this.schematicDownloaded;
    }

    @Override
    public void setSchematicDownloaded(boolean downloaded) {
        this.schematicDownloaded = downloaded;
    }

    @Override
    public boolean isCoordinateInAnyColony(@NotNull World world, BlockPos pos) {
        Chunk centralChunk = world.func_175726_f(pos);
        return ((IColonyTagCapability)centralChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null)).getOwningColony() != 0;
    }

    @Override
    public ICompatibilityManager getCompatibilityManager() {
        return this.compatibilityManager;
    }

    @Override
    public IRecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    @Override
    public int getTopColonyId() {
        int top = 0;
        for (World world : ServerLifecycleHooks.getCurrentServer().func_212370_w()) {
            int tempTop;
            IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).orElseGet(null);
            if (cap == null || (tempTop = cap.getTopID()) <= top) continue;
            top = tempTop;
        }
        return top;
    }

    @Override
    public void resetColonyViews() {
        this.colonyViews.clear();
    }
}

