/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.ldtteam.structurize.util.LanguageHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemBuildingDataStore;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Pickup;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.FireworkUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingContainer;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.colony.interactionhandling.RequestBasedInteraction;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.requesters.BuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.resolvers.BuildingRequestResolver;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildRemoval;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.entity.ai.citizen.deliveryman.EntityAIWorkDeliveryman;
import com.minecolonies.coremod.research.MultiplierModifierResearchEffect;
import com.minecolonies.coremod.util.ChunkDataHelper;
import com.minecolonies.coremod.util.ColonyUtils;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuilding
extends AbstractBuildingContainer
implements IBuilding {
    public static final int MAX_BUILD_HEIGHT = 256;
    public static final int MIN_BUILD_HEIGHT = 1;
    private IToken<?> rsDataStoreToken;
    private IRequester requester;
    private boolean isBuilt = false;
    private String customName = "";
    private static final int STOCK_PER_LEVEL = 5;
    protected final Map<ItemStorage, Integer> minimumStock = new HashMap<ItemStorage, Integer>();
    private static final String TAG_MINIMUM_STOCK = "minstock";
    private boolean guardBuildingNear = false;
    private boolean recheckGuardBuildingNear = false;

    protected AbstractBuilding(@NotNull IColony colony, BlockPos pos) {
        super(pos, colony);
        this.requester = (IRequester)StandardFactoryController.getInstance().getNewInstance(TypeToken.of(BuildingBasedRequester.class), this, new Object[0]);
        this.setupRsDataStore();
    }

    @Override
    @NotNull
    public String getCustomBuildingName() {
        return this.customName;
    }

    @Override
    public void onWakeUp() {
    }

    @Override
    public void onCleanUp(ICitizenData citizen) {
    }

    @Override
    public void onRestart(ICitizenData citizen) {
        citizen.setPaused(false);
    }

    @Override
    public void onBuildingMove(IBuilding oldBuilding) {
    }

    @Override
    public void onPlayerEnterNearby(PlayerEntity player) {
        if (this.getBuildingLevel() == 0 || this.getSchematicName() == null || this.getSchematicName().isEmpty()) {
            return;
        }
        if (this.getTargetableArea(this.colony.getWorld()).func_72318_a(player.func_213303_ch())) {
            this.onPlayerEnterBuilding(player);
        }
    }

    @Override
    public void onPlacement() {
        ChunkDataHelper.claimColonyChunks(this.colony, true, this.getPosition(), this.getClaimRadius(this.getBuildingLevel()));
    }

    @Override
    public boolean isMatchingBlock(@NotNull Block block) {
        return this.getBuildingRegistryEntry().getBuildingBlock() == block;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.loadRequestSystemFromNBT(compound);
        if (compound.func_150296_c().contains("isBuilt")) {
            this.isBuilt = compound.func_74767_n("isBuilt");
        } else if (this.getBuildingLevel() > 0) {
            this.isBuilt = true;
        }
        if (compound.func_150296_c().contains("customName")) {
            this.customName = compound.func_74779_i("customName");
        }
        if (compound.func_74764_b("guardnearby")) {
            this.guardBuildingNear = compound.func_74767_n("guardnearby");
        } else {
            this.recheckGuardBuildingNear = true;
        }
        this.minimumStock.clear();
        ListNBT minimumStockTagList = compound.func_150295_c(TAG_MINIMUM_STOCK, 10);
        for (int i = 0; i < minimumStockTagList.size(); ++i) {
            CompoundNBT compoundNBT = minimumStockTagList.func_150305_b(i);
            this.minimumStock.put(new ItemStorage(ItemStack.func_199557_a((CompoundNBT)compoundNBT)), compoundNBT.func_74762_e("quantity"));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT list = new ListNBT();
        for (IRequestResolver requestResolver : this.getResolvers()) {
            list.add((Object)StandardFactoryController.getInstance().serialize(requestResolver.getId()));
        }
        compound.func_218657_a("Resolver", (INBT)list);
        compound.func_74778_a("type", this.getBuildingRegistryEntry().getRegistryName().toString());
        this.writeRequestSystemToNBT(compound);
        compound.func_74757_a("isBuilt", this.isBuilt);
        compound.func_74778_a("customName", this.customName);
        compound.func_74757_a("guardnearby", this.guardBuildingNear);
        ListNBT minimumStockTagList = new ListNBT();
        for (Map.Entry<ItemStorage, Integer> entry : this.minimumStock.entrySet()) {
            CompoundNBT compoundNBT = new CompoundNBT();
            entry.getKey().getItemStack().func_77955_b(compoundNBT);
            compoundNBT.func_74768_a("quantity", entry.getValue().intValue());
            minimumStockTagList.add((Object)compoundNBT);
        }
        compound.func_218657_a(TAG_MINIMUM_STOCK, (INBT)minimumStockTagList);
        return compound;
    }

    @Override
    public final void destroy() {
        this.onDestroyed();
        this.colony.getBuildingManager().removeBuilding(this, this.colony.getPackageManager().getCloseSubscribers());
    }

    @Override
    public void onDestroyed() {
        super.onDestroyed();
        AbstractTileEntityColonyBuilding tileEntityNew = this.getTileEntity();
        World world = this.colony.getWorld();
        Block block = world.func_180495_p(this.getPosition()).func_177230_c();
        if (tileEntityNew != null) {
            InventoryUtils.dropItemHandler((IItemHandler)tileEntityNew.getInventory(), world, tileEntityNew.getPosition().func_177958_n(), tileEntityNew.getPosition().func_177956_o(), tileEntityNew.getPosition().func_177952_p());
            world.func_175666_e(this.getPosition(), block);
        }
        ChunkDataHelper.claimColonyChunks(this.colony, false, this.getID(), this.getClaimRadius(this.getBuildingLevel()));
        ConstructionTapeHelper.removeConstructionTape(this.getCorners(), world);
    }

    protected void requestWorkOrder(int level, BlockPos builder, boolean removal) {
        WorkOrderBuild workOrder;
        for (WorkOrderBuildBuilding o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuildBuilding.class)) {
            if (!o.getBuildingLocation().equals((Object)this.getID())) continue;
            return;
        }
        if (removal) {
            if (!this.canDeconstruct()) {
                LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"entity.builder.cantdeconstruct", (Object[])new Object[0]);
                return;
            }
            workOrder = new WorkOrderBuildRemoval(this, level);
        } else {
            workOrder = new WorkOrderBuildBuilding(this, level);
        }
        if (!(removal || this.canBeBuiltByBuilder(level) || workOrder.canBeResolved(this.colony, level))) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"entity.builder.messagebuildernecessary", (Object[])new Object[]{Integer.toString(level)});
            return;
        }
        if (workOrder.tooFarFromAnyBuilder(this.colony, level) && builder.equals((Object)BlockPos.field_177992_a)) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"entity.builder.messagebuilderstoofar", (Object[])new Object[0]);
            return;
        }
        if (this.getPosition().func_177956_o() + this.getHeight() >= 256) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"entity.builder.messagebuildtoohigh", (Object[])new Object[0]);
            return;
        }
        if (this.getPosition().func_177956_o() <= 1) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"entity.builder.messagebuildtoolow", (Object[])new Object[0]);
            return;
        }
        if (!builder.equals((Object)BlockPos.field_177992_a)) {
            IBuilding building = this.colony.getBuildingManager().getBuilding(builder);
            if (building instanceof AbstractBuildingStructureBuilder && (building.getBuildingLevel() >= level || this.canBeBuiltByBuilder(level))) {
                workOrder.setClaimedBy(builder);
            } else {
                LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"entity.builder.messagebuildernecessary", (Object[])new Object[]{Integer.toString(level)});
                return;
            }
        }
        this.colony.getWorkManager().addWorkOrder(workOrder, false);
        this.colony.getProgressManager().progressWorkOrderPlacement(workOrder);
        if (workOrder.getID() != 0) {
            LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.workorderadded", (Object[])new Object[0]);
        }
        this.markDirty();
    }

    public boolean canDeconstruct() {
        return true;
    }

    @Override
    public boolean canBeBuiltByBuilder(int newLevel) {
        return false;
    }

    @Override
    public final void markDirty() {
        super.markDirty();
        if (this.colony != null) {
            this.colony.getBuildingManager().markBuildingsDirty();
        }
    }

    @Override
    public void processOfflineTime(long time) {
    }

    @Override
    public boolean hasWorkOrder() {
        return this.getCurrentWorkOrderLevel() != -1;
    }

    private int getCurrentWorkOrderLevel() {
        for (WorkOrderBuildBuilding workOrderBuildBuilding : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuildBuilding.class)) {
            if (!workOrderBuildBuilding.getBuildingLocation().equals((Object)this.getID())) continue;
            return workOrderBuildBuilding.getUpgradeLevel();
        }
        for (WorkOrderBuildRemoval workOrderBuildRemoval : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuildRemoval.class)) {
            if (!workOrderBuildRemoval.getBuildingLocation().equals((Object)this.getID())) continue;
            return 0;
        }
        return -1;
    }

    @Override
    public void removeWorkOrder() {
        for (WorkOrderBuild o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuild.class)) {
            if (!o.getBuildingLocation().equals((Object)this.getID()) || !(o instanceof WorkOrderBuildBuilding) && !(o instanceof WorkOrderBuildRemoval)) continue;
            this.colony.getWorkManager().removeWorkOrder(o.getID());
            this.markDirty();
            BlockPos buildingPos = o.getClaimedBy();
            IBuilding building = this.colony.getBuildingManager().getBuilding(buildingPos);
            if (building != null && building.getMainCitizen() != null) {
                building.cancelAllRequestsOfCitizen(building.getMainCitizen());
            }
            return;
        }
    }

    @Override
    public int getClaimRadius(int newLevel) {
        switch (newLevel) {
            case 1: 
            case 2: 
            case 3: {
                return 1;
            }
            case 4: 
            case 5: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        buf.func_180714_a(this.getBuildingRegistryEntry().getRegistryName().toString());
        buf.writeInt(this.getBuildingLevel());
        buf.writeInt(this.getMaxBuildingLevel());
        buf.writeInt(this.getPickUpPriority());
        buf.writeInt(this.getCurrentWorkOrderLevel());
        buf.func_180714_a(this.getStyle());
        buf.func_180714_a(this.getSchematicName());
        buf.func_180714_a(this.getCustomBuildingName());
        buf.writeInt(this.getRotation());
        buf.writeBoolean(this.isMirrored());
        buf.writeInt(this.getClaimRadius(this.getBuildingLevel()));
        CompoundNBT requestSystemCompound = new CompoundNBT();
        this.writeRequestSystemToNBT(requestSystemCompound);
        ImmutableCollection<IRequestResolver<?>> resolvers = this.getResolvers();
        buf.writeInt(resolvers.size());
        for (IRequestResolver resolver : resolvers) {
            buf.func_150786_a(StandardFactoryController.getInstance().serialize(resolver.getId()));
        }
        buf.func_150786_a(StandardFactoryController.getInstance().serialize(this.getId()));
        buf.writeInt(this.containerList.size());
        for (int i = 0; i < this.containerList.size(); ++i) {
            buf.func_179255_a((BlockPos)this.containerList.get(i));
        }
        buf.func_150786_a(requestSystemCompound);
        buf.writeInt(this.minimumStock.size());
        for (Map.Entry<ItemStorage, Integer> entry : this.minimumStock.entrySet()) {
            buf.func_150788_a(entry.getKey().getItemStack());
            buf.writeInt(entry.getValue().intValue());
        }
        buf.writeBoolean(this.minimumStock.size() >= this.minimumStockSize());
        buf.writeBoolean(this.isDeconstructed());
    }

    private int minimumStockSize() {
        double increase = 1.0;
        MultiplierModifierResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Minimum Stock", MultiplierModifierResearchEffect.class);
        if (effect != null) {
            increase = 1.0 + effect.getEffect();
        }
        return (int)((double)(this.getBuildingLevel() * 5) * increase);
    }

    @Override
    public void addMinimumStock(ItemStack itemStack, int quantity) {
        if (this.minimumStock.containsKey(new ItemStorage(itemStack)) || this.minimumStock.size() < this.minimumStockSize()) {
            this.minimumStock.put(new ItemStorage(itemStack), quantity);
            this.markDirty();
        }
    }

    @Override
    public void removeMinimumStock(ItemStack itemStack) {
        this.minimumStock.remove(new ItemStorage(itemStack));
        Collection list = this.getOpenRequestsByRequestableType().getOrDefault(TypeToken.of(Stack.class), new ArrayList());
        IToken<?> token = this.getMatchingRequest(itemStack, list);
        if (token != null) {
            this.getColony().getRequestManager().updateRequestState(token, RequestState.CANCELLED);
        }
        this.markDirty();
    }

    @Override
    public void onColonyTick(IColony colony) {
        super.onColonyTick(colony);
        if (WorldUtil.isBlockLoaded((IWorld)colony.getWorld(), this.getPosition())) {
            Collection list = this.getOpenRequestsByRequestableType().getOrDefault(TypeToken.of(Stack.class), new ArrayList());
            for (Map.Entry<ItemStorage, Integer> entry : this.minimumStock.entrySet()) {
                ItemStack itemStack = entry.getKey().getItemStack().func_77946_l();
                if (itemStack.func_190926_b()) continue;
                int count = InventoryUtils.hasBuildingEnoughElseCount(this, new ItemStorage(itemStack), entry.getValue() * itemStack.func_77976_d());
                int delta = entry.getValue() * itemStack.func_77976_d() - count;
                IToken<?> request = this.getMatchingRequest(itemStack, list);
                if (delta > 0) {
                    if (request != null) continue;
                    itemStack.func_190920_e(Math.min(itemStack.func_77976_d(), delta));
                    Stack stack = new Stack(itemStack);
                    if (this.getMainCitizen() != null) {
                        this.getMainCitizen().createRequestAsync(stack);
                        continue;
                    }
                    this.createRequest(stack, false);
                    continue;
                }
                if (request == null) continue;
                this.getColony().getRequestManager().updateRequestState(request, RequestState.CANCELLED);
            }
        }
    }

    private IToken<?> getMatchingRequest(ItemStack stack, Collection<IToken<?>> list) {
        for (IToken<?> token : list) {
            IRequest<?> iRequest = this.colony.getRequestManager().getRequestForToken(token);
            if (iRequest == null || !(iRequest.getRequest() instanceof Stack) || !((Stack)iRequest.getRequest()).getStack().func_77969_a(stack)) continue;
            return token;
        }
        return null;
    }

    public boolean isMinimumStockRequest(IRequest<? extends IDeliverable> request) {
        for (Map.Entry<ItemStorage, Integer> entry : this.minimumStock.entrySet()) {
            if (!(request.getRequest() instanceof Stack) || !((Stack)request.getRequest()).getStack().func_77969_a(entry.getKey().getItemStack())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setCustomBuildingName(String name) {
        this.customName = name;
        this.markDirty();
    }

    @Override
    public boolean canBeGathered() {
        return true;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        if (this.getBuildingLevel() < this.getMaxBuildingLevel()) {
            this.requestWorkOrder(this.getBuildingLevel() + 1, builder, false);
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.worker.noUpgrade", new Object[0]));
        }
    }

    @Override
    public void requestRemoval(PlayerEntity player, BlockPos builder) {
        if (this.isDeconstructed()) {
            ItemStack stack = new ItemStack((IItemProvider)this.colony.getWorld().func_180495_p(this.getPosition()).func_177230_c(), 1);
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74768_a("colony", this.getColony().getID());
            compoundNBT.func_74768_a("otherLevel", this.getBuildingLevel());
            stack.func_77982_d(compoundNBT);
            if (InventoryUtils.addItemStackToProvider((ICapabilityProvider)player, stack)) {
                this.colony.getWorld().func_175655_b(this.getPosition(), false);
            } else {
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.playerinvfull", (Object[])new Object[0]);
            }
        } else {
            this.requestWorkOrder(this.getBuildingLevel(), builder, true);
        }
    }

    @Override
    public void requestRepair(BlockPos builder) {
        if (this.getBuildingLevel() > 0) {
            this.requestWorkOrder(this.getBuildingLevel(), builder, false);
        }
    }

    @Override
    public boolean isBuilt() {
        return this.isBuilt;
    }

    @Override
    public void deconstruct() {
        Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> tuple = this.getCorners();
        for (int x = ((Integer)((Tuple)tuple.func_76341_a()).func_76341_a()).intValue(); x < (Integer)((Tuple)tuple.func_76341_a()).func_76340_b(); ++x) {
            for (int z = ((Integer)((Tuple)tuple.func_76340_b()).func_76341_a()).intValue(); z < (Integer)((Tuple)tuple.func_76340_b()).func_76340_b(); ++z) {
                for (int y = this.getPosition().func_177956_o() - 1; y < this.getPosition().func_177956_o() + this.getHeight(); ++y) {
                    this.getColony().getWorld().func_175655_b(new BlockPos(x, y, z), false);
                }
            }
        }
    }

    @Override
    public AbstractTileEntityColonyBuilding getTileEntity() {
        if (this.tileEntity == null && this.colony != null && this.colony.getWorld() != null && this.getPosition() != null && WorldUtil.isBlockLoaded((IWorld)this.colony.getWorld(), this.getPosition()) && !(this.colony.getWorld().func_180495_p(this.getPosition()).func_177230_c() instanceof AirBlock) && this.colony.getWorld().func_180495_p(this.getPosition()).func_177230_c() instanceof AbstractBlockHut) {
            TileEntity te = this.getColony().getWorld().func_175625_s(this.getPosition());
            if (te instanceof TileEntityColonyBuilding) {
                this.tileEntity = (TileEntityColonyBuilding)te;
                if (this.tileEntity.getBuilding() == null) {
                    this.tileEntity.setColony(this.colony);
                    this.tileEntity.setBuilding(this);
                }
            } else {
                Log.getLogger().error("Somehow the wrong TileEntity is at the location where the building should be!", (Throwable)new Exception());
                Log.getLogger().error("Trying to restore order!");
                TileEntityColonyBuilding tileEntityColonyBuilding = new TileEntityColonyBuilding(MinecoloniesTileEntities.BUILDING);
                this.colony.getWorld().func_175690_a(this.getPosition(), (TileEntity)tileEntityColonyBuilding);
                this.tileEntity = tileEntityColonyBuilding;
            }
        }
        return this.tileEntity;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        this.cachedRotation = -1;
        ChunkDataHelper.claimColonyChunks(this.colony, true, this.getID(), this.getClaimRadius(newLevel));
        this.recheckGuardBuildingNear = true;
        ConstructionTapeHelper.removeConstructionTape(this.getCorners(), this.colony.getWorld());
        this.colony.getProgressManager().progressBuildBuilding(this, this.colony.getBuildingManager().getBuildings().values().stream().filter(building -> building instanceof AbstractBuildingWorker).mapToInt(ISchematicProvider::getBuildingLevel).sum(), this.colony.getBuildingManager().getBuildings().values().stream().filter(building -> building instanceof BuildingHome).mapToInt(ISchematicProvider::getBuildingLevel).sum());
        WorkOrderBuildBuilding workOrder = new WorkOrderBuildBuilding(this, newLevel);
        LoadOnlyStructureHandler wrapper = new LoadOnlyStructureHandler(this.colony.getWorld(), this.getPosition(), workOrder.getStructureName(), new PlacementSettings(), true);
        Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = ColonyUtils.calculateCorners(this.getPosition(), this.colony.getWorld(), wrapper.getBluePrint(), workOrder.getRotation(this.colony.getWorld()), workOrder.isMirrored());
        this.setHeight(wrapper.getBluePrint().getSizeY());
        this.setCorners((Integer)((Tuple)corners.func_76341_a()).func_76341_a(), (Integer)((Tuple)corners.func_76341_a()).func_76340_b(), (Integer)((Tuple)corners.func_76340_b()).func_76341_a(), (Integer)((Tuple)corners.func_76340_b()).func_76340_b());
        this.isBuilt = true;
        if (newLevel > this.getBuildingLevel()) {
            FireworkUtils.spawnFireworksAtAABBCorners(this.getTargetableArea(this.colony.getWorld()), this.colony.getWorld(), newLevel);
        }
    }

    @Override
    public boolean isGuardBuildingNear() {
        if (this.recheckGuardBuildingNear) {
            this.guardBuildingNear = this.colony.getBuildingManager().hasGuardBuildingNear(this);
            this.recheckGuardBuildingNear = false;
        }
        return this.guardBuildingNear;
    }

    @Override
    public void setGuardBuildingNear(boolean guardBuildingNear) {
        this.guardBuildingNear = guardBuildingNear;
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory) {
        for (Map.Entry<Predicate<ItemStack>, Tuple<Integer, Boolean>> entry : this.getRequiredItemsAndAmount().entrySet()) {
            if (inventory && !((Boolean)entry.getValue().func_76340_b()).booleanValue() || !entry.getKey().test(stack)) continue;
            ItemStorage kept = ItemStorage.getItemStackOfListMatchingPredicate(localAlreadyKept, entry.getKey());
            int toKeep = (Integer)entry.getValue().func_76341_a();
            int rest = stack.func_190916_E() - toKeep;
            if (kept != null) {
                if (kept.getAmount() >= toKeep) {
                    return stack.func_190916_E();
                }
                rest = kept.getAmount() + stack.func_190916_E() - toKeep;
                localAlreadyKept.remove(kept);
                kept.setAmount(kept.getAmount() + ItemStackUtils.getSize(stack) - Math.max(0, rest));
                localAlreadyKept.add(kept);
            } else {
                ItemStorage newStorage = new ItemStorage(stack);
                newStorage.setAmount(ItemStackUtils.getSize(stack) - Math.max(0, rest));
                localAlreadyKept.add(newStorage);
            }
            if (rest <= 0) {
                return 0;
            }
            return Math.min(rest, ItemStackUtils.getSize(stack));
        }
        return stack.func_190916_E();
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(this.keepX);
        if (this.keepFood()) {
            toKeep.put(ItemStackUtils.CAN_EAT, new Tuple((Object)(this.getBuildingLevel() * 2), (Object)true));
        }
        IRequestManager manager = this.colony.getRequestManager();
        toKeep.put(stack -> this.getOpenRequestsByCitizen().values().stream().anyMatch(list -> list.stream().filter(token -> manager.getRequestForToken((IToken<?>)token) != null).anyMatch(token -> manager.getRequestForToken((IToken<?>)token).getRequest() instanceof IDeliverable && ((IDeliverable)manager.getRequestForToken((IToken<?>)token).getRequest()).matches((ItemStack)stack))), new Tuple((Object)Integer.MAX_VALUE, (Object)true));
        return toKeep;
    }

    protected boolean keepFood() {
        return true;
    }

    @Override
    @Nullable
    public ItemStack forceTransferStack(ItemStack stack, World world) {
        if (this.getTileEntity() == null) {
            for (BlockPos pos : this.containerList) {
                TileEntity tempTileEntity = world.func_175625_s(pos);
                if (!(tempTileEntity instanceof ChestTileEntity) || InventoryUtils.isProviderFull((ICapabilityProvider)tempTileEntity)) continue;
                return this.forceItemStackToProvider((ICapabilityProvider)tempTileEntity, stack);
            }
        } else {
            return this.forceItemStackToProvider((ICapabilityProvider)this.getTileEntity(), stack);
        }
        return stack;
    }

    @Nullable
    private ItemStack forceItemStackToProvider(@NotNull ICapabilityProvider provider, @NotNull ItemStack itemStack) {
        ArrayList localAlreadyKept = new ArrayList();
        return InventoryUtils.forceItemStackToProvider(provider, itemStack, stack -> EntityAIWorkDeliveryman.workerRequiresItem(this, stack, localAlreadyKept) != stack.func_190916_E());
    }

    protected void writeRequestSystemToNBT(CompoundNBT compound) {
        compound.func_218657_a("Requestor", (INBT)StandardFactoryController.getInstance().serialize(this.requester));
        compound.func_218657_a("DataStoreToken", (INBT)StandardFactoryController.getInstance().serialize(this.rsDataStoreToken));
    }

    protected void setupRsDataStore() {
        this.rsDataStoreToken = this.colony.getRequestManager().getDataStoreManager().get(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), TypeConstants.REQUEST_SYSTEM_BUILDING_DATA_STORE).getId();
    }

    private void loadRequestSystemFromNBT(CompoundNBT compound) {
        this.requester = compound.func_150296_c().contains("Requestor") ? (IRequester)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("Requestor")) : (IRequester)StandardFactoryController.getInstance().getNewInstance(TypeToken.of(BuildingBasedRequester.class), this, new Object[0]);
        if (compound.func_150296_c().contains("DataStoreToken")) {
            this.rsDataStoreToken = (IToken)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("DataStoreToken"));
        } else {
            this.setupRsDataStore();
        }
    }

    private IRequestSystemBuildingDataStore getDataStore() {
        return this.colony.getRequestManager().getDataStoreManager().get(this.rsDataStoreToken, TypeConstants.REQUEST_SYSTEM_BUILDING_DATA_STORE);
    }

    protected Map<TypeToken<?>, Collection<IToken<?>>> getOpenRequestsByRequestableType() {
        return this.getDataStore().getOpenRequestsByRequestableType();
    }

    protected Map<Integer, Collection<IToken<?>>> getOpenRequestsByCitizen() {
        return this.getDataStore().getOpenRequestsByCitizen();
    }

    private Map<Integer, Collection<IToken<?>>> getCompletedRequestsByCitizen() {
        return this.getDataStore().getCompletedRequestsByCitizen();
    }

    private Map<IToken<?>, Integer> getCitizensByRequest() {
        return this.getDataStore().getCitizensByRequest();
    }

    @Override
    public <R extends IRequestable> IToken<?> createRequest(@NotNull ICitizenData citizenData, @NotNull R requested, boolean async) {
        IToken<?> requestToken = this.colony.getRequestManager().createRequest(this.requester, requested);
        IRequest<?> request = this.colony.getRequestManager().getRequestForToken(requestToken);
        if (async) {
            citizenData.getJob().getAsyncRequests().add(requestToken);
            citizenData.triggerInteraction(new RequestBasedInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.requestsystem.playerresolver.async", new Object[]{request.getShortDisplayString()}), ChatPriority.PENDING, (ITextComponent)new TranslationTextComponent("com.minecolonies.requestsystem.playerresolver.normal", new Object[0]), (IToken<?>)request.getId()));
        } else {
            citizenData.triggerInteraction(new RequestBasedInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.requestsystem.playerresolver.normal", new Object[]{request.getShortDisplayString()}), ChatPriority.BLOCKING, (ITextComponent)new TranslationTextComponent("com.minecolonies.requestsystem.playerresolver.normal", new Object[0]), (IToken<?>)request.getId()));
        }
        this.addRequestToMaps(citizenData.getId(), requestToken, TypeToken.of(requested.getClass()));
        this.colony.getRequestManager().assignRequest(requestToken);
        this.markDirty();
        return requestToken;
    }

    @Override
    public <R extends IRequestable> IToken<?> createRequest(@NotNull R requested, boolean async) {
        IToken<?> requestToken = this.colony.getRequestManager().createRequest(this.requester, requested);
        this.addRequestToMaps(-1, requestToken, TypeToken.of(requested.getClass()));
        this.colony.getRequestManager().assignRequest(requestToken);
        this.markDirty();
        return requestToken;
    }

    private void addRequestToMaps(@NotNull Integer citizenId, @NotNull IToken<?> requestToken, @NotNull TypeToken<?> requested) {
        if (!this.getOpenRequestsByRequestableType().containsKey(requested)) {
            this.getOpenRequestsByRequestableType().put(requested, new ArrayList());
        }
        this.getOpenRequestsByRequestableType().get(requested).add(requestToken);
        this.getCitizensByRequest().put(requestToken, citizenId);
        if (!this.getOpenRequestsByCitizen().containsKey(citizenId)) {
            this.getOpenRequestsByCitizen().put(citizenId, new ArrayList());
        }
        this.getOpenRequestsByCitizen().get(citizenId).add(requestToken);
    }

    @Override
    public boolean hasWorkerOpenRequests(@NotNull ICitizenData citizen) {
        return this.getOpenRequestsByCitizen().containsKey(citizen.getId()) && !this.getOpenRequestsByCitizen().get(citizen.getId()).isEmpty();
    }

    @Override
    public ImmutableList<IRequest<?>> getOpenRequests(@NotNull ICitizenData data) {
        if (!this.getOpenRequestsByCitizen().containsKey(data.getId())) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.getOpenRequestsByCitizen().get(data.getId()).stream().map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    @Override
    public boolean hasWorkerOpenRequestsFiltered(@NotNull ICitizenData citizen, @NotNull Predicate<IRequest<?>> selectionPredicate) {
        return this.getOpenRequests(citizen).stream().anyMatch(selectionPredicate);
    }

    @Override
    public boolean hasOpenSyncRequest(@NotNull ICitizenData citizen) {
        if (!this.hasWorkerOpenRequests(citizen)) {
            return false;
        }
        for (IToken<?> token : this.getOpenRequestsByCitizen().get(citizen.getId())) {
            if (citizen.isRequestAsync(token)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <R> boolean hasWorkerOpenRequestsOfType(@NotNull ICitizenData citizenData, TypeToken<R> requestType) {
        return !this.getOpenRequestsOfType(citizenData, requestType).isEmpty();
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfType(@NotNull ICitizenData citizenData, TypeToken<R> requestType) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> request.getType().isSubtypeOf(requestType)).map(request -> request).iterator());
    }

    @Override
    public boolean createPickupRequest(int scaledPriority) {
        if (scaledPriority < 0 || scaledPriority > AbstractDeliverymanRequestable.getPlayerActionPriority(true)) {
            return false;
        }
        ArrayList reqs = new ArrayList(this.getOpenRequestsByRequestableType().getOrDefault(TypeConstants.PICKUP, Collections.emptyList()));
        if (!reqs.isEmpty()) {
            for (IToken req : reqs) {
                IRequestResolver<?> resolver;
                if (this.colony.getRequestManager().getRequestForToken(req).getState() != RequestState.IN_PROGRESS || !((resolver = this.colony.getRequestManager().getResolverForRequest(req)) instanceof IPlayerRequestResolver) && !(resolver instanceof IRetryingRequestResolver)) continue;
                this.colony.getRequestManager().reassignRequest(req, Collections.emptyList());
            }
            return false;
        }
        this.createRequest(new Pickup(scaledPriority), true);
        return true;
    }

    @Override
    public boolean hasCitizenCompletedRequests(@NotNull ICitizenData data) {
        return this.getCompletedRequestsByCitizen().containsKey(data.getId()) && !this.getCompletedRequestsByCitizen().get(data.getId()).isEmpty();
    }

    @Override
    public ImmutableList<IRequest<?>> getCompletedRequests(@NotNull ICitizenData data) {
        if (!this.getCompletedRequestsByCitizen().containsKey(data.getId())) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.getCompletedRequestsByCitizen().get(data.getId()).stream().map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfType(@NotNull ICitizenData citizenData, TypeToken<R> requestType) {
        return ImmutableList.copyOf(this.getCompletedRequests(citizenData).stream().filter(request -> request.getType().isSubtypeOf(requestType)).map(request -> request).iterator());
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfTypeFiltered(@NotNull ICitizenData citizenData, TypeToken<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getCompletedRequests(citizenData).stream().filter(request -> request.getType().isSubtypeOf(requestType)).map(request -> request).filter(filter).iterator());
    }

    @Override
    public void markRequestAsAccepted(@NotNull ICitizenData data, @NotNull IToken<?> token) {
        if (!this.getCompletedRequestsByCitizen().containsKey(data.getId()) || !this.getCompletedRequestsByCitizen().get(data.getId()).contains(token)) {
            throw new IllegalArgumentException("The given token " + token + " is not known as a completed request waiting for acceptance by the citizen.");
        }
        this.getCompletedRequestsByCitizen().get(data.getId()).remove(token);
        if (this.getCompletedRequestsByCitizen().get(data.getId()).isEmpty()) {
            this.getCompletedRequestsByCitizen().remove(data.getId());
        }
        this.getColony().getRequestManager().updateRequestState(token, RequestState.RECEIVED);
        this.markDirty();
    }

    @Override
    public void cancelAllRequestsOfCitizen(@NotNull ICitizenData data) {
        this.getOpenRequests(data).forEach(request -> {
            this.getColony().getRequestManager().updateRequestState((IToken<?>)request.getId(), RequestState.CANCELLED);
            if (this.getOpenRequestsByRequestableType().containsKey(TypeToken.of(request.getRequest().getClass()))) {
                this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).remove(request.getId());
                if (this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).isEmpty()) {
                    this.getOpenRequestsByRequestableType().remove(TypeToken.of(request.getRequest().getClass()));
                }
            }
            this.getCitizensByRequest().remove(request.getId());
        });
        this.getCompletedRequests(data).forEach(request -> this.getColony().getRequestManager().updateRequestState((IToken<?>)request.getId(), RequestState.RECEIVED));
        this.getOpenRequestsByCitizen().remove(data.getId());
        this.getCompletedRequestsByCitizen().remove(data.getId());
        this.markDirty();
    }

    @Override
    public void overruleNextOpenRequestWithStack(@NotNull ItemStack stack) {
        IRequest<? extends IDeliverable> target;
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return;
        }
        ImmutableCollection<IRequestResolver<?>> resolvers = this.getResolvers();
        for (IRequestResolver resolver : resolvers) {
            IStandardRequestManager requestManager = (IStandardRequestManager)this.getColony().getRequestManager();
            List<IRequest<? extends IDeliverable>> deliverableRequests = requestManager.getRequestHandler().getRequestsMadeByRequester(resolver).stream().filter(iRequest -> iRequest.getRequest() instanceof IDeliverable).map(iRequest -> iRequest).collect(Collectors.toList());
            target = this.getFirstOverullingRequestFromInputList(deliverableRequests, stack);
            if (target == null || !this.colony.getRequestManager().getPlayerResolver().getAllAssignedRequests().contains(target.getId()) && !this.colony.getRequestManager().getRetryingRequestResolver().getAllAssignedRequests().contains(target.getId())) continue;
            this.getColony().getRequestManager().overruleRequest((IToken<?>)target.getId(), stack.func_77946_l());
            return;
        }
        Set<Integer> citizenIdsWithRequests = this.getOpenRequestsByCitizen().keySet();
        for (int citizenId : citizenIdsWithRequests) {
            ICitizenData data = this.getColony().getCitizenManager().getCivilian(citizenId);
            if (data == null || (target = this.getFirstOverullingRequestFromInputList((Collection<IRequest<? extends IDeliverable>>)this.getOpenRequestsOfType(data, TypeConstants.DELIVERABLE), stack)) == null || !this.colony.getRequestManager().getPlayerResolver().getAllAssignedRequests().contains(target.getId()) && !this.colony.getRequestManager().getRetryingRequestResolver().getAllAssignedRequests().contains(target.getId())) continue;
            this.getColony().getRequestManager().overruleRequest((IToken<?>)target.getId(), stack.func_77946_l());
            return;
        }
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfTypeFiltered(@NotNull ICitizenData citizenData, TypeToken<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> request.getType().isSubtypeOf(requestType)).map(request -> request).filter(filter).iterator());
    }

    @Override
    public boolean overruleNextOpenRequestOfCitizenWithStack(@NotNull ICitizenData citizenData, @NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        IRequest<? extends IDeliverable> target = this.getFirstOverullingRequestFromInputList((Collection<IRequest<? extends IDeliverable>>)this.getOpenRequestsOfType(citizenData, TypeConstants.DELIVERABLE), stack);
        if (target == null) {
            AbstractJobCrafter crafterJob;
            if (citizenData.getJob() instanceof AbstractJobCrafter && !(crafterJob = citizenData.getJob(AbstractJobCrafter.class)).getAssignedTasks().isEmpty()) {
                List<IToken<?>> assignedTasks = crafterJob.getAssignedTasks();
                IRequest deliverableChildRequest = assignedTasks.stream().map(this.getColony().getRequestManager()::getRequestForToken).map(IRequest::getChildren).flatMap(Collection::stream).map(this.getColony().getRequestManager()::getRequestForToken).filter(iRequest -> iRequest.getRequest() instanceof IDeliverable).filter(iRequest -> ((IDeliverable)iRequest.getRequest()).matches(stack)).findFirst().map(iRequest -> iRequest).orElse(null);
                if (deliverableChildRequest != null) {
                    deliverableChildRequest.overrideCurrentDeliveries((ImmutableList<ItemStack>)ImmutableList.of((Object)stack));
                    this.getColony().getRequestManager().overruleRequest((IToken<?>)deliverableChildRequest.getId(), stack.func_77946_l());
                    return true;
                }
            }
            return false;
        }
        try {
            target.overrideCurrentDeliveries((ImmutableList<ItemStack>)ImmutableList.of((Object)stack));
            this.getColony().getRequestManager().overruleRequest((IToken<?>)target.getId(), stack.func_77946_l());
        }
        catch (Exception ex) {
            Log.getLogger().error("Error during overruling", (Throwable)ex);
            Log.getLogger().error(target.getId().toString() + " " + target.getState().name() + " " + target.getShortDisplayString().toString());
            return false;
        }
        return true;
    }

    private IRequest<? extends IDeliverable> getFirstOverullingRequestFromInputList(@NotNull Collection<IRequest<? extends IDeliverable>> queue, @NotNull ItemStack stack) {
        if (queue.isEmpty()) {
            return null;
        }
        ArrayList validRequesterTokens = Lists.newArrayList();
        validRequesterTokens.add(this.getId());
        this.getResolvers().forEach(iRequestResolver -> validRequesterTokens.add(iRequestResolver.getId()));
        return queue.stream().filter(request -> request.getState() == RequestState.IN_PROGRESS && validRequesterTokens.contains(request.getRequester().getId()) && ((IDeliverable)request.getRequest()).matches(stack)).findFirst().orElse(null);
    }

    @Override
    public IToken<?> getId() {
        return this.requester.getId();
    }

    @Override
    public final ImmutableCollection<IRequestResolver<?>> getResolvers() {
        IStandardRequestManager requestManager = (IStandardRequestManager)this.getColony().getRequestManager();
        if (!requestManager.getProviderHandler().getRegisteredResolvers(this).isEmpty()) {
            return ImmutableList.copyOf((Collection)requestManager.getProviderHandler().getRegisteredResolvers(this).stream().map(token -> requestManager.getResolverHandler().getResolver((IToken<?>)token)).collect(Collectors.toList()));
        }
        return this.createResolvers();
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        return ImmutableList.of((Object)new BuildingRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
    }

    @Override
    public IRequester getRequester() {
        return this.requester;
    }

    @Override
    @NotNull
    public ILocation getLocation() {
        return this.getRequester().getLocation();
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        Integer citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
        if (this.getOpenRequestsByCitizen().containsKey(citizenThatRequested)) {
            this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(request.getId());
            if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
                this.getOpenRequestsByCitizen().remove(citizenThatRequested);
            }
        }
        this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).remove(request.getId());
        if (this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).isEmpty()) {
            this.getOpenRequestsByRequestableType().remove(TypeToken.of(request.getRequest().getClass()));
        }
        if (citizenThatRequested >= 0) {
            this.getCompletedRequestsByCitizen().computeIfAbsent(citizenThatRequested, ArrayList::new).add(request.getId());
        } else {
            this.colony.getRequestManager().updateRequestState((IToken<?>)request.getId(), RequestState.RECEIVED);
        }
        this.markDirty();
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        int citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
        this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(request.getId());
        if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
            this.getOpenRequestsByCitizen().remove(citizenThatRequested);
        }
        if (this.getOpenRequestsByRequestableType().containsKey(TypeToken.of(request.getRequest().getClass()))) {
            this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).remove(request.getId());
            if (this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).isEmpty()) {
                this.getOpenRequestsByRequestableType().remove(TypeToken.of(request.getRequest().getClass()));
            }
        }
        if (this.getColony().getCitizenManager().getCivilian(citizenThatRequested) != null) {
            this.getColony().getCitizenManager().getCivilian(citizenThatRequested).onRequestCancelled((IToken<?>)request.getId());
        }
        this.markDirty();
    }

    @Override
    @NotNull
    public ITextComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        if (!this.getCitizensByRequest().containsKey(request.getId())) {
            return new StringTextComponent("<UNKNOWN>");
        }
        Integer citizenData = this.getCitizensByRequest().get(request.getId());
        return new StringTextComponent(this.getSchematicName() + " " + this.getColony().getCitizenManager().getCivilian(citizenData).getName());
    }

    @Override
    public Optional<ICitizenData> getCitizenForRequest(@NotNull IToken<?> token) {
        if (!this.getCitizensByRequest().containsKey(token) || this.getColony() == null) {
            return Optional.empty();
        }
        int citizenID = this.getCitizensByRequest().get(token);
        if (this.getColony().getCitizenManager().getCivilian(citizenID) == null) {
            return Optional.empty();
        }
        return Optional.of(this.getColony().getCitizenManager().getCivilian(citizenID));
    }

    @Override
    public void openCraftingContainer(ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Crafting GUI");
            }

            @NotNull
            public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
                PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
                buffer.writeBoolean(false);
                buffer.func_179255_a(AbstractBuilding.this.getID());
                return new ContainerCrafting(id, inv, buffer);
            }
        }, buffer -> new PacketBuffer(buffer.writeBoolean(false)).func_179255_a(this.getID()));
    }
}

