/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.colony.buildings.AbstractFilterableListBuilding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBuildingFurnaceUser
extends AbstractFilterableListBuilding {
    private static final String TAG_POS = "pos";
    private static final String TAG_POS_COMPAT = "furnacePos";
    private static final String TAG_FURNACES = "furnaces";
    public static final String FUEL_LIST = "fuel";
    private final List<BlockPos> furnaces = new ArrayList<BlockPos>();

    public AbstractBuildingFurnaceUser(IColony c, BlockPos l) {
        super(c, l);
    }

    public List<BlockPos> getFurnaces() {
        return new ArrayList<BlockPos>(this.furnaces);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT furnaceTagList = compound.func_150295_c(TAG_FURNACES, 10);
        for (int i = 0; i < furnaceTagList.size(); ++i) {
            if (furnaceTagList.func_150305_b(i).func_74764_b(TAG_POS)) {
                this.furnaces.add(NBTUtil.func_186861_c((CompoundNBT)furnaceTagList.func_150305_b(i).func_74775_l(TAG_POS)));
            }
            if (!furnaceTagList.func_150305_b(i).func_74764_b(TAG_POS_COMPAT)) continue;
            this.furnaces.add(NBTUtil.func_186861_c((CompoundNBT)furnaceTagList.func_150305_b(i).func_74775_l(TAG_POS_COMPAT)));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT furnacesTagList = new ListNBT();
        for (BlockPos entry : this.furnaces) {
            CompoundNBT furnaceCompound = new CompoundNBT();
            furnaceCompound.func_218657_a(TAG_POS, (INBT)NBTUtil.func_186859_a((BlockPos)entry));
            furnacesTagList.add((Object)furnaceCompound);
        }
        compound.func_218657_a(TAG_FURNACES, (INBT)furnacesTagList);
        return compound;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block instanceof FurnaceBlock && !this.furnaces.contains(pos)) {
            this.furnaces.add(pos);
        }
        this.markDirty();
    }

    public void removeFromFurnaces(BlockPos pos) {
        this.furnaces.remove(pos);
    }

    public List<ItemStack> getAllowedFuel() {
        return this.getCopyOfAllowedItems().containsKey(FUEL_LIST) ? this.getCopyOfAllowedItems().get(FUEL_LIST).stream().map(ItemStorage::getItemStack).peek(stack -> stack.func_190920_e(stack.func_77976_d())).collect(Collectors.toList()) : Collections.emptyList();
    }

    public boolean isAllowedFuel(ItemStack stack) {
        return this.getCopyOfAllowedItems().get(FUEL_LIST).stream().anyMatch(itemStack -> stack.func_77969_a(itemStack.getItemStack()));
    }
}

