/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.network.messages.server.colony.building.herder.HerderSetBreedingMessage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public abstract class AbstractBuildingHerder
extends AbstractBuildingWorker {
    private boolean breeding = true;

    public AbstractBuildingHerder(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void serializeToView(PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.breeding);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_74764_b("breeding")) {
            this.breeding = compound.func_74767_n("breeding");
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74757_a("breeding", this.breeding);
        return compound;
    }

    public boolean isBreeding() {
        return this.breeding;
    }

    public void setBreeding(boolean breeding) {
        this.breeding = breeding;
        this.markDirty();
    }

    public static class View
    extends AbstractBuildingWorker.View {
        private boolean breeding = true;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        public void setBreeding(boolean breeding) {
            Network.getNetwork().sendToServer(new HerderSetBreedingMessage(this, breeding));
            this.breeding = breeding;
        }

        public boolean isBreeding() {
            return this.breeding;
        }

        @Override
        public void deserialize(PacketBuffer buf) {
            super.deserialize(buf);
            this.breeding = buf.readBoolean();
        }
    }
}

