/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingPublicCrafter;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.inventory.container.ContainerCraftingFurnace;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingFurnaceUser;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PublicWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PublicWorkerCraftingRequestResolver;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBuildingSmelterCrafter
extends AbstractBuildingFurnaceUser
implements IBuildingPublicCrafter {
    private static final int EXTRA_RECIPE_MULTIPLIER = 10;

    public AbstractBuildingSmelterCrafter(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        ImmutableCollection<IRequestResolver<?>> supers = super.createResolvers();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(supers);
        builder.add((Object)new PublicWorkerCraftingRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        builder.add((Object)new PublicWorkerCraftingProductionResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<ItemStorage, Tuple> recipeOutputs = new HashMap<ItemStorage, Tuple>();
        for (ICitizenData citizen : this.getAssignedCitizen()) {
            if (!(citizen.getJob() instanceof AbstractJobCrafter)) continue;
            List<IToken<?>> assignedTaskIds = ((AbstractJobCrafter)citizen.getJob()).getAssignedTasksFromDataStore();
            for (IToken<?> taskToken : assignedTaskIds) {
                IRequest<?> request = this.colony.getRequestManager().getRequestForToken(taskToken);
                IRecipeStorage recipeStorage = this.getFirstFullFillableRecipe(((PublicCrafting)request.getRequest()).getStack());
                if (recipeStorage == null) continue;
                for (ItemStorage itemStorage : recipeStorage.getCleanedInput()) {
                    if (recipeOutputs.containsKey(itemStorage)) {
                        itemStorage.setAmount((Integer)((Tuple)recipeOutputs.get(itemStorage)).func_76341_a() + itemStorage.getAmount());
                    }
                    recipeOutputs.put(itemStorage, new Tuple((Object)itemStorage.getAmount(), (Object)true));
                }
            }
        }
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(this.keepX);
        toKeep.putAll(recipeOutputs.entrySet().stream().collect(Collectors.toMap(key -> stack -> stack.func_77969_a(((ItemStorage)key.getKey()).getItemStack()), Map.Entry::getValue)));
        return toKeep;
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return true;
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        return AbstractBuildingSmelterCrafter.canBuildingCanLearnMoreRecipes(this.getBuildingLevel(), super.getRecipes().size());
    }

    @Override
    public Skill getCraftSpeedSkill() {
        return this.getSecondarySkill();
    }

    @Override
    public void openCraftingContainer(ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Furnace Crafting GUI");
            }

            @NotNull
            public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
                PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
                buffer.func_179255_a(AbstractBuildingSmelterCrafter.this.getID());
                return new ContainerCraftingFurnace(id, inv, buffer);
            }
        }, (BlockPos)this.getID());
    }

    public static boolean canBuildingCanLearnMoreRecipes(int buildingLevel, int learnedRecipes) {
        return Math.pow(2.0, buildingLevel) * 10.0 >= (double)(learnedRecipes + 1);
    }

    public static class View
    extends AbstractFilterableListsView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public boolean canRecipeBeAdded() {
            return AbstractBuildingSmelterCrafter.canBuildingCanLearnMoreRecipes(this.getBuildingLevel(), super.getRecipes().size());
        }
    }
}

