/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.utils;

import com.minecolonies.api.crafting.ItemStorage;
import java.io.Serializable;
import java.util.Comparator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BuildingBuilderResource
extends ItemStorage {
    private int amountAvailable = 0;
    private int amountPlayer = 0;

    public BuildingBuilderResource(@NotNull ItemStack stack, int amount, int available) {
        this(stack, amount);
        this.amountAvailable = available;
    }

    public BuildingBuilderResource(@NotNull ItemStack stack, int amount) {
        super(stack, amount, false);
    }

    public void addAvailable(int amount) {
        this.amountAvailable += amount;
    }

    public int getMissingFromPlayer() {
        return this.amountPlayer + this.amountAvailable - this.getAmount();
    }

    public String toString() {
        int itemId = Item.func_150891_b((Item)this.getItem());
        int hashCode = this.getItemStack().func_77942_o() ? this.getItemStack().func_77978_p().hashCode() : 0;
        return this.getName() + "(p:" + this.amountPlayer + " a:" + this.amountAvailable + " n:" + this.getAmount() + " id=" + itemId + " damage=" + this.getDamageValue() + "-" + hashCode + ") => " + this.getAvailabilityStatus().name();
    }

    public String getName() {
        return this.getItemStack().func_200301_q().func_150254_d();
    }

    public RessourceAvailability getAvailabilityStatus() {
        if (this.getAmount() > this.amountAvailable) {
            if (this.amountPlayer == 0) {
                return RessourceAvailability.DONT_HAVE;
            }
            if (this.amountPlayer < this.getAmount() - this.amountAvailable) {
                return RessourceAvailability.NEED_MORE;
            }
            return RessourceAvailability.HAVE_ENOUGH;
        }
        return RessourceAvailability.NOT_NEEDED;
    }

    @Override
    public int hashCode() {
        return 31 * (31 * super.hashCode() + this.amountAvailable) + this.amountPlayer;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            BuildingBuilderResource that = (BuildingBuilderResource)o;
            return this.getAvailable() == that.getAvailable() && this.getPlayerAmount() == that.getPlayerAmount();
        }
        return false;
    }

    public int getAvailable() {
        return this.amountAvailable;
    }

    public void setAvailable(int amount) {
        this.amountAvailable = amount;
    }

    public int getPlayerAmount() {
        return this.amountPlayer;
    }

    public void setPlayerAmount(int amount) {
        this.amountPlayer = amount;
    }

    public static class ResourceComparator
    implements Comparator<BuildingBuilderResource>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(BuildingBuilderResource resource1, BuildingBuilderResource resource2) {
            if (resource1.getAvailabilityStatus() == resource2.getAvailabilityStatus()) {
                return resource1.getName().compareTo(resource2.getName());
            }
            return resource2.getAvailabilityStatus().compareTo(resource1.getAvailabilityStatus());
        }
    }

    public static enum RessourceAvailability {
        NOT_NEEDED,
        DONT_HAVE,
        NEED_MORE,
        HAVE_ENOUGH;

    }
}

