/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.views;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBuildingBuilderView
extends AbstractBuildingWorker.View {
    private final HashMap<String, BuildingBuilderResource> resources = new HashMap();
    private String constructionName;
    private String constructionPos;
    private String workerName;
    private double progress;
    private int finishedStages = 0;
    private int totalStages = 1;

    public AbstractBuildingBuilderView(IColonyView c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        super.deserialize(buf);
        int size = buf.readInt();
        this.resources.clear();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = buf.func_150791_c();
            int amountAvailable = buf.readInt();
            int amountNeeded = buf.readInt();
            BuildingBuilderResource resource = new BuildingBuilderResource(itemStack, amountNeeded, amountAvailable);
            this.resources.put(itemStack.func_200301_q().func_150254_d(), resource);
        }
        this.constructionName = buf.func_150789_c(Short.MAX_VALUE);
        this.constructionPos = buf.func_150789_c(Short.MAX_VALUE);
        this.progress = buf.readDouble();
        this.totalStages = buf.readInt();
        this.finishedStages = buf.readInt();
        this.workerName = buf.func_150789_c(Short.MAX_VALUE);
    }

    public String getConstructionName() {
        return this.constructionName;
    }

    public String getConstructionPos() {
        return this.constructionPos;
    }

    public Map<String, BuildingBuilderResource> getResources() {
        return Collections.unmodifiableMap(this.resources);
    }

    public String getWorkerName() {
        return this.workerName;
    }

    public String getProgress() {
        int localProgress = 100 - (int)(this.progress * 100.0);
        if (this.finishedStages == 0) {
            if (this.totalStages == this.finishedStages) {
                return "0%";
            }
            return localProgress / 2 + "%";
        }
        return (long)(localProgress / 2) + Math.round((double)this.finishedStages / (double)this.totalStages * 50.0) + "%";
    }
}

