/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.views;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.network.messages.server.colony.building.AssignFilterableItemMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFilterableListsView
extends AbstractBuildingWorker.View {
    private final Map<String, List<ItemStorage>> listsOfItems = new HashMap<String, List<ItemStorage>>();

    public AbstractFilterableListsView(IColonyView c, @NotNull BlockPos l) {
        super(c, l);
    }

    public void addItem(String id, ItemStorage item) {
        Network.getNetwork().sendToServer(new AssignFilterableItemMessage(this, id, item, true));
        if (this.listsOfItems.containsKey(id)) {
            if (!this.listsOfItems.get(id).contains(item)) {
                List<ItemStorage> list = this.listsOfItems.get(id);
                list.add(item);
                this.listsOfItems.put(id, list);
            }
        } else {
            ArrayList<ItemStorage> list = new ArrayList<ItemStorage>();
            list.add(item);
            this.listsOfItems.put(id, list);
        }
    }

    public boolean isAllowedItem(String id, ItemStorage item) {
        return this.listsOfItems.containsKey(id) && this.listsOfItems.get(id).contains(item);
    }

    public int getSize(String key) {
        return ((List)this.listsOfItems.getOrDefault(key, new ArrayList())).size();
    }

    public void removeItem(String id, ItemStorage item) {
        Network.getNetwork().sendToServer(new AssignFilterableItemMessage(this, id, item, false));
        if (this.listsOfItems.containsKey(id) && this.listsOfItems.get(id).contains(item)) {
            List<ItemStorage> list = this.listsOfItems.get(id);
            list.remove(item);
            this.listsOfItems.put(id, list);
        }
    }

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        super.deserialize(buf);
        int ids = buf.readInt();
        for (int i = 0; i < ids; ++i) {
            String id = buf.func_150789_c(Short.MAX_VALUE);
            int size = buf.readInt();
            ArrayList<ItemStorage> list = new ArrayList<ItemStorage>();
            for (int j = 0; j < size; ++j) {
                list.add(new ItemStorage(buf.func_150791_c()));
            }
            this.listsOfItems.put(id, list);
        }
    }
}

