/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.client.gui.WindowHutBaker;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingSmelterCrafter;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import com.minecolonies.coremod.colony.jobs.JobBaker;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PublicWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PublicWorkerCraftingRequestResolver;
import com.minecolonies.coremod.entity.ai.citizen.baker.BakingProduct;
import com.minecolonies.coremod.entity.ai.citizen.baker.ProductState;
import com.minecolonies.coremod.util.FurnaceRecipes;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class BuildingBaker
extends AbstractBuildingSmelterCrafter {
    private static final String BAKER = "baker";
    private static final int BAKER_HUT_MAX_LEVEL = 5;
    private static final String TAG_TASKS = "tasks";
    private static final String TAG_STATE = "state";
    private static final String TAG_PRODUCTS = "products";
    private static final int RECIPE_INPUT_HOLD = 128;

    public BuildingBaker(IColony c, BlockPos l) {
        super(c, l);
        for (IToken<?> token : this.getRecipes()) {
            IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
            for (ItemStorage itemStorage : storage.getCleanedInput()) {
                ItemStack stack = itemStorage.getItemStack();
                this.keepX.put(arg_0 -> ((ItemStack)stack).func_77969_a(arg_0), new Tuple((Object)128, (Object)false));
            }
        }
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BAKER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    protected boolean keepFood() {
        return false;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobBaker(citizen);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT taskTagList = compound.func_150295_c(TAG_TASKS, 10);
        for (int i = 0; i < taskTagList.size(); ++i) {
            CompoundNBT taskCompound = taskTagList.func_150305_b(i);
            ProductState state = ProductState.values()[taskCompound.func_74762_e(TAG_STATE)];
            ArrayList<BakingProduct> bakingProducts = new ArrayList<BakingProduct>();
            ListNBT productTagList = taskCompound.func_150295_c(TAG_PRODUCTS, 10);
            for (int j = 0; j < productTagList.size(); ++j) {
                CompoundNBT productCompound = taskTagList.func_150305_b(i);
                BakingProduct bakingProduct = BakingProduct.createFromNBT(productCompound);
                bakingProducts.add(bakingProduct);
                if (state == ProductState.UNCRAFTED) continue;
                InventoryUtils.addItemStackToProvider(this, bakingProduct.getEndProduct());
            }
        }
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        Collection supers = super.createResolvers().stream().filter(r -> !(r instanceof PrivateWorkerCraftingProductionResolver) && !(r instanceof PrivateWorkerCraftingRequestResolver)).collect(Collectors.toList());
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)supers);
        builder.add((Object)new PublicWorkerCraftingRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        builder.add((Object)new PublicWorkerCraftingProductionResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }

    @Override
    public void openCraftingContainer(ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Crafting GUI");
            }

            @NotNull
            public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
                PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
                buffer.writeBoolean(BuildingBaker.this.canCraftComplexRecipes());
                buffer.func_179255_a(BuildingBaker.this.getID());
                return new ContainerCrafting(id, inv, buffer);
            }
        }, buffer -> new PacketBuffer(buffer.writeBoolean(this.canCraftComplexRecipes())).func_179255_a(this.getID()));
    }

    @Override
    @NotNull
    public String getJobName() {
        return BAKER;
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        Optional<Boolean> isRecipeAllowed = super.canRecipeBeAddedBasedOnTags(token);
        if (isRecipeAllowed.isPresent()) {
            return isRecipeAllowed.get();
        }
        IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
        boolean hasWheat = false;
        for (ItemStorage input : storage.getCleanedInput()) {
            if (!Tags.Items.CROPS_WHEAT.func_199685_a_((Object)input.getItemStack().func_77973_b())) continue;
            hasWheat = true;
        }
        return hasWheat && ItemStackUtils.ISFOOD.test(storage.getPrimaryOutput());
    }

    @Override
    public boolean addRecipe(IToken<?> token) {
        IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
        ItemStack smeltResult = FurnaceRecipes.getInstance().getSmeltingResult(storage.getPrimaryOutput());
        if (smeltResult != null) {
            IRecipeStorage smeltingRecipe = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{ImmutableList.of((Object)storage.getPrimaryOutput().func_77946_l()), 1, smeltResult, Blocks.field_150460_al});
            this.addRecipeToList(IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(smeltingRecipe));
        }
        return super.addRecipe(token);
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return true;
    }

    @Override
    public boolean isRecipeAlterationAllowed() {
        return this.getBuildingLevel() >= 3;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Knowledge;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Dexterity;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.bakery;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151015_O) {
            return false;
        }
        return super.canEat(stack);
    }

    public static class View
    extends AbstractFilterableListsView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutBaker(this);
        }
    }
}

