/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.client.gui.WindowHutCrafter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.jobs.JobBlacksmith;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class BuildingBlacksmith
extends AbstractBuildingCrafter {
    private static final String BLACKSMITH = "blacksmith";

    public BuildingBlacksmith(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BLACKSMITH;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobBlacksmith(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return BLACKSMITH;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Strength;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Focus;
    }

    @Override
    @NotNull
    public Skill getCraftSpeedSkill() {
        return this.getPrimarySkill();
    }

    @Override
    @NotNull
    public Skill getRecipeImprovementSkill() {
        return this.getSecondarySkill();
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
        ItemStack output = storage.getPrimaryOutput();
        boolean matchOverride = output.func_77973_b() instanceof ToolItem || output.func_77973_b() instanceof SwordItem || output.func_77973_b() instanceof ArmorItem || output.func_77973_b() instanceof HoeItem || output.func_77973_b() instanceof ShieldItem || Compatibility.isTinkersWeapon(output);
        Optional<Boolean> isRecipeAllowed = super.canRecipeBeAddedBasedOnTags((IToken)token);
        if (isRecipeAllowed.isPresent()) {
            return matchOverride || isRecipeAllowed.get() != false;
        }
        return matchOverride;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.blacksmith;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Blacksmith", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCrafter(this, BuildingBlacksmith.BLACKSMITH);
        }
    }
}

