/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingBedProvider;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.JobCombatTraining;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.HayBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingCombatAcademy
extends AbstractBuildingWorker
implements IBuildingBedProvider {
    private static final String SCHEMATIC_NAME = "combatacademy";
    private static final String DESC = "combatacademy";
    private final List<BlockPos> fightingPos = new ArrayList<BlockPos>();
    private final BiMap<Integer, Integer> trainingPartners = HashBiMap.create();
    @NotNull
    private final List<BlockPos> bedList = new ArrayList<BlockPos>();

    public BuildingCombatAcademy(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobCombatTraining(citizen);
    }

    @Override
    @NotNull
    public List<BlockPos> getBedList() {
        return new ArrayList<BlockPos>(this.bedList);
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (super.assignCitizen(citizen) && citizen != null) {
            IBuilding building = citizen.getHomeBuilding();
            if (building != null && !building.getID().equals((Object)this.getID())) {
                building.removeCitizen(citizen);
            }
            citizen.setHomeBuilding(this);
            return true;
        }
        return false;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block instanceof CarvedPumpkinBlock && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof HayBlock) {
            this.fightingPos.add(pos.func_177977_b());
        }
        super.registerBlockPosition(block, pos, world);
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Combat Academy", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.fightingPos.clear();
        ListNBT targetList = compound.func_150295_c("combatTarget", 10);
        this.fightingPos.addAll(NBTUtils.streamCompound(targetList).map(targetCompound -> BlockPosUtil.read(targetCompound, "target")).collect(Collectors.toList()));
        ListNBT partnersTagList = compound.func_150295_c("combatPartner", 10);
        this.trainingPartners.putAll(NBTUtils.streamCompound(partnersTagList).collect(Collectors.toMap(targetCompound -> targetCompound.func_74762_e("combatPartner1"), targetCompound -> targetCompound.func_74762_e("combatPartner2"))));
        ListNBT bedTagList = compound.func_150295_c("beds", 10);
        for (int i = 0; i < bedTagList.size(); ++i) {
            CompoundNBT bedCompound = bedTagList.func_150305_b(i);
            BlockPos bedPos = NBTUtil.func_186861_c((CompoundNBT)bedCompound);
            if (this.bedList.contains(bedPos)) continue;
            this.bedList.add(bedPos);
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT targetList = this.fightingPos.stream().map(target -> BlockPosUtil.write(new CompoundNBT(), "target", target)).collect(NBTUtils.toListNBT());
        compound.func_218657_a("combatTarget", (INBT)targetList);
        ListNBT partnersTagList = this.trainingPartners.entrySet().stream().map(BuildingCombatAcademy::writePartnerTupleToNBT).collect(NBTUtils.toListNBT());
        compound.func_218657_a("combatPartner", (INBT)partnersTagList);
        if (!this.bedList.isEmpty()) {
            ListNBT bedTagList = new ListNBT();
            for (BlockPos pos : this.bedList) {
                bedTagList.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
            }
            compound.func_218657_a("beds", (INBT)bedTagList);
        }
        return compound;
    }

    private static CompoundNBT writePartnerTupleToNBT(Map.Entry<Integer, Integer> tuple) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("combatPartner1", tuple.getKey().intValue());
        compound.func_74768_a("combatPartner2", tuple.getValue().intValue());
        return compound;
    }

    @Override
    public String getSchematicName() {
        return "combatacademy";
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return "melee";
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Adaptability;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Stamina;
    }

    @Override
    public int getMaxInhabitants() {
        return this.getBuildingLevel();
    }

    public BlockPos getRandomCombatTarget(Random random) {
        if (!this.fightingPos.isEmpty()) {
            return this.fightingPos.get(random.nextInt(this.fightingPos.size()));
        }
        return null;
    }

    public AbstractEntityCitizen getRandomCombatPartner(AbstractEntityCitizen citizen) {
        ICitizenData citizenData = citizen.getCitizenData();
        if (citizenData != null) {
            ICitizenData partner = this.getAssignedCitizen().stream().filter(data -> data.getId() != citizenData.getId()).filter(data -> !this.trainingPartners.containsKey((Object)data.getId())).filter(data -> !this.trainingPartners.containsValue((Object)data.getId())).findFirst().orElse(null);
            if (partner != null) {
                this.trainingPartners.put((Object)citizenData.getId(), (Object)partner.getId());
                return partner.getEntity().orElse(null);
            }
            return null;
        }
        return null;
    }

    public boolean hasCombatPartner(AbstractEntityCitizen citizen) {
        return this.getCombatPartner(citizen) != null;
    }

    public AbstractEntityCitizen getCombatPartner(AbstractEntityCitizen citizen) {
        ICitizenData data = citizen.getCitizenData();
        if (data != null) {
            int citizenId;
            if (this.trainingPartners.containsKey((Object)data.getId())) {
                citizenId = (Integer)this.trainingPartners.get((Object)data.getId());
            } else if (this.trainingPartners.containsValue((Object)data.getId())) {
                citizenId = (Integer)this.trainingPartners.inverse().get((Object)data.getId());
            } else {
                return null;
            }
            ICitizenData citizenData = this.getAssignedCitizen().stream().filter(cit -> cit.getId() != data.getId()).filter(cit -> cit.getId() == citizenId).findFirst().orElse(null);
            if (citizenData != null) {
                return citizenData.getEntity().orElse(null);
            }
        }
        return null;
    }

    public void resetPartner(AbstractEntityCitizen worker) {
        ICitizenData data = worker.getCitizenData();
        if (data != null) {
            if (this.trainingPartners.containsKey((Object)data.getId())) {
                this.trainingPartners.remove((Object)data.getId());
            } else if (this.trainingPartners.containsValue((Object)data.getId())) {
                this.trainingPartners.inverse().remove((Object)data.getId());
            }
        }
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(blockState, pos, world);
        BlockPos registrationPosition = pos;
        if (blockState.func_177230_c() instanceof BedBlock) {
            if (blockState.func_177229_b((IProperty)BedBlock.field_176472_a) == BedPart.FOOT) {
                registrationPosition = registrationPosition.func_177972_a((Direction)blockState.func_177229_b((IProperty)BedBlock.field_185512_D));
            }
            if (!this.bedList.contains(registrationPosition)) {
                this.bedList.add(registrationPosition);
            }
        }
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.combatAcademy;
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(IColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, "combatacademy");
        }

        @Override
        public boolean hasEnoughWorkers() {
            return this.getWorkerId().size() >= this.getBuildingLevel();
        }
    }
}

