/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.client.gui.WindowHutCrafter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.jobs.JobConcreteMixer;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ConcretePowderBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingConcreteMixer
extends AbstractBuildingCrafter {
    private static final String CONCRETE_MIXER = "concretemixer";
    private static final ResourceLocation CONCRETE_POWDER = new ResourceLocation("minecolonies", "concrete_powder");
    private static final ResourceLocation CONCRETE_BLOCK = new ResourceLocation("minecolonies", "concrete");
    private static final int WATER_DEPTH_SUPPORT = 3;
    private final Map<Integer, List<BlockPos>> waterPos = new HashMap<Integer, List<BlockPos>>();

    public BuildingConcreteMixer(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.PICKAXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    public void checkForWorkerSpecificRecipes() {
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        input.add(new ItemStack((IItemProvider)Items.field_221548_A, 4));
        input.add(new ItemStack((IItemProvider)Items.field_221550_C, 4));
        for (Item item : ItemTags.func_199903_a().func_199915_b(CONCRETE_POWDER).func_199885_a()) {
            ArrayList<ItemStack> customInput = new ArrayList<ItemStack>();
            customInput.addAll(input);
            DyeItem dye = DyeItem.func_195961_a((DyeColor)DyeColor.func_204271_a((String)item.getRegistryName().func_110623_a().replace("_concrete_powder", ""), (DyeColor)DyeColor.WHITE));
            customInput.add(new ItemStack((IItemProvider)dye, 1));
            IRecipeStorage storage = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{customInput, 3, new ItemStack((IItemProvider)item, 8), Blocks.field_150350_a});
            this.addRecipeToList(IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(storage));
            Block block = item instanceof BlockItem ? ((BlockItem)item).func_179223_d() : null;
            if (!(block instanceof ConcretePowderBlock)) continue;
            IRecipeStorage storage2 = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{Collections.singletonList(new ItemStack((IItemProvider)item, 1)), 3, new ItemStack((IItemProvider)((ConcretePowderBlock)block).field_200294_a.func_177230_c(), 1), Blocks.field_150350_a});
            this.addRecipeToList(IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(storage2));
        }
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull World world) {
        if (!blockState.func_204520_s().func_206888_e() && blockState.func_204520_s().func_206886_c() == Fluids.field_207212_b && blockState.func_204520_s().func_206882_g() <= 3) {
            List fluidPos = this.waterPos.getOrDefault(blockState.func_204520_s().func_206882_g(), new ArrayList());
            if (!fluidPos.contains(pos)) {
                fluidPos.add(pos);
            }
            this.waterPos.put(blockState.func_204520_s().func_206882_g(), fluidPos);
        }
        super.registerBlockPosition(blockState, pos, world);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT waterMap = new ListNBT();
        for (Map.Entry<Integer, List<BlockPos>> entry : this.waterPos.entrySet()) {
            CompoundNBT waterCompound = new CompoundNBT();
            waterCompound.func_74768_a("level", entry.getKey().intValue());
            ListNBT waterList = new ListNBT();
            for (BlockPos pos : entry.getValue()) {
                waterList.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
            }
            waterCompound.func_218657_a("Pond", (INBT)waterList);
            waterMap.add((Object)waterCompound);
        }
        compound.func_218657_a("Pond", (INBT)waterMap);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.waterPos.clear();
        ListNBT waterMapList = compound.func_150295_c("Pond", 10);
        for (int i = 0; i < waterMapList.size(); ++i) {
            CompoundNBT waterCompound = waterMapList.func_150305_b(i);
            int level = waterCompound.func_74762_e("level");
            ListNBT waterTagList = waterCompound.func_150295_c("Pond", 10);
            ArrayList<BlockPos> water = new ArrayList<BlockPos>();
            for (int j = 0; j < waterTagList.size(); ++j) {
                CompoundNBT waterSubCompound = waterTagList.func_150305_b(j);
                BlockPos waterPos = NBTUtil.func_186861_c((CompoundNBT)waterSubCompound);
                if (water.contains(waterPos)) continue;
                water.add(waterPos);
            }
            this.waterPos.put(level, water);
        }
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return CONCRETE_MIXER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobConcreteMixer(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return CONCRETE_MIXER;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Stamina;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Dexterity;
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        return false;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.concreteMixer;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Concrete Mixer", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    @Nullable
    public BlockPos getBlockToMine() {
        for (int i = 1; i <= 3; ++i) {
            for (BlockPos pos : this.waterPos.getOrDefault(i, Collections.emptyList())) {
                if (!BlockTags.func_199896_a().func_199915_b(CONCRETE_BLOCK).func_199685_a_((Object)this.colony.getWorld().func_180495_p(pos).func_177230_c())) continue;
                return pos;
            }
        }
        return null;
    }

    @Nullable
    public BlockPos getBlockToPlace() {
        for (int i = 1; i <= 3; ++i) {
            for (BlockPos pos : this.waterPos.getOrDefault(i, Collections.emptyList())) {
                if (this.colony.getWorld().func_180495_p(pos).func_204520_s().func_206888_e() || this.colony.getWorld().func_180495_p(pos).func_185904_a().func_76220_a()) continue;
                return pos;
            }
        }
        return null;
    }

    public int outputBlockCountInWorld(ItemStack primaryOutput) {
        int count = 0;
        if (primaryOutput.func_77973_b() instanceof BlockItem) {
            for (int i = 1; i <= 3; ++i) {
                for (BlockPos pos : this.waterPos.getOrDefault(i, Collections.emptyList())) {
                    if (((BlockItem)primaryOutput.func_77973_b()).func_179223_d() != this.colony.getWorld().func_180495_p(pos).func_177230_c()) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCrafter(this, BuildingConcreteMixer.CONCRETE_MIXER);
        }
    }
}

