/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.client.gui.WindowHutCook;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingSmelterCrafter;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.colony.jobs.JobCook;
import com.minecolonies.coremod.colony.jobs.JobCookAssistant;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PublicWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PublicWorkerCraftingRequestResolver;
import com.minecolonies.coremod.util.FurnaceRecipes;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingCook
extends AbstractBuildingSmelterCrafter {
    private static final String COOK_DESC = "cook";
    private static final int MAX_BUILDING_LEVEL = 5;
    private boolean isCooking = false;
    private ICitizenData assistant = null;
    private int isCookingTimeout = 0;

    public BuildingCook(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(ItemStackUtils.ISFOOD, new Tuple((Object)64, (Object)true));
        this.keepX.put(ItemStackUtils.ISCOOKABLE, new Tuple((Object)64, (Object)true));
        this.keepX.put(stack -> this.isAllowedFuel((ItemStack)stack), new Tuple((Object)64, (Object)true));
        this.keepX.put(stack -> ItemStackUtils.isEmpty(stack.getContainerItem()) == false && !stack.getContainerItem().func_77973_b().equals(Items.field_151133_ar), new Tuple((Object)64, (Object)false));
    }

    public boolean getIsCooking() {
        ICitizenData citizen = this.getAssistant();
        return citizen != null && this.isCooking && this.isCookingTimeout > 0;
    }

    public void setIsCooking(boolean cookingState) {
        this.isCooking = cookingState;
        if (cookingState) {
            this.isCookingTimeout = 75;
        }
    }

    public ICitizenData getAssistant() {
        if (this.getBuildingLevel() < 3) {
            return null;
        }
        if (this.assistant == null) {
            for (ICitizenData citizen : this.getAssignedCitizen()) {
                if (!(citizen.getJob() instanceof JobCookAssistant)) continue;
                this.assistant = citizen;
            }
        }
        return this.assistant;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return COOK_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        for (ICitizenData leadCitizen : this.getAssignedCitizen()) {
            if (!(leadCitizen.getJob() instanceof JobCook)) continue;
            this.assistant = citizen;
            return new JobCookAssistant(citizen);
        }
        return new JobCook(citizen);
    }

    @Override
    public void removeCitizen(ICitizenData citizen) {
        if (citizen.getJob() instanceof JobCookAssistant) {
            this.assistant = null;
        }
        super.removeCitizen(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return COOK_DESC;
    }

    @Override
    public int getMaxInhabitants() {
        if (this.getBuildingLevel() < 3) {
            return 1;
        }
        return 2;
    }

    @Override
    public boolean isRecipeAlterationAllowed() {
        return this.getBuildingLevel() >= 3;
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return true;
    }

    @Override
    public boolean canBeGathered() {
        return super.canBeGathered() && this.getAssignedCitizen().stream().map(c -> c.getJob(AbstractJobCrafter.class)).filter(Objects::nonNull).allMatch(AbstractJobCrafter::hasTask);
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        Collection supers = super.createResolvers().stream().filter(r -> !(r instanceof PrivateWorkerCraftingProductionResolver) && !(r instanceof PrivateWorkerCraftingRequestResolver)).collect(Collectors.toList());
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)supers);
        builder.add((Object)new PublicWorkerCraftingRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        builder.add((Object)new PublicWorkerCraftingProductionResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }

    @Override
    @Nullable
    public IRecipeStorage getFirstRecipe(Predicate<ItemStack> stackPredicate) {
        if (this.getBuildingLevel() < 3 || this.getAssistant() == null) {
            return null;
        }
        IRecipeStorage storage = super.getFirstRecipe(stackPredicate);
        if (storage != null) {
            return storage;
        }
        storage = FurnaceRecipes.getInstance().getFirstSmeltingRecipeByResult(stackPredicate);
        Optional<Boolean> validRecipe = this.canRecipeBeAddedBasedOnTags(storage);
        if (storage != null && ItemStackUtils.ISFOOD.test(storage.getPrimaryOutput().getStack()) && (!validRecipe.isPresent() || validRecipe.get().booleanValue())) {
            return storage;
        }
        return null;
    }

    @Override
    public IRecipeStorage getFirstFullFillableRecipe(Predicate<ItemStack> stackPredicate, int count) {
        List<IItemHandler> handlers;
        IRecipeStorage storage = super.getFirstFullFillableRecipe(stackPredicate, count);
        if (storage == null && (storage = FurnaceRecipes.getInstance().getFirstSmeltingRecipeByResult(stackPredicate)) != null && !storage.canFullFillRecipe(count, (handlers = this.getHandlers()).toArray(new IItemHandler[0]))) {
            return null;
        }
        return storage;
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<ItemStorage, Tuple> recipeOutputs = new HashMap<ItemStorage, Tuple>();
        for (ICitizenData citizen : this.getAssignedCitizen()) {
            if (!(citizen.getJob() instanceof AbstractJobCrafter)) continue;
            List<IToken<?>> assignedTasks = citizen.getJob(AbstractJobCrafter.class).getAssignedTasks();
            for (IToken<?> taskToken : assignedTasks) {
                IRequest<?> request = this.colony.getRequestManager().getRequestForToken(taskToken);
                IRecipeStorage recipeStorage = this.getFirstRecipe(((PublicCrafting)request.getRequest()).getStack());
                if (recipeStorage == null) continue;
                for (ItemStorage itemStorage : recipeStorage.getCleanedInput()) {
                    int amount = itemStorage.getAmount();
                    if (recipeOutputs.containsKey(itemStorage)) {
                        amount = (Integer)((Tuple)recipeOutputs.get(itemStorage)).func_76341_a() + itemStorage.getAmount();
                    }
                    recipeOutputs.put(itemStorage, new Tuple((Object)amount, (Object)false));
                }
                ItemStorage output = new ItemStorage(recipeStorage.getPrimaryOutput());
                if (recipeOutputs.containsKey(output)) {
                    output.setAmount((Integer)((Tuple)recipeOutputs.get(output)).func_76341_a() + output.getAmount());
                }
                recipeOutputs.put(output, new Tuple((Object)output.getAmount(), (Object)false));
            }
        }
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(this.keepX);
        toKeep.putAll(recipeOutputs.entrySet().stream().collect(Collectors.toMap(key -> stack -> stack.func_77969_a(((ItemStorage)key.getKey()).getItemStack()), Map.Entry::getValue)));
        return toKeep;
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        if (this.getBuildingLevel() < 3) {
            return false;
        }
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        Optional<Boolean> isRecipeAllowed = super.canRecipeBeAddedBasedOnTags(token);
        if (isRecipeAllowed.isPresent()) {
            return isRecipeAllowed.get();
        }
        IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
        return ItemStackUtils.CAN_EAT.test(storage.getPrimaryOutput()) || ItemStackUtils.CAN_EAT.test(FurnaceRecipes.getInstance().getSmeltingResult(storage.getPrimaryOutput()));
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Adaptability;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Knowledge;
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return true;
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (inventory && this.minimumStock.containsKey(new ItemStorage(stack))) {
            return stack.func_190916_E();
        }
        if (ItemStackUtils.ISFOOD.test(stack) && (localAlreadyKept.stream().filter(storage -> ItemStackUtils.ISFOOD.test(storage.getItemStack())).mapToInt(ItemStorage::getAmount).sum() < 64 || !inventory)) {
            ItemStorage kept = new ItemStorage(stack);
            if (localAlreadyKept.contains(kept)) {
                kept.setAmount(localAlreadyKept.remove(localAlreadyKept.indexOf(kept)).getAmount());
            }
            localAlreadyKept.add(kept);
            return 0;
        }
        Predicate<ItemStack> allowedFuel = theStack -> this.getAllowedFuel().stream().anyMatch(fuelStack -> fuelStack.func_77969_a(theStack));
        if (allowedFuel.test(stack) && (localAlreadyKept.stream().filter(storage -> allowedFuel.test(storage.getItemStack())).mapToInt(ItemStorage::getAmount).sum() < 64 || !inventory)) {
            ItemStorage kept = new ItemStorage(stack);
            if (localAlreadyKept.contains(kept)) {
                kept.setAmount(localAlreadyKept.remove(localAlreadyKept.indexOf(kept)).getAmount());
            }
            localAlreadyKept.add(kept);
            return 0;
        }
        return super.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, inventory);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.cook;
    }

    @Override
    public void onColonyTick(IColony colony) {
        super.onColonyTick(colony);
        if (this.isCookingTimeout > 0) {
            --this.isCookingTimeout;
        }
    }

    @Override
    public void openCraftingContainer(ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Crafting GUI");
            }

            @NotNull
            public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
                PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
                buffer.writeBoolean(BuildingCook.this.canCraftComplexRecipes());
                buffer.func_179255_a(BuildingCook.this.getID());
                return new ContainerCrafting(id, inv, buffer);
            }
        }, buffer -> new PacketBuffer(buffer.writeBoolean(this.canCraftComplexRecipes())).func_179255_a(this.getID()));
    }

    public static class View
    extends AbstractFilterableListsView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCook(this);
        }
    }
}

