/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowHutCowboy;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingHerder;
import com.minecolonies.coremod.colony.jobs.JobCowboy;
import com.minecolonies.coremod.network.messages.server.colony.building.cowboy.CowboySetMilkCowsMessage;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingCowboy
extends AbstractBuildingHerder {
    private static final String COWBOY = "cowboy";
    private static final int MAX_BUILDING_LEVEL = 5;
    private boolean milkCows = true;

    public BuildingCowboy(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return COWBOY;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return COWBOY;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Athletics;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Stamina;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobCowboy(citizen);
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.milkCows);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.cowboy;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.milkCows = compound.func_74767_n("MILK_COWS");
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74757_a("MILK_COWS", this.milkCows);
        return compound;
    }

    public boolean isMilkingCows() {
        return this.milkCows;
    }

    public void setMilkCows(boolean milkCows) {
        this.milkCows = milkCows;
        this.markDirty();
    }

    @Override
    public boolean canEat(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151015_O) {
            return false;
        }
        return super.canEat(stack);
    }

    public static class View
    extends AbstractBuildingHerder.View {
        private boolean milkCows = true;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCowboy(this);
        }

        public void setMilkCows(boolean milkCows) {
            Network.getNetwork().sendToServer(new CowboySetMilkCowsMessage(this, milkCows));
            this.milkCows = milkCows;
        }

        public boolean isMilkCows() {
            return this.milkCows;
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
            this.milkCows = buf.readBoolean();
        }
    }
}

