/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingDeliveryman;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Delivery;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.IDeliverymanRequestable;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.client.gui.WindowHutDeliveryman;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.colony.requestsystem.resolvers.DeliveryRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PickupRequestResolver;
import java.util.Optional;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingDeliveryman
extends AbstractBuildingWorker
implements IBuildingDeliveryman {
    private static final String DELIVERYMAN = "deliveryman";

    public BuildingDeliveryman(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return DELIVERYMAN;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        ImmutableCollection<IRequestResolver<?>> supers = super.createResolvers();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(supers);
        builder.add((Object)new DeliveryRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        builder.add((Object)new PickupRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.deliveryman;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobDeliveryman(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return DELIVERYMAN;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Agility;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Adaptability;
    }

    @Override
    public void removeCitizen(ICitizenData citizen) {
        if (citizen != null) {
            Optional<AbstractEntityCitizen> optCitizen = citizen.getEntity();
            optCitizen.ifPresent(entityCitizen -> entityCitizen.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3));
        }
        super.removeCitizen(citizen);
    }

    @Override
    public boolean canEat(ItemStack stack) {
        ICitizenData citizenData = this.getMainCitizen();
        if (citizenData != null) {
            JobDeliveryman job = (JobDeliveryman)citizenData.getJob();
            IRequest<IDeliverymanRequestable> currentTask = job.getCurrentTask();
            if (currentTask == null) {
                return super.canEat(stack);
            }
            IDeliverymanRequestable request = currentTask.getRequest();
            if (request instanceof Delivery && ((Delivery)request).getStack().func_77969_a(stack)) {
                return false;
            }
        }
        return super.canEat(stack);
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutDeliveryman(this);
        }
    }
}

