/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.coremod.client.gui.WindowHutFlorist;
import com.minecolonies.coremod.colony.buildings.AbstractFilterableListBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import com.minecolonies.coremod.colony.jobs.JobFlorist;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingFlorist
extends AbstractFilterableListBuilding {
    private static final String FLORIST = "florist";
    private static final int MAX_BUILDING_LEVEL = 5;
    private final List<BlockPos> plantGround = new ArrayList<BlockPos>();

    public BuildingFlorist(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> stack.func_77973_b() == ModItems.compost, new Tuple((Object)64, (Object)true));
    }

    public List<BlockPos> getPlantGround() {
        return ImmutableList.copyOf(this.plantGround);
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobFlorist(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return FLORIST;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Dexterity;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Agility;
    }

    @Override
    public String getSchematicName() {
        return FLORIST;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block == ModBlocks.blockCompostedDirt && !this.plantGround.contains(pos)) {
            this.plantGround.add(pos);
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT compostBinTagList = compound.func_150295_c("plantGround", 10);
        for (int i = 0; i < compostBinTagList.size(); ++i) {
            this.plantGround.add(NBTUtil.func_186861_c((CompoundNBT)compostBinTagList.func_150305_b(i).func_74775_l("pos")));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT compostBinTagList = new ListNBT();
        for (BlockPos entry : this.plantGround) {
            CompoundNBT compostBinCompound = new CompoundNBT();
            compostBinCompound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)entry));
            compostBinTagList.add((Object)compostBinCompound);
        }
        compound.func_218657_a("plantGround", (INBT)compostBinTagList);
        return compound;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.florist;
    }

    public void removePlantableGround(BlockPos pos) {
        this.plantGround.remove(pos);
    }

    @Nullable
    public ItemStack getFlowerToGrow() {
        List stacks = BuildingFlorist.getPlantablesForBuildingLevel(this.getBuildingLevel()).stream().filter(stack -> !this.isAllowedItem("flowers", (ItemStorage)stack)).collect(Collectors.toList());
        if (stacks.isEmpty()) {
            return null;
        }
        Collections.shuffle(stacks);
        return ((ItemStorage)stacks.get(0)).getItemStack();
    }

    public static List<ItemStorage> getPlantablesForBuildingLevel(int level) {
        switch (level) {
            case 0: 
            case 1: {
                return IColonyManager.getInstance().getCompatibilityManager().getCopyOfPlantables().stream().filter(storage -> storage.getItem() == Items.field_221620_aV || storage.getItem() == Items.field_221619_aU).filter(itemStorage -> itemStorage.getItem().func_206844_a(ItemTags.field_219770_E)).collect(Collectors.toList());
            }
            case 2: {
                return IColonyManager.getInstance().getCompatibilityManager().getCopyOfPlantables().stream().filter(itemStorage -> itemStorage.getItem().func_206844_a(ItemTags.field_219770_E)).collect(Collectors.toList());
            }
        }
        return IColonyManager.getInstance().getCompatibilityManager().getCopyOfPlantables();
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Florist", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    public static class View
    extends AbstractFilterableListsView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutFlorist(this);
        }
    }
}

