/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingGuardTower
extends AbstractBuildingGuards {
    private static final String SCHEMATIC_NAME = "guardtower";
    private static final int DEFENCE_BONUS = 5;
    private static final int OFFENCE_BONUS = 0;
    private static final int MAX_LEVEL = 5;
    private static final int BONUS_HP_SINGLE_GUARD = 20;

    public BuildingGuardTower(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public int getDefenceBonus() {
        return 5;
    }

    @Override
    public int getOffenceBonus() {
        return 0;
    }

    @Override
    public String getSchematicName() {
        return SCHEMATIC_NAME;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public int getClaimRadius(int newLevel) {
        switch (newLevel) {
            case 1: {
                return 2;
            }
            case 2: 
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public void onDestroyed() {
        super.onDestroyed();
        this.colony.getBuildingManager().guardBuildingChangedAt(this, 0);
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        this.colony.getBuildingManager().guardBuildingChangedAt(this, newLevel);
    }

    @Override
    public boolean requiresManualTarget() {
        return (!this.patrolManually || this.patrolTargets == null || this.patrolTargets.isEmpty() || this.tempNextPatrolPoint != null) && this.tempNextPatrolPoint == null;
    }

    @Override
    protected int getBonusHealth() {
        return 20 + super.getBonusHealth();
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.guardTower;
    }

    public static class View
    extends AbstractBuildingGuards.View {
        public View(IColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }
    }
}

