/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingBedProvider;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.client.gui.WindowHutCitizen;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.colonyEvents.citizenEvents.CitizenBornEvent;
import com.minecolonies.coremod.util.AdvancementUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingHome
extends AbstractBuilding
implements IBuildingBedProvider {
    private static final String CITIZEN = "citizen";
    @NotNull
    private final List<BlockPos> bedList = new ArrayList<BlockPos>();
    private boolean femalePresent = false;
    private boolean malePresent = false;
    private static final int MIN_TIME_BEFORE_SPAWNTRY = 300;
    private static final int CHILD_SPAWN_INTERVAL = 1200;
    private int childCreationTimer;

    public BuildingHome(IColony c, BlockPos l) {
        super(c, l);
        Random rand = new Random();
        this.childCreationTimer = rand.nextInt(1200) + 300;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_150296_c().contains("residents")) {
            int[] residentIds;
            for (int citizenId : residentIds = compound.func_74759_k("residents")) {
                ICitizenData citizen = this.getColony().getCitizenManager().getCivilian(citizenId);
                if (citizen == null) continue;
                this.assignCitizen(citizen);
            }
        }
        ListNBT bedTagList = compound.func_150295_c("beds", 10);
        for (int i = 0; i < bedTagList.size(); ++i) {
            CompoundNBT bedCompound = bedTagList.func_150305_b(i);
            BlockPos bedPos = NBTUtil.func_186861_c((CompoundNBT)bedCompound);
            if (this.bedList.contains(bedPos)) continue;
            this.bedList.add(bedPos);
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        if (this.hasAssignedCitizen()) {
            int[] residentIds = new int[this.getAssignedCitizen().size()];
            for (int i = 0; i < this.getAssignedCitizen().size(); ++i) {
                residentIds[i] = this.getAssignedCitizen().get(i).getId();
            }
            compound.func_74783_a("residents", residentIds);
        }
        if (!this.bedList.isEmpty()) {
            ListNBT bedTagList = new ListNBT();
            for (BlockPos pos : this.bedList) {
                bedTagList.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
            }
            compound.func_218657_a("beds", (INBT)bedTagList);
        }
        return compound;
    }

    @Override
    public void onWakeUp() {
        World world = this.getColony().getWorld();
        if (world == null) {
            return;
        }
        for (BlockPos pos : this.bedList) {
            BlockState state = world.func_180495_p(pos);
            if (!((state = state.func_177230_c().getExtendedState(state, (IBlockReader)world, pos)).func_177230_c() instanceof BedBlock) || !((Boolean)state.func_177229_b((IProperty)BedBlock.field_176471_b)).booleanValue() || !((BedPart)state.func_177229_b((IProperty)BedBlock.field_176472_a)).equals((Object)BedPart.HEAD)) continue;
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BedBlock.field_176471_b, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return CITIZEN;
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(blockState, pos, world);
        BlockPos registrationPosition = pos;
        if (blockState.func_177230_c() instanceof BedBlock) {
            if (blockState.func_177229_b((IProperty)BedBlock.field_176472_a) == BedPart.FOOT) {
                registrationPosition = registrationPosition.func_177972_a((Direction)blockState.func_177229_b((IProperty)BedBlock.field_185512_D));
            }
            if (!this.bedList.contains(registrationPosition)) {
                this.bedList.add(registrationPosition);
            }
        }
    }

    @Override
    public void onDestroyed() {
        super.onDestroyed();
        this.getAssignedCitizen().stream().filter(Objects::nonNull).forEach(citizen -> citizen.setHomeBuilding(null));
    }

    @Override
    public void removeCitizen(@NotNull ICitizenData citizen) {
        if (this.isCitizenAssigned(citizen)) {
            super.removeCitizen(citizen);
            citizen.setHomeBuilding(null);
            this.femalePresent = false;
            this.malePresent = false;
            for (ICitizenData citizenData : this.getAssignedCitizen()) {
                if (citizenData.isFemale()) {
                    this.femalePresent = true;
                } else {
                    this.malePresent = true;
                }
                if (!this.femalePresent || !this.malePresent) continue;
                return;
            }
        }
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (this.getBuildingLevel() > 0 && (this.childCreationTimer -= 25) <= 0) {
            this.childCreationTimer = (int)((double)colony.getWorld().field_73012_v.nextInt(500) + 1200.0 * (1.0 - (double)(colony.getCitizenManager().getCurrentCitizenCount() / Math.max(4, colony.getCitizenManager().getMaxCitizens()))));
            this.trySpawnChild();
        }
        if (this.getAssignedCitizen().size() < this.getMaxInhabitants() && !this.getColony().isManualHousing()) {
            this.addHomelessCitizens();
        }
    }

    public void trySpawnChild() {
        if (this.colony.canMoveIn() && this.femalePresent && this.malePresent && this.colony.getCitizenManager().getCurrentCitizenCount() < this.colony.getCitizenManager().getMaxCitizens()) {
            ICitizenData mom = null;
            ICitizenData dad = null;
            for (ICitizenData data : this.getAssignedCitizen()) {
                if (data.isFemale() && !data.isChild()) {
                    mom = data;
                } else if (!data.isChild()) {
                    dad = data;
                }
                if (mom == null || dad == null) continue;
                break;
            }
            if (mom == null || dad == null) {
                return;
            }
            ICitizenData newCitizen = this.colony.getCitizenManager().createAndRegisterCivilianData();
            Random rand = new Random();
            newCitizen.getCitizenSkillHandler().init(mom, dad, rand);
            newCitizen.setIsChild(true);
            if (this.assignCitizen(newCitizen)) {
                if (rand.nextInt(2) == 1) {
                    this.inheritLastName(newCitizen, mom.getName());
                } else {
                    this.inheritLastName(newCitizen, dad.getName());
                }
            } else {
                block1: for (IBuilding build : this.colony.getBuildingManager().getBuildings().values()) {
                    if (!(build instanceof BuildingHome) || !build.assignCitizen(newCitizen)) continue;
                    for (ICitizenData data : build.getAssignedCitizen()) {
                        if (data.getId() == newCitizen.getId()) continue;
                        this.inheritLastName(newCitizen, data.getName());
                        break block1;
                    }
                }
            }
            ArrayList<String> possibleSuffixes = new ArrayList<String>();
            possibleSuffixes.add(mom.getTextureSuffix());
            possibleSuffixes.add(dad.getTextureSuffix());
            if (possibleSuffixes.contains("_w") && possibleSuffixes.contains("_d")) {
                possibleSuffixes.add("_b");
            }
            newCitizen.setSuffix((String)possibleSuffixes.get(rand.nextInt(possibleSuffixes.size())));
            int populationCount = this.colony.getCitizenManager().getCurrentCitizenCount();
            AdvancementUtils.TriggerAdvancementPlayersForColony(this.colony, playerMP -> AdvancementTriggers.COLONY_POPULATION.trigger((ServerPlayerEntity)playerMP, populationCount));
            LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.progress.newChild", (Object[])new Object[0]);
            this.colony.getCitizenManager().spawnOrCreateCitizen(newCitizen, this.colony.getWorld(), this.getPosition());
            this.colony.getEventDescriptionManager().addEventDescription(new CitizenBornEvent(this.getPosition(), newCitizen.getName()));
        }
    }

    private void inheritLastName(@NotNull ICitizenData child, String parentName) {
        if (parentName == null || parentName.split(" ").length < 2 || child.getName().split(" ").length < 2) {
            return;
        }
        String[] newName = child.getName().split(" ");
        String[] lastName = parentName.split(" ");
        newName[newName.length - 1] = lastName[lastName.length - 1];
        StringBuilder combinedName = new StringBuilder();
        for (String namePart : newName) {
            combinedName.append(namePart).append(" ");
        }
        child.setName(combinedName.toString().trim());
    }

    @Override
    public int getMaxInhabitants() {
        return this.getBuildingLevel();
    }

    private void addHomelessCitizens() {
        for (ICitizenData citizen : this.getColony().getCitizenManager().getCitizens()) {
            if (this.isFull()) break;
            if (this.femalePresent && citizen.isFemale() || this.malePresent && !citizen.isFemale()) continue;
            this.moveCitizenToHut(citizen);
        }
        for (ICitizenData citizen : this.getColony().getCitizenManager().getCitizens()) {
            if (this.isFull()) break;
            this.moveCitizenToHut(citizen);
        }
    }

    private void moveCitizenToHut(ICitizenData citizen) {
        if (citizen.getHomeBuilding() instanceof BuildingHome && citizen.getHomeBuilding().getBuildingLevel() < this.getBuildingLevel()) {
            citizen.getHomeBuilding().removeCitizen(citizen);
        }
        if (citizen.getHomeBuilding() == null) {
            this.assignCitizen(citizen);
        }
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (citizen.getHomeBuilding() != null) {
            citizen.getHomeBuilding().removeCitizen(citizen);
        }
        if (!super.assignCitizen(citizen)) {
            return false;
        }
        if (citizen.isFemale()) {
            this.femalePresent = true;
        } else {
            this.malePresent = true;
        }
        citizen.setHomeBuilding(this);
        return true;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        for (Optional<AbstractEntityCitizen> entityCitizen : Objects.requireNonNull(this.getAssignedEntities())) {
            if (!entityCitizen.isPresent() || entityCitizen.get().getCitizenJobHandler().getColonyJob() != null) continue;
            entityCitizen.get().getCitizenJobHandler().setModelDependingOnJob(null);
        }
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.home;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeInt(this.getAssignedCitizen().size());
        for (ICitizenData citizen : this.getAssignedCitizen()) {
            buf.writeInt(citizen.getId());
        }
    }

    @Override
    public void setBuildingLevel(int level) {
        super.setBuildingLevel(level);
        this.getColony().getCitizenManager().calculateMaxCitizens();
    }

    @Override
    @NotNull
    public List<BlockPos> getBedList() {
        return new ArrayList<BlockPos>(this.bedList);
    }

    @Override
    public void onBuildingMove(IBuilding oldBuilding) {
        super.onBuildingMove(oldBuilding);
        List<ICitizenData> residents = oldBuilding.getAssignedCitizen();
        for (ICitizenData citizen : residents) {
            citizen.setHomeBuilding(this);
            this.assignCitizen(citizen);
        }
    }

    public static class View
    extends AbstractBuildingView {
        @NotNull
        private final List<Integer> residents = new ArrayList<Integer>();

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @NotNull
        public List<Integer> getResidents() {
            return Collections.unmodifiableList(this.residents);
        }

        public void removeResident(int index) {
            this.residents.remove(index);
        }

        public void addResident(int id) {
            this.residents.add(id);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCitizen(this);
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
            this.residents.clear();
            int numResidents = buf.readInt();
            for (int i = 0; i < numResidents; ++i) {
                this.residents.add(buf.readInt());
            }
        }
    }
}

