/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.client.gui.WindowHutMiner;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingBuilderView;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildMiner;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingMiner
extends AbstractBuildingStructureBuilder {
    private static final String MINER = "miner";
    @NotNull
    private final List<Level> levels = new ArrayList<Level>();
    private boolean clearedShaft = false;
    private int startingLevelShaft = 0;
    private BlockPos cobbleLocation;
    private int startingLevelNode = 0;
    private int currentLevel = 0;
    private BlockPos shaftStart;
    private int vectorX = 1;
    private int vectorZ = 1;
    private BlockPos ladderLocation;
    private boolean foundLadder = false;
    @Nullable
    private Node activeNode = null;
    @Nullable
    private Node oldNode = null;

    public BuildingMiner(IColony c, BlockPos l) {
        super(c, l);
        ItemStack stackLadder = new ItemStack((IItemProvider)Blocks.field_150468_ap);
        ItemStack stackFence = new ItemStack((IItemProvider)Blocks.field_180407_aO);
        ItemStack stackTorch = new ItemStack((IItemProvider)Blocks.field_150478_aa);
        ItemStack stackCobble = new ItemStack((IItemProvider)Blocks.field_150347_e);
        ItemStack stackDirt = new ItemStack((IItemProvider)Blocks.field_150346_d);
        this.keepX.put(arg_0 -> ((ItemStack)stackLadder).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackFence).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackTorch).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackCobble).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(stack -> stack.func_77973_b().func_206844_a(ItemTags.field_203442_w), new Tuple((Object)64, (Object)true));
        this.keepX.put(stack -> stack.func_77973_b().func_206844_a(ItemTags.field_199905_b), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackDirt).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.PICKAXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHOVEL, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return MINER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public int getResourceBatchMultiplier() {
        return 10;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.miner;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobMiner(citizen);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.startingLevelShaft = compound.func_74762_e("newStartingLevelShaft");
        this.clearedShaft = compound.func_74767_n("clearedShaft");
        this.vectorX = compound.func_74762_e("vectorx");
        this.vectorZ = compound.func_74762_e("vectorz");
        if (compound.func_150296_c().contains("activeNodeNode")) {
            this.activeNode = Node.createFromNBT(compound.func_74775_l("activeNodeNode"));
        } else if (compound.func_150296_c().contains("oldNodeNode")) {
            this.oldNode = Node.createFromNBT(compound.func_74775_l("oldNodeNode"));
        }
        this.currentLevel = compound.func_74762_e("currentLevel");
        this.ladderLocation = BlockPosUtil.read(compound, "ladderlocation");
        this.foundLadder = compound.func_74767_n("found_ladder");
        this.shaftStart = BlockPosUtil.read(compound, "shaftLocation");
        this.cobbleLocation = BlockPosUtil.read(compound, "cobblelocation");
        this.startingLevelNode = compound.func_74762_e("StartingNode");
        ListNBT levelTagList = compound.func_150295_c("levels", 10);
        for (int i = 0; i < levelTagList.size(); ++i) {
            this.levels.add(new Level(levelTagList.func_150305_b(i)));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nodeCompound;
        CompoundNBT compound = super.serializeNBT();
        compound.func_74768_a("newStartingLevelShaft", this.startingLevelShaft);
        compound.func_74757_a("clearedShaft", this.clearedShaft);
        compound.func_74768_a("vectorx", this.vectorX);
        compound.func_74768_a("vectorz", this.vectorZ);
        if (this.activeNode != null) {
            nodeCompound = new CompoundNBT();
            this.activeNode.write(nodeCompound);
            compound.func_218657_a("activeNodeNode", (INBT)nodeCompound);
        }
        if (this.oldNode != null) {
            nodeCompound = new CompoundNBT();
            this.oldNode.write(nodeCompound);
            compound.func_218657_a("oldNodeNode", (INBT)nodeCompound);
        }
        compound.func_74768_a("currentLevel", this.currentLevel);
        compound.func_74757_a("found_ladder", this.foundLadder);
        compound.func_74768_a("StartingNode", this.startingLevelNode);
        if (this.shaftStart != null && this.cobbleLocation != null) {
            BlockPosUtil.write(compound, "shaftLocation", this.shaftStart);
            BlockPosUtil.write(compound, "cobblelocation", this.cobbleLocation);
        }
        if (this.ladderLocation != null) {
            BlockPosUtil.write(compound, "ladderlocation", this.ladderLocation);
        }
        ListNBT levelTagList = new ListNBT();
        for (Level level : this.levels) {
            CompoundNBT levelCompound = new CompoundNBT();
            level.write(levelCompound);
            levelTagList.add((Object)levelCompound);
        }
        compound.func_218657_a("levels", (INBT)levelTagList);
        return compound;
    }

    @Override
    @NotNull
    public String getJobName() {
        return MINER;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Strength;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Stamina;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeInt(this.currentLevel);
        buf.writeInt(this.levels.size());
        for (Level level : this.levels) {
            buf.writeInt(level.getNumberOfBuiltNodes());
            buf.writeInt(level.getDepth());
        }
    }

    public void addLevel(Level currentLevel) {
        this.levels.add(currentLevel);
    }

    public int getNumberOfLevels() {
        return this.levels.size();
    }

    @Nullable
    public Level getCurrentLevel() {
        if (this.currentLevel >= 0 && this.currentLevel < this.levels.size()) {
            return this.levels.get(this.currentLevel);
        }
        return null;
    }

    public int getLevelId(Level level) {
        return this.levels.indexOf(level);
    }

    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
        this.activeNode = null;
        this.oldNode = null;
    }

    public int getDepthLimit() {
        if (this.getBuildingLevel() == 1) {
            return 50;
        }
        if (this.getBuildingLevel() == 2) {
            return 30;
        }
        if (this.getBuildingLevel() >= 3) {
            return 5;
        }
        return 70;
    }

    public BlockPos getLadderLocation() {
        return this.ladderLocation;
    }

    public void setLadderLocation(BlockPos ladderLocation) {
        this.ladderLocation = ladderLocation;
    }

    public boolean hasFoundLadder() {
        return this.foundLadder;
    }

    public void setFoundLadder(boolean foundLadder) {
        this.foundLadder = foundLadder;
    }

    public int getVectorX() {
        return this.vectorX;
    }

    public void setVectorX(int vectorX) {
        this.vectorX = vectorX;
    }

    public int getVectorZ() {
        return this.vectorZ;
    }

    public void setVectorZ(int vectorZ) {
        this.vectorZ = vectorZ;
    }

    public BlockPos getCobbleLocation() {
        return this.cobbleLocation;
    }

    public void setCobbleLocation(BlockPos pos) {
        this.cobbleLocation = pos;
    }

    public void setShaftStart(BlockPos pos) {
        this.shaftStart = pos;
    }

    public int getStartingLevelShaft() {
        if (this.levels.isEmpty()) {
            return this.startingLevelShaft;
        }
        return this.levels.get(this.levels.size() - 1).getDepth() - 6;
    }

    public void setStartingLevelShaft(int level) {
        this.startingLevelShaft = level;
    }

    public boolean hasClearedShaft() {
        return this.clearedShaft;
    }

    public void setClearedShaft(boolean clearedShaft) {
        this.clearedShaft = clearedShaft;
    }

    @NotNull
    public Node getActiveNode() {
        Node calcNode;
        Node node = calcNode = this.activeNode == null || this.activeNode.getStatus() == Node.NodeStatus.COMPLETED ? this.levels.get(this.currentLevel).getRandomNode(this.oldNode) : this.activeNode;
        if (this.activeNode != calcNode) {
            this.activeNode = calcNode;
        }
        return this.activeNode;
    }

    public void setActiveNode(Node activeNode) {
        this.activeNode = activeNode;
    }

    public Node getOldNode() {
        return this.oldNode;
    }

    public void setOldNode(Node oldNode) {
        this.oldNode = oldNode;
    }

    @Override
    public void searchWorkOrder() {
        ICitizenData citizen = this.getMainCitizen();
        if (citizen == null) {
            return;
        }
        List<WorkOrderBuildMiner> list = this.getColony().getWorkManager().getOrderedList(WorkOrderBuildMiner.class, this.getPosition());
        for (WorkOrderBuildMiner wo : list) {
            if (!this.getID().equals((Object)wo.getMinerBuilding())) continue;
            citizen.getJob(JobMiner.class).setWorkOrder(wo);
            wo.setClaimedBy(citizen);
            return;
        }
    }

    public static class View
    extends AbstractBuildingBuilderView {
        public List<Tuple<Integer, Integer>> levelsInfo;
        public int current;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutMiner(this);
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
            this.current = buf.readInt();
            int size = buf.readInt();
            this.levelsInfo = new ArrayList<Tuple<Integer, Integer>>(size);
            for (int i = 0; i < size; ++i) {
                this.levelsInfo.add(i, (Tuple<Integer, Integer>)new Tuple((Object)buf.readInt(), (Object)buf.readInt()));
            }
        }
    }
}

