/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.client.gui.WindowHutSchool;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.JobPupil;
import com.minecolonies.coremod.colony.jobs.JobTeacher;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.CarpetBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingSchool
extends AbstractBuildingWorker {
    private static final String SCHOOL = "school";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_CARPET = "carpet";
    private boolean hasTeacher = false;
    @NotNull
    private final List<BlockPos> carpet = new ArrayList<BlockPos>();
    private final Random random = new Random();

    public BuildingSchool(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SCHOOL;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return "com.minecolonies.coremod.job.pupil";
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return true;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Knowledge;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Mana;
    }

    @Override
    public int getMaxInhabitants() {
        return 1 + 2 * this.getBuildingLevel();
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (citizen.isChild() || citizen.getJob() instanceof JobPupil) {
            if (this.getAssignedCitizen().size() + 1 >= this.getMaxInhabitants() && !this.hasTeacher) {
                return false;
            }
            return super.assignCitizen(citizen);
        }
        if (this.hasTeacher) {
            return false;
        }
        if (super.assignCitizen(citizen)) {
            this.markDirty();
            this.hasTeacher = true;
            return true;
        }
        return false;
    }

    @Override
    public void removeCitizen(ICitizenData citizen) {
        if (citizen.getJob() instanceof JobTeacher) {
            this.hasTeacher = false;
            this.markDirty();
        }
        super.removeCitizen(citizen);
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        if (citizen.isChild()) {
            return new JobPupil(citizen);
        }
        return new JobTeacher(citizen);
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block instanceof CarpetBlock) {
            this.carpet.add(pos);
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT carpetTagList = compound.func_150295_c(TAG_CARPET, 10);
        for (int i = 0; i < carpetTagList.size(); ++i) {
            CompoundNBT bedCompound = carpetTagList.func_150305_b(i);
            BlockPos pos = BlockPosUtil.read(bedCompound, "pos");
            if (this.carpet.contains(pos)) continue;
            this.carpet.add(pos);
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        if (!this.carpet.isEmpty()) {
            ListNBT carpetTagList = new ListNBT();
            for (BlockPos pos : this.carpet) {
                CompoundNBT carpetCompound = new CompoundNBT();
                BlockPosUtil.write(carpetCompound, "pos", pos);
                carpetTagList.add((Object)carpetCompound);
            }
            compound.func_218657_a(TAG_CARPET, (INBT)carpetTagList);
        }
        return compound;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.school;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.hasTeacher);
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (!this.isFull() && this.getBuildingLevel() > 0 && this.isBuilt() && (this.getHiringMode() == HiringMode.DEFAULT && !this.getColony().isManualHiring() || this.getHiringMode() == HiringMode.AUTO)) {
            for (ICitizenData data : colony.getCitizenManager().getCitizens()) {
                if (data.getWorkBuilding() != null) continue;
                this.assignCitizen(data);
            }
        }
        for (ICitizenData citizenData : this.getAssignedCitizen()) {
            if (!(citizenData.getJob() instanceof JobPupil) || citizenData.isChild()) continue;
            this.removeCitizen(citizenData);
        }
    }

    @Nullable
    public BlockPos getRandomPlaceToSit() {
        if (this.carpet.isEmpty()) {
            return null;
        }
        BlockPos returnPos = this.carpet.get(this.random.nextInt(this.carpet.size()));
        if (this.colony.getWorld().func_180495_p(returnPos).func_177230_c() instanceof CarpetBlock) {
            return returnPos;
        }
        this.carpet.remove(returnPos);
        return null;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("School", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public boolean hasTeacher;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutSchool(this, BuildingSchool.SCHOOL);
        }

        @Override
        public boolean canAssign(ICitizenDataView citizenDataView) {
            if (citizenDataView.isChild()) {
                return super.canAssign(citizenDataView);
            }
            return !this.hasTeacher;
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
            this.hasTeacher = buf.readBoolean();
        }
    }
}

