/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowHutSifter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.JobSifter;
import com.minecolonies.coremod.network.messages.server.colony.building.sifter.SifterSettingsMessage;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class BuildingSifter
extends AbstractBuildingWorker {
    private static final double BUILDING_LEVEL_MULTIPLIER = 64.0;
    private static final String SIFTER_DESC = "sifter";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_MESH = "mesh";
    private static final String TAG_MESH_PROB = "meshProb";
    private int dailyQuantity = 0;
    private int currentDailyQuantity = 0;
    private ItemStorage sievableBlock = null;
    private Tuple<ItemStorage, Double> sifterMesh = null;

    public BuildingSifter(IColony c, BlockPos l) {
        super(c, l);
        if (!IColonyManager.getInstance().getCompatibilityManager().getSievableBlock().isEmpty()) {
            this.sievableBlock = IColonyManager.getInstance().getCompatibilityManager().getSievableBlock().get(0);
        }
        if (!IColonyManager.getInstance().getCompatibilityManager().getMeshes().isEmpty()) {
            this.sifterMesh = IColonyManager.getInstance().getCompatibilityManager().getMeshes().get(0);
        }
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SIFTER_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobSifter(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return SIFTER_DESC;
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return false;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Focus;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Strength;
    }

    public int getDailyQuantity() {
        return this.dailyQuantity;
    }

    public ItemStorage getSievableBlock() {
        return this.sievableBlock;
    }

    public Tuple<ItemStorage, Double> getMesh() {
        return this.sifterMesh;
    }

    public void setCurrentDailyQuantity(int currentDailyQuantity) {
        this.currentDailyQuantity = currentDailyQuantity;
    }

    public int getMaxDailyQuantity() {
        if (this.getBuildingLevel() >= 5) {
            return Integer.MAX_VALUE;
        }
        return (int)(Math.pow(this.getBuildingLevel(), 2.0) * 64.0);
    }

    public void resetMesh() {
        if (!IColonyManager.getInstance().getCompatibilityManager().getMeshes().isEmpty()) {
            this.sifterMesh = IColonyManager.getInstance().getCompatibilityManager().getMeshes().get(0);
        }
    }

    public void setup(ItemStorage block, ItemStorage mesh, int quantity) {
        this.sievableBlock = block;
        for (Tuple<ItemStorage, Double> tuple : IColonyManager.getInstance().getCompatibilityManager().getMeshes()) {
            if (!tuple.getA().equals(mesh)) continue;
            this.sifterMesh = new Tuple<ItemStorage, Double>(mesh, tuple.getB());
            break;
        }
        this.dailyQuantity = quantity;
        this.markDirty();
    }

    @Override
    public void onWakeUp() {
        super.onWakeUp();
        this.currentDailyQuantity = 0;
    }

    public int getCurrentDailyQuantity() {
        return this.currentDailyQuantity;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.dailyQuantity = compound.func_74762_e("daily");
        this.currentDailyQuantity = compound.func_74762_e("currentDaily");
        this.sievableBlock = new ItemStorage(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("block")));
        ItemStorage mesh = new ItemStorage(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l(TAG_MESH)));
        double prob = compound.func_74769_h(TAG_MESH_PROB);
        this.sifterMesh = new Tuple<ItemStorage, Double>(mesh, prob);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74768_a("daily", this.dailyQuantity);
        compound.func_74768_a("currentDaily", this.currentDailyQuantity);
        CompoundNBT sievableBlockTAG = new CompoundNBT();
        this.sievableBlock.getItemStack().func_77955_b(sievableBlockTAG);
        compound.func_218657_a("block", (INBT)sievableBlockTAG);
        CompoundNBT meshTAG = new CompoundNBT();
        this.sifterMesh.getA().getItemStack().func_77955_b(meshTAG);
        compound.func_218657_a(TAG_MESH, (INBT)meshTAG);
        compound.func_74780_a(TAG_MESH_PROB, this.sifterMesh.getB().doubleValue());
        return compound;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeInt(this.dailyQuantity);
        buf.func_150788_a(this.sievableBlock.getItemStack());
        buf.func_150788_a(this.sifterMesh.getA().getItemStack());
        buf.writeInt(IColonyManager.getInstance().getCompatibilityManager().getSievableBlock().size());
        for (ItemStorage itemStorage : IColonyManager.getInstance().getCompatibilityManager().getSievableBlock()) {
            buf.func_150788_a(itemStorage.getItemStack());
        }
        buf.writeInt(IColonyManager.getInstance().getCompatibilityManager().getMeshes().size());
        for (Tuple tuple : IColonyManager.getInstance().getCompatibilityManager().getMeshes()) {
            buf.func_150788_a(((ItemStorage)tuple.getA()).getItemStack());
        }
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.sifter;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Sifter", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        private int dailyQuantity = 0;
        private ItemStorage sifterBlock;
        private ItemStorage mesh;
        private List<ItemStorage> sievableBlocks = new ArrayList<ItemStorage>();
        private List<ItemStorage> meshes = new ArrayList<ItemStorage>();

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
            this.dailyQuantity = buf.readInt();
            this.sifterBlock = new ItemStorage(buf.func_150791_c());
            this.mesh = new ItemStorage(buf.func_150791_c());
            this.sievableBlocks.clear();
            this.meshes.clear();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.sievableBlocks.add(new ItemStorage(buf.func_150791_c()));
            }
            int size2 = buf.readInt();
            for (int i = 0; i < size2; ++i) {
                this.meshes.add(new ItemStorage(buf.func_150791_c()));
            }
        }

        public int getDailyQuantity() {
            return this.dailyQuantity;
        }

        public ItemStorage getSifterBlock() {
            return this.sifterBlock;
        }

        public ItemStorage getMesh() {
            return this.mesh;
        }

        public List<ItemStorage> getSievableBlocks() {
            return this.sievableBlocks;
        }

        public List<ItemStorage> getMeshes() {
            return this.meshes;
        }

        public void save(ItemStorage sifterBlock, ItemStorage mesh, int dailyQuantity, boolean buy) {
            this.sifterBlock = sifterBlock;
            this.mesh = mesh;
            Network.getNetwork().sendToServer(new SifterSettingsMessage(this, sifterBlock, mesh, dailyQuantity, buy));
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutSifter(this);
        }
    }
}

