/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.client.gui.WindowHutStoneSmelter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingSmelterCrafter;
import com.minecolonies.coremod.colony.jobs.JobStoneSmeltery;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.Optional;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class BuildingStoneSmeltery
extends AbstractBuildingSmelterCrafter {
    private static final String STONE_SMELTERY = "stonesmeltery";

    public BuildingStoneSmeltery(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return STONE_SMELTERY;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobStoneSmeltery(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return STONE_SMELTERY;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Athletics;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Dexterity;
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
        if (storage == null) {
            return false;
        }
        if (storage.getIntermediate() != Blocks.field_150460_al || storage.getInput().isEmpty()) {
            return false;
        }
        Optional<Boolean> isRecipeAllowed = super.canRecipeBeAddedBasedOnTags(token);
        return isRecipeAllowed.orElse(false);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.stoneSmelter;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Stonesmeltery", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    public static class View
    extends AbstractBuildingSmelterCrafter.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutStoneSmelter(this);
        }
    }
}

