/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.sounds.TavernSounds;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowHutTavern;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.colony.colonyEvents.citizenEvents.VisitorSpawnedEvent;
import com.minecolonies.coremod.colony.interactionhandling.RecruitmentInteraction;
import com.minecolonies.coremod.network.messages.client.colony.PlayMusicAtPosMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import org.jetbrains.annotations.NotNull;

public class BuildingTavern
extends BuildingHome {
    public static final String TARVERN_SCHEMATIC = "tavern";
    public static final String TAG_VISITOR_ID = "visitor";
    private static final int LEATHER_SKILL_LEVEL = 20;
    private static final int GOLD_SKILL_LEVEL = 25;
    private static final int IRON_SKILL_LEVEL = 30;
    private static final int DIAMOND_SKILL_LEVEL = 35;
    private static final int MAX_STORY = 20;
    private static final int TWENTY_MINUTES = 24000;
    private static final String TAG_NOVISITTIME = "novisit";
    private int musicCooldown = 0;
    private final List<Integer> externalCitizens = new ArrayList<Integer>();
    private final List<BlockPos> sitPositions = new ArrayList<BlockPos>();
    private final List<BlockPos> workPositions = new ArrayList<BlockPos>();
    private boolean initTags = false;
    private int noVisitorTime = 10000;

    public BuildingTavern(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return TARVERN_SCHEMATIC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 3;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.tavern;
    }

    @Override
    public int getMaxInhabitants() {
        if (this.getBuildingLevel() <= 0) {
            return 0;
        }
        return 4;
    }

    @Override
    public void onPlayerEnterBuilding(PlayerEntity player) {
        if (this.musicCooldown <= 0 && this.getBuildingLevel() > 0 && !this.colony.isDay()) {
            net.minecraft.util.Tuple corner1 = (net.minecraft.util.Tuple)this.getCorners().func_76341_a();
            net.minecraft.util.Tuple corner2 = (net.minecraft.util.Tuple)this.getCorners().func_76340_b();
            int x = (int)((double)((Integer)corner1.func_76341_a() + (Integer)corner1.func_76340_b()) * 0.5);
            int z = (int)((double)((Integer)corner2.func_76341_a() + (Integer)corner2.func_76340_b()) * 0.5);
            PlayMusicAtPosMessage message = new PlayMusicAtPosMessage(TavernSounds.tavernTheme, new BlockPos(x, this.getPosition().func_177956_o(), z), this.colony.getWorld(), 0.7f, 1.0f);
            for (ServerPlayerEntity curPlayer : this.colony.getPackageManager().getCloseSubscribers()) {
                Network.getNetwork().sendToPlayer(message, curPlayer);
            }
            this.musicCooldown = 24000;
        }
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
        if (this.musicCooldown > 0) {
            this.musicCooldown -= 500;
        }
        Iterator<Integer> it = this.externalCitizens.iterator();
        while (it.hasNext()) {
            Integer id = it.next();
            if (colony.getVisitorManager().getVisitor(id) != null) continue;
            it.remove();
        }
        if (this.noVisitorTime > 0) {
            this.noVisitorTime -= 500;
        }
        if (this.getBuildingLevel() > 0 && this.externalCitizens.size() < 3 * this.getBuildingLevel() && this.noVisitorTime <= 0) {
            this.spawnVisitor();
            this.noVisitorTime = colony.getWorld().func_201674_k().nextInt(3000) + 6000 / this.getBuildingLevel() * colony.getCitizenManager().getCurrentCitizenCount() / colony.getCitizenManager().getMaxCitizens();
        }
    }

    @Override
    public void onUpgradeComplete(int newlevel) {
        super.onUpgradeComplete(newlevel);
        this.initTags = false;
    }

    private void spawnVisitor() {
        IVisitorData newCitizen = (IVisitorData)this.colony.getVisitorManager().createAndRegisterCivilianData();
        this.externalCitizens.add(newCitizen.getId());
        newCitizen.setBedPos(this.getPosition());
        newCitizen.setHomeBuilding(this);
        int recruitLevel = this.colony.getWorld().field_73012_v.nextInt(10 * this.getBuildingLevel()) + 15;
        List<Tuple<Item, Integer>> recruitCosts = IColonyManager.getInstance().getCompatibilityManager().getRecruitmentCostsWeights();
        if (newCitizen.getName().contains("Ray")) {
            newCitizen.setRecruitCosts(new ItemStack((IItemProvider)Items.field_151168_bH, 64));
        }
        newCitizen.getCitizenSkillHandler().init(recruitLevel);
        BlockPos spawnPos = BlockPosUtil.findAround((IBlockReader)this.colony.getWorld(), this.getPosition(), 1, 1, bs -> bs.func_185904_a() == Material.field_151579_a);
        if (spawnPos == null) {
            spawnPos = this.getPosition();
        }
        this.colony.getVisitorManager().spawnOrCreateCivilian(newCitizen, this.colony.getWorld(), spawnPos, true);
        Tuple<Item, Integer> cost = recruitCosts.get(this.colony.getWorld().field_73012_v.nextInt(recruitCosts.size()));
        this.colony.getEventDescriptionManager().addEventDescription(new VisitorSpawnedEvent(spawnPos, newCitizen.getName()));
        if (newCitizen.getEntity().isPresent()) {
            AbstractEntityCitizen citizenEntity = newCitizen.getEntity().get();
            if (recruitLevel > 20) {
                citizenEntity.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151021_T));
            }
            if (recruitLevel > 25) {
                citizenEntity.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151151_aj));
            }
            if (recruitLevel > 30) {
                if (cost.getB() <= 2) {
                    cost = recruitCosts.get(this.colony.getWorld().field_73012_v.nextInt(recruitCosts.size()));
                }
                citizenEntity.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151167_ab));
            }
            if (recruitLevel > 35) {
                if (cost.getB() <= 3) {
                    cost = recruitCosts.get(this.colony.getWorld().field_73012_v.nextInt(recruitCosts.size()));
                }
                citizenEntity.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151175_af));
            }
        }
        newCitizen.setRecruitCosts(new ItemStack((IItemProvider)cost.getA(), (int)((double)recruitLevel * 3.0 / (double)cost.getB().intValue())));
        newCitizen.triggerInteraction(new RecruitmentInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.chat.recruitstory" + (this.colony.getWorld().field_73012_v.nextInt(20) + 1), new Object[]{newCitizen.getName().split(" ")[0]}), ChatPriority.IMPORTANT));
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        ListNBT visitorlist = new ListNBT();
        for (Integer id : this.externalCitizens) {
            CompoundNBT visitorCompound = new CompoundNBT();
            visitorCompound.func_74768_a(TAG_VISITOR_ID, id.intValue());
            visitorlist.add((Object)visitorCompound);
        }
        nbt.func_218657_a("visitors", (INBT)visitorlist);
        nbt.func_74768_a(TAG_NOVISITTIME, this.noVisitorTime);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        ListNBT visitorlist = nbt.func_150295_c("visitors", 10);
        for (INBT data : visitorlist) {
            int id = ((CompoundNBT)data).func_74762_e(TAG_VISITOR_ID);
            ICitizenData citizenData = (ICitizenData)this.colony.getVisitorManager().getCivilian(id);
            if (citizenData == null) continue;
            this.externalCitizens.add(id);
            citizenData.setHomeBuilding(this);
        }
        this.noVisitorTime = nbt.func_74762_e(TAG_NOVISITTIME);
    }

    public BlockPos getFreeSitPosition() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(this.getSitPositions());
        if (positions.isEmpty()) {
            return null;
        }
        for (Integer id : this.externalCitizens) {
            Object data = this.colony.getVisitorManager().getVisitor(id);
            if (data == null) continue;
            positions.remove(data.getSittingPosition());
        }
        if (!positions.isEmpty()) {
            return (BlockPos)positions.get(this.colony.getWorld().field_73012_v.nextInt(positions.size()));
        }
        return null;
    }

    @Override
    public void onDestroyed() {
        super.onDestroyed();
        for (Integer id : this.externalCitizens) {
            this.colony.getVisitorManager().removeCivilian((ICivilianData)this.colony.getVisitorManager().getVisitor(id));
        }
    }

    public List<Integer> getExternalCitizens() {
        return this.externalCitizens;
    }

    public BlockPos getWorkPos() {
        if (!this.getWorkPositions().isEmpty()) {
            return this.workPositions.get(this.colony.getWorld().field_73012_v.nextInt(this.workPositions.size()));
        }
        return null;
    }

    private List<BlockPos> getSitPositions() {
        this.initTagPositions();
        return this.sitPositions;
    }

    private List<BlockPos> getWorkPositions() {
        this.initTagPositions();
        return this.workPositions;
    }

    public void initTagPositions() {
        if (this.initTags) {
            return;
        }
        AbstractTileEntityColonyBuilding te = this.getTileEntity();
        if (te != null) {
            this.initTags = true;
            for (Map.Entry entry : te.getWorldTagPosMap().entrySet()) {
                if (((List)entry.getValue()).contains("sit")) {
                    this.sitPositions.add((BlockPos)entry.getKey());
                }
                if (!((List)entry.getValue()).contains("work")) continue;
                this.workPositions.add((BlockPos)entry.getKey());
            }
        }
    }

    public void removeCitizen(Integer id) {
        this.externalCitizens.remove(id);
    }

    public void setNoVisitorTime(int noVisitorTime) {
        this.noVisitorTime = noVisitorTime;
    }

    public static class View
    extends BuildingHome.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutTavern(this);
        }
    }
}

