/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.coremod.client.gui.WindowHutUniversity;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.JobResearch;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingUniversity
extends AbstractBuildingWorker {
    private static final String UNIVERSITY = "university";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final int OFFLINE_PROCESSING_LEVEL_CAP = 3;
    private final List<BlockPos> bookCases = new ArrayList<BlockPos>();
    private final Random random = new Random();

    public BuildingUniversity(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return UNIVERSITY;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return "com.minecolonies.coremod.job.researcher";
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return true;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Knowledge;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Mana;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT furnaceTagList = compound.func_150295_c("bookcase", 10);
        for (int i = 0; i < furnaceTagList.size(); ++i) {
            this.bookCases.add(NBTUtil.func_186861_c((CompoundNBT)furnaceTagList.func_150305_b(i).func_74775_l("pos")));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT bookcaseTagList = new ListNBT();
        for (BlockPos entry : this.bookCases) {
            CompoundNBT bookCompound = new CompoundNBT();
            bookCompound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)entry));
            bookcaseTagList.add((Object)bookCompound);
        }
        compound.func_218657_a("bookcase", (INBT)bookcaseTagList);
        return compound;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block == Blocks.field_150342_X) {
            this.bookCases.add(pos);
        }
    }

    @Override
    public int getMaxInhabitants() {
        return this.getBuildingLevel();
    }

    public BlockPos getRandomBookShelf() {
        if (this.bookCases.isEmpty()) {
            return this.getPosition();
        }
        BlockPos returnPos = this.bookCases.get(this.random.nextInt(this.bookCases.size()));
        if (this.colony.getWorld().func_180495_p(returnPos).func_177230_c() == Blocks.field_150342_X) {
            return returnPos;
        }
        this.bookCases.remove(returnPos);
        return this.getPosition();
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobResearch(citizen);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.university;
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
        List<ILocalResearch> inProgress = colony.getResearchManager().getResearchTree().getResearchInProgress();
        int i = 1;
        for (ILocalResearch research : inProgress) {
            if (i > this.getAssignedCitizen().size()) {
                return;
            }
            for (ICitizenData data : this.getAssignedCitizen()) {
                data.getCitizenSkillHandler().addXpToSkill(this.getSecondarySkill(), 25.0, data);
            }
            if (colony.getResearchManager().getResearchTree().getResearch(research.getBranch(), research.getId()).research(colony.getResearchManager().getResearchEffects(), colony.getResearchManager().getResearchTree())) {
                this.onSuccess(research);
            }
            ++i;
        }
    }

    public void onSuccess(ILocalResearch research) {
        for (ICitizenData citizen : this.colony.getCitizenManager().getCitizens()) {
            citizen.applyResearchEffects();
        }
        LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)("com.minecolonies.coremod.university.researchconcluded." + this.random.nextInt(3)), (Object[])new Object[]{IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getDesc()});
        this.markDirty();
    }

    @Override
    public void processOfflineTime(long time) {
        if (this.getBuildingLevel() >= 3 && time > 0L) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"entity.researcher.moreknowledge", (Object[])new Object[0]);
            for (ICitizenData citizenData : this.getAssignedCitizen()) {
                if (citizenData.getJob() == null) continue;
                citizenData.getJob().processOfflineTime(time);
            }
        }
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutUniversity(this);
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
        }

        @Override
        public boolean hasEnoughWorkers() {
            return this.getWorkerId().size() >= this.getBuildingLevel();
        }
    }
}

