/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.coremod.client.gui.WindowPostBox;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class PostBox
extends AbstractBuilding
implements IRSComponent {
    private static final String POST_BOX = "postbox";

    public PostBox(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        return ImmutableList.of();
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return POST_BOX;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 0;
    }

    @Override
    public boolean canBeGathered() {
        return false;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.postBox;
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        super.onRequestedRequestCancelled(manager, request);
        if (request.getState() == RequestState.FAILED && request.getRequest() instanceof Stack) {
            IDeliverable req = ((Stack)request.getRequest()).copyWithCount(((Stack)request.getRequest()).getCount());
            this.createRequest(req, false);
        }
    }

    public static class View
    extends AbstractBuildingView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowPostBox(this);
        }

        @Override
        @NotNull
        public ITextComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
            return new TranslationTextComponent("block.minecolonies.blockpostbox.name", new Object[0]);
        }
    }
}

