/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.citizenEvents;

import com.minecolonies.coremod.colony.colonyEvents.citizenEvents.AbstractCitizenEvent;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class CitizenDiedEvent
extends AbstractCitizenEvent {
    public static final ResourceLocation CITIZEN_DIED_EVENT_ID = new ResourceLocation("minecolonies", "citizen_died");
    private String deathCause;

    public CitizenDiedEvent() {
    }

    public CitizenDiedEvent(BlockPos eventPos, String citizenName, String deathCause) {
        super(eventPos, citizenName);
        this.deathCause = deathCause;
    }

    @Override
    public ResourceLocation getEventTypeId() {
        return CITIZEN_DIED_EVENT_ID;
    }

    @Override
    public String getName() {
        return "Citizen Died";
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74778_a("deathCause", this.deathCause);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.deathCause = compound.func_74779_i("deathCause");
    }

    @Override
    public void serialize(PacketBuffer buf) {
        super.serialize(buf);
        buf.func_180714_a(this.deathCause);
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        super.deserialize(buf);
        this.deathCause = buf.func_218666_n();
    }

    public String getDeathCause() {
        return this.deathCause;
    }

    public void setDeathCause(String deathCause) {
        this.deathCause = deathCause;
    }

    public static CitizenDiedEvent loadFromNBT(@NotNull CompoundNBT compound) {
        CitizenDiedEvent deathEvent = new CitizenDiedEvent();
        deathEvent.deserializeNBT(compound);
        return deathEvent;
    }

    public static CitizenDiedEvent loadFromPacketBuffer(@NotNull PacketBuffer buf) {
        CitizenDiedEvent deathEvent = new CitizenDiedEvent();
        deathEvent.deserialize(buf);
        return deathEvent;
    }
}

