/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.AbstractShipRaidEvent;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.NotNull;

public class PirateRaidEvent
extends AbstractShipRaidEvent {
    public static final ResourceLocation PIRATE_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "pirate_raid");
    public static final String SHIP_NAME = "pirate_ship";

    public PirateRaidEvent(@NotNull IColony colony) {
        super(colony);
    }

    @Override
    public String getShipDesc() {
        return SHIP_NAME;
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return PIRATE_RAID_EVENT_TYPE_ID;
    }

    public static IColonyEvent loadFromNBT(@NotNull IColony colony, @NotNull CompoundNBT compound) {
        PirateRaidEvent raidEvent = new PirateRaidEvent(colony);
        raidEvent.deserializeNBT(compound);
        return raidEvent;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.PIRATE;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return ModEntities.ARCHERPIRATE;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.CHIEFPIRATE;
    }

    @Override
    protected ITextComponent getDisplayName() {
        return new StringTextComponent(LanguageHandler.format((String)"com.minecolonies.coremod.raid.pirate.name", (Object[])new Object[0]));
    }
}

