/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.research.UnlockAbilityResearchEffect;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CustomRecipe {
    public static final String RECIPE_TYPE_PROP = "type";
    public static final String RECIPE_TYPE_RECIPE = "recipe";
    public static final String RECIPE_TYPE_REMOVE = "remove";
    public static final String RECIPE_ID_TO_REMOVE_PROP = "recipe-id-to-remove";
    public static final String RECIPE_CRAFTER_PROP = "crafter";
    public static final String RECIPE_INPUTS_PROP = "inputs";
    public static final String RECIPE_RESULT_PROP = "result";
    public static final String COUNT_PROP = "count";
    public static final String ITEM_PROP = "item";
    public static final String RECIPE_INTERMEDIATE_PROP = "intermediate";
    public static final String RECIPE_RESEARCHID_PROP = "research-id";
    public static final String RECIPE_EXCLUDED_RESEARCHID_PROP = "not-research-id";
    public static final String RECIPE_BUILDING_MIN_LEVEL_PROP = "min-building-level";
    public static final String RECIPE_BUILDING_MAX_LEVEL_PROP = "max-building-level";
    private String crafter = "unknown";
    private ResourceLocation recipeId = null;
    private ArrayList<ItemStack> inputs = new ArrayList();
    private ItemStack result = null;
    private Block intermediate = Blocks.field_150350_a;
    private String researchId = null;
    private String excludedResearchId = null;
    private int minBldgLevel = 0;
    private int maxBldgLevel = 5;

    private CustomRecipe() {
    }

    private static ItemStack idToItemStack(String itemData) {
        String itemId = itemData;
        int tagIndex = itemId.indexOf("{");
        String tag = tagIndex > 0 ? itemId.substring(tagIndex) : null;
        itemId = tagIndex > 0 ? itemId.substring(0, tagIndex) : itemId;
        String[] split = itemId.split(":");
        if (split.length != 2) {
            if (split.length == 1) {
                String[] tempArray = new String[]{"minecraft", split[0]};
                split = tempArray;
            } else {
                Log.getLogger().error("Unable to parse item definition: " + itemData);
            }
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0], split[1]));
        ItemStack stack = new ItemStack((IItemProvider)item);
        if (tag != null) {
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)tag));
            }
            catch (CommandSyntaxException e1) {
                Log.getLogger().error("Unable to parse item definition: " + itemData);
            }
        }
        if (stack.func_190926_b()) {
            Log.getLogger().warn("Parsed item definition returned empty: " + itemData);
        }
        return stack;
    }

    public static CustomRecipe parse(@NotNull JsonObject recipeJson) {
        CustomRecipe recipe = new CustomRecipe();
        if (recipeJson.has(RECIPE_CRAFTER_PROP)) {
            recipe.crafter = recipeJson.get(RECIPE_CRAFTER_PROP).getAsString();
        }
        if (recipeJson.has(RECIPE_INPUTS_PROP)) {
            for (JsonElement e : recipeJson.get(RECIPE_INPUTS_PROP).getAsJsonArray()) {
                JsonObject ingredient;
                if (!(e instanceof JsonElement) || !e.isJsonObject() || !(ingredient = e.getAsJsonObject()).has(ITEM_PROP)) continue;
                ItemStack stack = CustomRecipe.idToItemStack(ingredient.get(ITEM_PROP).getAsString());
                if (ingredient.has(COUNT_PROP)) {
                    stack.func_190920_e(ingredient.get(COUNT_PROP).getAsInt());
                }
                recipe.inputs.add(stack);
            }
        }
        if (recipeJson.has(RECIPE_RESULT_PROP)) {
            recipe.result = CustomRecipe.idToItemStack(recipeJson.get(RECIPE_RESULT_PROP).getAsString());
        }
        if (recipeJson.has(COUNT_PROP) && recipe.result != null) {
            recipe.result.func_190920_e(recipeJson.get(COUNT_PROP).getAsInt());
        }
        if (recipeJson.has(RECIPE_INTERMEDIATE_PROP)) {
            String[] split = recipeJson.get(RECIPE_INTERMEDIATE_PROP).getAsString().split(":");
            recipe.intermediate = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0], split[1]));
        }
        if (recipeJson.has(RECIPE_RESEARCHID_PROP)) {
            recipe.researchId = recipeJson.get(RECIPE_RESEARCHID_PROP).getAsString();
        }
        if (recipeJson.has(RECIPE_EXCLUDED_RESEARCHID_PROP)) {
            recipe.excludedResearchId = recipeJson.get(RECIPE_EXCLUDED_RESEARCHID_PROP).getAsString();
        }
        if (recipeJson.has(RECIPE_BUILDING_MIN_LEVEL_PROP)) {
            recipe.minBldgLevel = recipeJson.get(RECIPE_BUILDING_MIN_LEVEL_PROP).getAsInt();
        }
        if (recipeJson.has(RECIPE_BUILDING_MAX_LEVEL_PROP)) {
            recipe.maxBldgLevel = recipeJson.get(RECIPE_BUILDING_MAX_LEVEL_PROP).getAsInt();
        }
        return recipe;
    }

    public String getCrafter() {
        return this.crafter;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public void setRecipeId(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public boolean isValidForBuilding(IBuilding building) {
        UnlockAbilityResearchEffect requiredEffect = null;
        UnlockAbilityResearchEffect excludedEffect = null;
        IColony colony = building.getColony();
        int bldgLevel = building.getBuildingLevel();
        if (this.researchId != null) {
            requiredEffect = colony.getResearchManager().getResearchEffects().getEffect(this.researchId, UnlockAbilityResearchEffect.class);
        }
        if (this.excludedResearchId != null) {
            excludedEffect = colony.getResearchManager().getResearchEffects().getEffect(this.excludedResearchId, UnlockAbilityResearchEffect.class);
        }
        return !(this.researchId != null && requiredEffect == null || this.excludedResearchId != null && excludedEffect != null || bldgLevel < this.minBldgLevel || bldgLevel > this.maxBldgLevel);
    }

    public IRecipeStorage getRecipeStorage() {
        return StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{this.inputs, 1, this.result, this.intermediate});
    }

    public int hashCode() {
        return Objects.hash(this.result, this.researchId, this.excludedResearchId, this.inputs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomRecipe that = (CustomRecipe)o;
        return this.result.func_77969_a(that.result) && this.researchId.equals(that.researchId) && this.excludedResearchId.equals(that.excludedResearchId) && this.inputs.equals(that.inputs);
    }
}

