/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.IItemStorageFactory;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.constant.TypeConstants;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class ItemStorageFactory
implements IItemStorageFactory {
    private static final String TAG_SIZE = "size";
    private static final String TAG_STACK = "stack";

    @Override
    @NotNull
    public TypeToken<ItemStorage> getFactoryOutputType() {
        return TypeConstants.ITEMSTORAGE;
    }

    @Override
    @NotNull
    public TypeToken<FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    @NotNull
    public ItemStorage getNewInstance(@NotNull ItemStack stack, int size) {
        return new ItemStorage(stack, size, false);
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull ItemStorage storage) {
        CompoundNBT compound = new CompoundNBT();
        CompoundNBT stackTag = new CompoundNBT();
        storage.getItemStack().func_77955_b(stackTag);
        compound.func_218657_a(TAG_STACK, (INBT)stackTag);
        compound.func_74768_a(TAG_SIZE, storage.getAmount());
        return compound;
    }

    @Override
    @NotNull
    public ItemStorage deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l(TAG_STACK));
        int size = nbt.func_74762_e(TAG_SIZE);
        return this.getNewInstance(stack, size);
    }

    @Override
    public void serialize(IFactoryController controller, ItemStorage input, PacketBuffer packetBuffer) {
        packetBuffer.func_150788_a(input.getItemStack());
        packetBuffer.writeInt(input.getAmount());
    }

    @Override
    public ItemStorage deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
        ItemStack stack = buffer.func_150791_c();
        int size = buffer.readInt();
        return this.getNewInstance(stack, size);
    }

    @Override
    public short getSerializationId() {
        return 27;
    }
}

