/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorageFactory;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class RecipeStorageFactory
implements IRecipeStorageFactory {
    private static final String TAG_GRID = "grid";
    private static final String BLOCK_TAG = "block";
    private static final String INPUT_TAG = "input";

    @Override
    @NotNull
    public TypeToken<RecipeStorage> getFactoryOutputType() {
        return TypeConstants.RECIPE;
    }

    @Override
    @NotNull
    public TypeToken<? extends IToken<?>> getFactoryInputType() {
        return TypeConstants.ITOKEN;
    }

    @Override
    @NotNull
    public RecipeStorage getNewInstance(@NotNull IToken<?> token, @NotNull List<ItemStack> input, int gridSize, @NotNull ItemStack primaryOutput, Block intermediate) {
        return new RecipeStorage(token, input, gridSize, primaryOutput, intermediate);
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull RecipeStorage recipeStorage) {
        CompoundNBT compound = new CompoundNBT();
        ListNBT inputTagList = new ListNBT();
        for (ItemStack stack : recipeStorage.getInput()) {
            CompoundNBT neededRes = new CompoundNBT();
            stack.func_77955_b(neededRes);
            inputTagList.add((Object)neededRes);
        }
        compound.func_218657_a(INPUT_TAG, (INBT)inputTagList);
        recipeStorage.getPrimaryOutput().func_77955_b(compound);
        if (recipeStorage.getIntermediate() != null) {
            compound.func_218657_a(BLOCK_TAG, (INBT)NBTUtil.func_190009_a((BlockState)recipeStorage.getIntermediate().func_176223_P()));
        }
        compound.func_74768_a(TAG_GRID, recipeStorage.getGridSize());
        compound.func_218657_a("Token", (INBT)StandardFactoryController.getInstance().serialize(recipeStorage.getToken()));
        return compound;
    }

    @Override
    @NotNull
    public RecipeStorage deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        ListNBT inputTagList = nbt.func_150295_c(INPUT_TAG, 10);
        for (int i = 0; i < inputTagList.size(); ++i) {
            CompoundNBT inputTag = inputTagList.func_150305_b(i);
            input.add(ItemStack.func_199557_a((CompoundNBT)inputTag));
        }
        ItemStack primaryOutput = ItemStack.func_199557_a((CompoundNBT)nbt);
        Block intermediate = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l(BLOCK_TAG)).func_177230_c();
        int gridSize = nbt.func_74762_e(TAG_GRID);
        IToken token = (IToken)StandardFactoryController.getInstance().deserialize(nbt.func_74775_l("Token"));
        return this.getNewInstance(token, input, gridSize, primaryOutput, intermediate);
    }

    @Override
    public void serialize(IFactoryController controller, RecipeStorage input, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(input.getInput().size());
        input.getInput().forEach(stack -> packetBuffer.func_150788_a(stack));
        packetBuffer.func_150788_a(input.getPrimaryOutput());
        packetBuffer.writeBoolean(input.getIntermediate() != null);
        if (input.getIntermediate() != null) {
            packetBuffer.writeInt(Block.func_196246_j((BlockState)input.getIntermediate().func_176223_P()));
        }
        packetBuffer.writeInt(input.getGridSize());
        controller.serialize(packetBuffer, input.getToken());
    }

    @Override
    public RecipeStorage deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        int inputSize = buffer.readInt();
        for (int i = 0; i < inputSize; ++i) {
            input.add(buffer.func_150791_c());
        }
        ItemStack primaryOutput = buffer.func_150791_c();
        Block intermediate = buffer.readBoolean() ? Block.func_196257_b((int)buffer.readInt()).func_177230_c() : null;
        int gridSize = buffer.readInt();
        IToken token = (IToken)controller.deserialize(buffer);
        return this.getNewInstance(token, input, gridSize, primaryOutput, intermediate);
    }

    @Override
    public short getSerializationId() {
        return 26;
    }
}

