/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.interactionhandling;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.views.View;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.colony.interactionhandling.ModInteractionResponseHandlers;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.client.gui.WindowCitizen;
import com.minecolonies.coremod.client.gui.WindowRequestDetail;
import com.minecolonies.coremod.colony.interactionhandling.ServerCitizenInteraction;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class RequestBasedInteraction
extends ServerCitizenInteraction {
    private static final String TOKEN_TAG = "token";
    private static final Tuple<ITextComponent, ITextComponent>[] tuples = new Tuple[]{new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.okay", new Object[0]), null), new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.remindmelater", new Object[0]), null), new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.cancel", new Object[0]), null), new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.fulfill", new Object[0]), null)};
    private static final Tuple<ITextComponent, ITextComponent>[] tuplesAsync = new Tuple[]{new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.okay", new Object[0]), null), new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.ignore", new Object[0]), null), new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.remindmelater", new Object[0]), null), new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.skipchitchat", new Object[0]), null)};
    private IToken<?> token = null;
    private BiPredicate<ICitizenData, IToken<?>> validator;

    public RequestBasedInteraction(ITextComponent inquiry, IChatPriority priority, ITextComponent validator, IToken<?> token) {
        super(inquiry, true, priority, null, validator, priority == ChatPriority.BLOCKING ? tuples : tuplesAsync);
        this.validator = InteractionValidatorRegistry.getTokenBasedInteractionValidatorPredicate(validator);
        this.token = token;
    }

    public RequestBasedInteraction(ITextComponent inquiry, IChatPriority priority, IToken<?> token) {
        super(inquiry, true, priority, null, inquiry, tuples);
        this.validator = InteractionValidatorRegistry.getTokenBasedInteractionValidatorPredicate(inquiry);
        this.token = token;
    }

    public RequestBasedInteraction(ICitizen data) {
        super(data);
    }

    @Override
    public List<IInteractionResponseHandler> genChildInteractions() {
        return Collections.emptyList();
    }

    @Override
    public boolean isValid(ICitizenData citizen) {
        return this.validator == null && !this.parents.isEmpty() || this.validator != null && this.validator.test(citizen, this.token);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT tag = super.serializeNBT();
        tag.func_218657_a(TOKEN_TAG, (INBT)StandardFactoryController.getInstance().serialize(this.token));
        return tag;
    }

    @Override
    public void deserializeNBT(@NotNull CompoundNBT compoundNBT) {
        super.deserializeNBT(compoundNBT);
        this.token = (IToken)StandardFactoryController.getInstance().deserialize(compoundNBT.func_74775_l(TOKEN_TAG));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWindowOpened(Window window, ICitizenDataView dataView) {
        IRequest<?> request;
        IColonyView colony = IColonyManager.getInstance().getColonyView(dataView.getColonyId(), Minecraft.func_71410_x().field_71439_g.field_70170_p.func_201675_m().func_186058_p().func_186068_a());
        if (colony != null && (request = colony.getRequestManager().getRequestForToken(this.token)) != null) {
            View group = (View)window.findPaneOfTypeByID("interactionView", View.class);
            ItemIcon icon = (ItemIcon)window.findPaneOfTypeByID("request_item", ItemIcon.class);
            if (icon == null) {
                icon = new ItemIcon();
                group.addChild((Pane)icon);
            }
            icon.setID("request_item");
            icon.setSize(32, 32);
            if (!request.getDisplayStacks().isEmpty()) {
                icon.setItem(request.getDisplayStacks().get(0));
            }
            icon.setPosition(30, 60);
            icon.setVisible(true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClientResponseTriggered(ITextComponent response, PlayerEntity player, ICitizenDataView data, Window window) {
        if (response.equals(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.fulfill", new Object[0]))) {
            IRequest<?> request;
            IColonyView colony = IColonyManager.getInstance().getColonyView(data.getColonyId(), player.field_70170_p.func_201675_m().func_186058_p().func_186068_a());
            if (colony != null && (request = colony.getRequestManager().getRequestForToken(this.token)) != null) {
                WindowCitizen windowCitizen = new WindowCitizen(data);
                windowCitizen.open();
                windowCitizen.goToRequestList();
                WindowRequestDetail windowRequestDetail = new WindowRequestDetail(windowCitizen, request, data.getColonyId());
                windowRequestDetail.open();
                return false;
            }
        } else {
            return super.onClientResponseTriggered(response, player, data, window);
        }
        return true;
    }

    @Override
    public void onServerResponseTriggered(ITextComponent response, PlayerEntity player, ICitizenData data) {
        super.onServerResponseTriggered(response, player, data);
        if (response.equals(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.cancel", new Object[0])) && data.getColony() != null) {
            data.getColony().getRequestManager().updateRequestState(this.token, RequestState.CANCELLED);
        }
    }

    @Override
    protected void loadValidator() {
        this.validator = InteractionValidatorRegistry.getTokenBasedInteractionValidatorPredicate(this.validatorId);
    }

    @Override
    public String getType() {
        return ModInteractionResponseHandlers.REQUEST.func_110623_a();
    }
}

